unit fileu;{fileproc}
{procedure pro operace se soubory a drivy}
{ Value dosError(ioerror)
   2    File not found
   3    Path not found
   5    Access denied
   6    Invalid handle
   8    Not enough memory
  10    Invalid environment
  11    Invalid format
  18    No more files
}
{$I define.pas}
{$I-}
interface
uses
  WinProcs, SysUtils, Classes,
  MyType, TVType, IOType, Stru, MyLib,
  Compareu, {$IFNDEF WIN32}ForEach,{$ENDIF}
  Msgu
 ;

type
  Tfileattr=record
    ro,hidden,sys,vol,subdir,arch:boolean
  end;

const
{  ioError:integer=0;nastavuje se na hodnotu ioresult pri chybach, v mylib}
  ioOutOfMemory = -100;

function GetConfigFilesCount:integer;{returns max number of files that
can be open at the same time}


function GetTempFileName: PathStr; {gets unique temporary file name in current dir}
function GetTempFileNameInDir(ADir:DirStr): PathStr;
         {gets unique temporary file name in specified dir}
         {mfiles.tpu}
function GetFileTime(FileName: PathStr): LongInt;
function SetFileTime(FileName:PathStr; L:LongInt):boolean;

procedure TouchFile(var f:file);
function FileIsOpen(var f:file):boolean;

function GetFileSize(FileName: PathStr): LongInt;


function FioError:boolean; {last File I/O Error}

{nastavuje ioError na hodnotu ioresult, vraci true pro chybu}

function EraseFile(const AFileName:String):boolean;{$IFDEF PMODE}export;{$ENDIF}

function EraseFiles(AMask:PathStr):boolean;


function RenameFile(const oldname:string; const newname:string):boolean;{$IFDEF PMODE}export;{$ENDIF}


function CopyFile(sourc,dest:pathstr):boolean;
{kopirovani souboru, bez kontrol, nevykona se nic,
 vraci se ioError > 0 pri chybe, prepisuje se cilovy soub. bez dotazu}
function CompareFiles(AFileName1, AFileName2:PathStr):boolean;{checks if the files are equal}
procedure MoveFile(source:pathstr; dir:dirstr);{moves file source to dir dir}
function CreateFile(const Name:string):boolean;{$IFDEF PMODE}export;{$ENDIF}
{creates new file with size=0; returns ioerror>0 in the case of an error}

function GetLenchs(sourc:pathstr;var len:longint;var chs:word):boolean;

function DriveCharToDriveNumber(ADrive:char):byte;

function FreeDiskSpace(Drive:char):longint;
{vraci pocet volnych bytu v drivu drive}

{$IFNDEF WINDOWS}

procedure getfileattr(name:pathstr; var fileattr:tfileattr; var error:boolean);
{zjisteni attributu filu}

procedure setfileattr(name:pathstr;var fileattr:tfileattr);
{nastaveni atributu ro,hidden,sys,arch souboru name}
{$ENDIF}
function BakName(orig:pathstr):pathstr;

procedure AppendFile(Source, Dest: Pathstr);
{appends source to dest}



procedure PushDir(Dir : DirStr);

procedure PopDir;

function FindUtlFile(const AFile : string): string;{in curdir, exedir and path}

function FindFileMaskInDir(AMask:PathStr; ADir:DirStr):PathStr;
{e.g. '*.COM', 'C:\DOS', returns first C:\DOS\xxxx.COM file found in dos dir}
{$IFDEF WINDOWS}
function FSearch(AMask:string; DirList:string):string;
{$ENDIF}


function SameNameAndExt(f1, f2: PathStr):boolean;

function DirExists(Dir : string): boolean;

function CreateDir(Dir : string): boolean;{$IFDEF PMODE}export;{$ENDIF}

function DeleteDir(ADir:DirStr):boolean;

{$IFNDEF WINDOWS}
function GetTmpDir: DirStr;
{$ENDIF}

function GetFilesDiskNum(AFileName:PathStr):byte; {gets number of disk the file is on}

function IsDiskReady(AName:PathStr):boolean;

{$IFNDEF WINDOWS}
function TrueName(s:string):string;
{undocumented DOS function TRUENAME, returns real dos name for
a file S, cuts to 8.3 format, converts to uppercase,
expands . and .., expands network drives to the form
\\nodename\path\file}
function IsNetworkFile(s:string):boolean;
{$ENDIF}
function ScanTextFile(AName:PathStr; var Size : Longint; var Words: word; var Lines : word; var MaxLineLength : word):boolean;
var
  infile, outfile : array [0..127] of char;

{increments filename, ie. adds last number of base name e.g.:
  name.ext -> name1.ext
  namexxxx.ext -> namexxx1.ext
  namexxx1.ext -> namexxx2.ext
}
function IncFileName(AName:PathStr):PathStr;

function IsMonthFileName(APrefix, AName:PathStr):boolean;
{true if AName contains APrefix string at its beginning and continues
with numbers (i.e. 9505 etc)}

function GetFileStatus(AFileName:PathStr; var AStatus:integer):boolean;
{true if file found, in AStatus is open state, error}


function DelBackSlash(Dir : DirStr) : DirStr;
function AddBackSlash(Dir : DirStr): DirStr;
function ReplaceExt(FileName: PathStr; NExt: ExtStr; Force: Boolean):Pathstr;
function ReplaceDir(FileName: PathStr; NewDir: DirStr; Force:boolean):PathStr;

function GetEXEName:PathStr;
function GetEXEDir : DirStr;
function GetFileBaseName(AFileName:PathStr):NameStr;
function GetFileExt(AFileName:PathStr):ExtStr;
function GetFileDir(AFileName:PathStr):DirStr;
function GetFileDirAndName(AFileName:PathStr):PathStr;
function GetFileBaseNameAndExt(AFileName:PathStr):PathStr;

procedure MChDir(Dir : DirStr);

{function FExists(FileName: PathStr): Boolean;}

function ConvStreamName(AFileName:PathStr):PathStr;

{$IFNDEF WINDOWS}
function configfiles(count:word):boolean;
{$ENDIF}

{$IFNDEF WIN32}
function CountFilesWithMask(AMask:string; FindAttr, MatchAttr:byte; Recursive:boolean):longint;
{$ENDIF}
{$IFDEF PMODE}export;{$ENDIF}

{$IFDEF WINDOWS}
function FExpand (Path: String): String;
{$ENDIF}


const
  ioError:integer=0;{nastavuje se na hodnotu ioresult pri chybach}

function GetModuleName(AInstance:TInstance):string;{$IFDEF PMODE}export;{$ENDIF}
function GetFileNamePart(fp:TFileNamePart; const AFileName:String):string;
{$IFDEF PMODE}export;{$ENDIF}
function ReplaceFileNamePart(fp:TFileNamePart; const AFileName:string;
  const ANewPartName:string; ForceEvenIfPresent:boolean):string;
{$IFDEF PMODE}export;{$ENDIF}
function GetFilePropInt(fp:TFileProperty; const AFileName:string):longint;
{$IFDEF PMODE}export;{$ENDIF}

implementation
{$IFDEF SYSLOG}
{  uses syslog
  ;}
{$ENDIF}
{$IFDEF WINDOWS}
uses dateu;
{$ENDIF}
const
  TempDir:PString = nil;
var
  DirStack:TList;{TStringStack;}
const
  DirStackInited:boolean = false;

function GetConfigFilesCount:integer;
var
  f: array[1..100] of ^file;
  i,j:integer;
  fn:PathStr;
  e:integer;
begin
  for i := 1 to 100 do begin
    new(f[i]);
    if f[i] = nil then
      break;
    fn := GetTempFileName;
    assign(f[i]^, fn);
    rewrite(f[i]^,0);
    e := ioresult;
    if e <> 0 then begin
      dispose(f[i]);
      break;
    end;
  end;
  dec(i);
  GetConfigFilesCount := i;
  for j := 1 to i do begin
    if f[j] <> nil then begin
      close(f[j]^);
      erase(f[j]^);
      dispose(f[j]);
    end;
  end;
  if ioresult <> 0 then;
end;


function GetTempFileName: PathStr; {gets unique temporary file name}
var fn : PathStr;
    cnt, no:integer;
    nost:string[8];
begin
  no := 0;
  cnt := 0;
  repeat
    str(no, nost);
    fn := 'TMP' + nost + '.$$$';
    if TempDir <> nil then
      fn := {v0.39}AddBackSlash{/v0.39}(TempDir^) + fn;
    fn := FExpand(fn);
    inc(no);
    inc(cnt);
    if cnt = 1000 then begin
      fn := '';
      break;
    end;
  until not FExists(fn);
  GetTempFileName := fn;
end;

function GetTempFileNameInDir(ADir:DirStr): PathStr; {gets unique temporary file name}
begin
  TempDir := NewStr(ADir);
  GetTempFileNameInDir := GetTempFileName;
  if TempDir <> nil then
    DisposeStr(TempDir);
  TempDir := nil;
end;

{$IFDEF WIN32}
function GetFileTime(FileName: PathStr): LongInt;
var
  f:file;
  l:longint;
begin
  assign(f,FileName);
  reset(f);
  ioError := ioresult;
  if ioError <> 0 then begin
    l:=0
  end else begin
    l := FileGetDate(TFileRec(f).Handle);
    {GetFTime(f,l);{dateu windows sysutil}
    ioError := ioresult;
  end;
  GetFileTime:= l;
  if TFileRec(f).Mode <> fmClosed then
    close(f);
end;

function SetFileTime(FileName:PathStr; L:LongInt):boolean;
var
  f:file;
label ex;
begin
  SetFileTime := false;
  assign(f,FileName);
  reset(f);
  if fioError then
    goto ex
  else begin
    FileSetDate(TFileRec(f).Handle, l);
    close(f);
    if fioError then
      goto ex
  end;
  SetFileTime := true;
ex:
  if TFileRec(f).Mode <> fmClosed then
    close(f);
end;
{$ELSE}
function GetFileTime(FileName: PathStr): LongInt;
var
  f:file;
  l:longint;
begin
  assign(f,FileName);
  reset(f);
  ioError := ioresult;
  if ioError <> 0 then begin
    l:=0
  end else begin
    GetFTime(f,l);{dateu}
    ioError := ioresult;
  end;
  GetFileTime:= l;
  if FileRec(f).Mode <> fmClosed then
    close(f);
end;

function SetFileTime(FileName:PathStr; L:LongInt):boolean;
var
  f:file;
label ex;
begin
  SetFileTime := false;
  assign(f,FileName);
  reset(f);
  if fioError then
    goto ex
  else begin
    SetFTime(f,l);
    close(f);
    if fioError then
      goto ex
  end;
  SetFileTime := true;
ex:
  if FileRec(f).Mode <> fmClosed then
    close(f);
end;
{$ENDIF}

procedure TouchFile(var f:file);
{$IFNDEF WIN32}
var
  DT:DateTime;
  dow:word;
  l:longint;
{$ENDIF}
begin
  {$IFNDEF WIN32}
  GetDate (DT.Year, DT.Month, DT.Day, dow);
  GetTime(DT.Hour, DT.Min, DT.Sec, dow);
  PackTime(DT,l);
  if TFileRec(f).Mode <> fmClosed then
    SetFTime(f, l);
  {$ENDIF}
end;

function FileIsOpen(var f:file):boolean;
begin
  FileIsOpen := false;
  case TFileRec(f).mode of {tfilerec}
    FMinput, FMOutput, FMinout: FileIsOpen := true;
  end;
end;

function GetFileSize(FileName: PathStr): LongInt;
var f:file; l:longint;
begin
  assign(f,FileName);
  reset(f, 1);
  ioError:= ioresult;
  if ioError <> 0 then
    l:=0
  else begin
    l:= FileSize(f);
    close(f);
    ioError := ioresult;
  end;
  GetFileSize:= l;
end;




function fioerror{:boolean};
begin
  ioError:=ioresult;
  fioError := (ioError <> 0);
end;

function EraseFile(const AFileName:String):boolean;
var f:file;
begin
  Assign(f,AFileName);
  Erase(f);
  ioError := ioresult;
{$IFDEF SYSLOG}
{$IFDEF DEBUG}
  if ioerror <> 0 then begin
    {$IFNDEF WINDOWS}
    writeln('Error erasing file ' + AFileName + ' ErID:' + IntToStr(ioerror));
    {$ENDIF}
  end;
{$ENDIF}
{$ENDIF}
  EraseFile := (ioerror = 0);
end;

function EraseFiles(AMask:PathStr):boolean;

var
  ADir:DirStr;
  N:NameStr;
  E:ExtStr;
{$IFDEF WINDOWS}
  DosError:integer;
  DirInfo:TSearchRec;
{$ELSE}
  DirInfo:SearchRec;
{$ENDIF}
  fn:string;
begin
  EraseFiles := false;
  FSplit(AMask, ADir, N, E);
  fn := ADir + N + E;
  {$IFDEF WINDOWS} DosError:= {$ENDIF}
  FindFirst((fn), faArchive, DirInfo);
  while DosError = 0 do
  begin
    if not EraseFile(ADir + DirInfo.Name) then
      exit;
    {$IFDEF WINDOWS}
    DosError:=
    {$ENDIF}
    FindNext(DirInfo);
  end;
  {$IFDEF WINDOWS}
  FindClose(DirInfo);
  {$ENDIF}
  EraseFiles := true;
end;

function RenameFile(const oldname:string; const newname:string):boolean;
var f:file;
begin
  assign(f,oldname);
  rename(f,newname);
  ioError := ioresult;
{$IFDEF SYSLOG}
{$IFDEF DEBUG}
  if ioerror <> 0 then
    writeln({syslog.log(slDebug, }'Error renaming file ' + OldName + ' to ' + NewName + ' ErID:' + IntToStr(ioerror));
{$ENDIF}
{$ENDIF}
  renamefile := (ioerror = 0);
end;

function CompareFiles(AFileName1, AFileName2:PathStr):boolean;{checks if the files are equal}
const
  BufSize = 1024;
type
 tbuf = array[0..BufSize - 1] of byte;
var
  f1,f2:file;
  b1,b2:^tbuf;
  l,r:longint;

label er, me;
begin
  CompareFiles := false;
  new(b1); new(b2);
  if (b1 = nil) or (b2 = nil) then begin
    ioError := 8;
    exit;
  end;
  assign(f1, AFileName1);
  assign(f2, AFileName2);
  reset(f1,1);
  if fioError then
    goto me;
  reset(f2,1);
  if fioError then begin
    close(f1);
    goto me;
  end;
  l := FileSize(f1);
  if l <> FileSize(f2) then
    goto er;

  if l > 0 then
  repeat
    r := BufSize;
    if r > l then
      r := l;
    blockread(f1, b1^, r);
    if fioerror then
      goto er;
    blockread(f2, b2^, r);
    if fioerror then
      goto er;
    if comparerec(b2^, b1^, r) <> 0 then
      goto er;
    dec(l, r);
  until l = 0;
  CompareFiles := true;
er:
  close(f1);
  close(f2);
me:
  Dispose(b1);
  Dispose(b2);
end;

function copyfile(sourc,dest:pathstr):boolean;
{kopirovani souboru, bez kontrol, nevykona se nic,
 vraci se ioerror>0 pri chybe}
const
  buflen=10240;

type
  tbuf=array[1..buflen]of byte;

var
  s,d:file;
  rr:integer;
  buf:^tbuf;
  time:longint;
  LastFileMode:word; {filemode}
label ex,ex1;

begin
  CopyFile := false;
  Sourc := FExpand(Sourc);
  Dest := FExpand(Dest);
  if Sourc = Dest then
    exit;

  ioerror:=0;
  new(buf);
  if buf = nil then begin
    ioerror := 8; {not enough memory, see begining of this file}
    exit;
  end;
  assign(s,sourc);
  LastFileMode := FileMode;
  FileMode := fmReadOnly + fmDenyNone;
  reset(s,1);
  FileMode := LastFileMode;
  if fioerror then
    goto ex;
  Time := FileGetDate(TFileRec(s).Handle);{GetFTime(s, Time);}
  assign(d,dest);
  rewrite(d,1);
  if fioerror then begin
    close(s);
    goto ex;
  end;
  blockread(s,buf^,buflen,rr);
  if fioerror then
    goto ex1;
  while rr>0 do begin
    blockwrite(d,buf^,rr);
    if fioerror then
      goto ex1;
    blockread(s,buf^,buflen,rr);
    if fioerror then
      goto ex1;
  end;
ex1:
  close(s);
  FileSetDate(TFileRec(d).Handle, Time);{ SetFTime(d,Time);}
  close(d);

ex:
  Dispose(buf);
  CopyFile := (ioError = 0);
end;


procedure MoveFile(source:pathstr;dir:dirstr);{moves file souce to dir dirl}
var
  d:dirstr;
  n:namestr;
  e:extstr;
  dest:pathstr;
begin
  source := FExpand(source);
  fsplit(source, d, n, e);
  dest := FExpand(addbackslash(dir) + n + e);
  if dest = source then
    exit;
  copyfile(source, dest);
  if ioError = 0 then
    EraseFile(source);
end;

function CreateFile(const Name:string):boolean;
var f:file;
begin
  CreateFile := false;
  assign(f,name);
  rewrite(f);
  if fioerror then
    exit;
  close(f);
  CreateFile := true;
end;

function getlenchs{(sourc:pathstr;var len:longint;var chs:word)};
{vraci delku a kontrolni soucet souboru sourc}
const
  buflen=10240;

type
  tbuf=array[1..buflen]of byte;

var
  s:file;
  rr,j:integer;
  buf:^tbuf;

label
  ex,ex1;

begin
  GetLenChs := false;
  len := 0;
  chs := 0;
  ioError := 0;
  new(buf);
  if buf = nil then
    exit;
  assign(s,sourc);

  reset(s,1);
  if fioerror then
    goto ex;

  blockread(s,buf^,buflen,rr);
  if fioerror then
    goto ex1;
{writeln(' za blockread ve files.getlenchk',rr);readln;}
  while rr>0 do begin
    for j:=1 to rr do chs:=chs+buf^[j];
    blockread(s,buf^,buflen,rr);
    if fioerror then
      goto ex1;
  end;
  len:=filesize(s);
  GetLenChs := true;
ex1:
  close(s);
ex:
  dispose(buf);
end;

function DriveCharToDriveNumber(ADrive:char):byte;
begin
  DriveCharToDriveNumber := ord(Upcase(ADrive)) - ord('A');
end;

function freediskspace{(drive:char):longint};
{vraci pocet volnych bytu v drivu drive}
{$IFNDEF WINDOWS}
var
  regs:registers;
begin
  fillchar(regs,sizeof(regs),0);
  with regs do begin ah:=$36; dl:=ord(upcase(drive))-64;end;
  msdos(regs);
  with regs do if ax=$ffff then freediskspace:=-1 else
  freediskspace:=longint(ax)*bx*cx;
end;
{$ELSE}
var i:integer;
begin
  i := ord(upcase(drive)) - ord('A') + 1;
  if i < 0 then
    i := 0;
  FreeDiskSpace := DiskFree(i);
end;
{$ENDIF}

{$IFNDEF WINDOWS}
procedure getfileattr(name:pathstr; var fileattr:tfileattr; var error:boolean);
{zjisteni attributu filu}
var regs:registers;
begin
  fillchar(regs,sizeof(regs),0);
  name:=name+#0;
  with regs,fileattr do begin
    ah:=$43;
    ds:=seg(name);
    dx:=ofs(name)+1;
    msdos(regs);
    ioerror:=al;{global var of files.tpu}
    error:= (al in [2,3,5]);
    ro:=(cl and $01)>0;
    hidden:=(cl and $02)>0;
    sys:=(cl and $04)>0;
    vol:=(cl and $08)>0;
    subdir:=(cl and $10)>0;
    arch:=(cl and $20)>0;
  end;
end;

procedure setfileattr{(name:pathstr;var fileattr:tfileattr)};
var regs:registers;
begin
  fillchar(regs,sizeof(regs),0);
  name:=name+#0;
  with regs,fileattr do begin
    ah:=$43;
    al:=1;
    ds:=seg(name);
    dx:=ofs(name)+1;
    if ro then cl:=(cl or $01);
    if hidden then cl:=(cl or $02);
    if sys then cl:=(cl or $04);
    if arch then cl:=(cl or $20);
  end;
  msdos(regs);
end;

{$ENDIF}
function BakName(orig:pathstr):pathstr;
{replaces extension with .bak}
var
  D:DirStr; N:Namestr; E:Extstr;
begin
  fsplit(orig,d,n,e);
  bakname:=d+n+'.BAK';
end;

procedure AppendFile(Source, Dest: Pathstr);
{appends source to dest}
const
  buflen=10000;
type
  tbuf=array[1..buflen]of byte;
var s,d:file;rr:integer;
    buf:^tbuf;
label ex,ex1;
begin
  ioerror:=0;
  new(buf);
  if buf = nil then begin
    ioError:= ioOutOfMemory;
    exit;
  end;
  assign(s,source);
  reset(s,1);
  if fioerror then
    goto ex;

  assign(d,dest);
  reset(d,1);
  if ioresult = 0 then begin
    seek(d,filesize(d));
  end else begin
    rewrite(d, 1);
  end;
  if FioError then begin
    close(s);
    if FioError then;
    goto ex;
  end;

  blockread(s,buf^,buflen,rr);
  if FioError then goto ex1;
  while rr>0 do begin
    blockwrite(d,buf^,rr);
    if FioError then
      goto ex1;
    blockread(s,buf^,buflen,rr);
    if fioerror then
      goto ex1;
  end;
ex1:
  close(s);
  close(d);
ex:
  Dispose(buf);
end;


procedure PushDir(Dir : DirStr);
var
  LastDir : DirStr;
begin
  GetDir(0, LastDir);
  MChDir(Dir);
  if ioresult= 0 then begin
    if not DirStackInited then begin
      DirStackInited := true;
      DirStack := TList.Create;
      DirStack.Capacity := 10;
    end;
    DirStack.Add(NewStr(LastDir));
  end;
end;

procedure PopDir;
var
  LastDir : DirStr;
  s:string;
  p:PString;
begin
  if not DirStackInited then begin
    DirStackInited := true;
    DirStack := TList.Create;
    DirStack.Capacity := 10;
  end;
  if DirStack.Count > 0 then begin
    p := DirStack.Items[DirStack.Count - 1];
    s := GetString(p);
    DirStack.Remove(p);
    DisposeStr(p);

    LastDir := s;
    MChDir(LastDir);
  end;
end;

function FindFileMaskInDir(AMask:PathStr; ADir:DirStr):PathStr;
var
  d:dirstr;
  n:namestr;
  e:extstr;
  fn:string;
  {$IFDEF WINDOWS}
  DosError:integer;
  DirInfo:TSearchRec;
  {$ELSE}
  DirInfo:SearchRec;
  {$ENDIF}
begin
  FSplit(AMask, d, n, e);
  ADir := AddBackSlash(ADir);
  fn := ADir + N + E;

  {$IFDEF WINDOWS}
  DosError := { StrPCopy(fn, ADir + N + E);}
  {$ELSE}
  {$ENDIF}
  FindFirst(fn, faArchive, DirInfo);
  if DosError = 0 then
  begin
    FindFileMaskInDir := ADir + DirInfo.Name;
  end else
    FindFileMaskInDir := '';
  {$IFDEF WINDOWS}
  FindClose(DirInfo);
  {$ENDIF}
{  FindFileInDirs := FSearch(AMask, ADirs);}
end;
{$IFDEF WINDOWS}
function FSearch(AMask:string; DirList:string):string;
begin
  FSearch := SysUtils.FileSearch(AMask, DirList);
end;
{$ENDIF}

function FindUtlFile(const AFile : string): string;
var
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  S : String;
  FN:String;
begin
  FSplit(AFile, Dir, Name, Ext);
  FN := Name + Ext;
  FN := Name + Ext;
  S := '.;' + DelBackSlash(GetExeDir)
    {$IFNDEF WINDOWS}
    +';' + GetEnv('PATH')
    {$ENDIF}
    ;
  if (Dir <> '') then S := DelBackSlash(Dir) + ';' + S;
  FN := FSearch(FN, S);
  if FN <> '' then
    FindUtlFile := FExpand(FN)
  else
    FindUtlFile := '';
end;


function SameNameAndExt(f1, f2: PathStr):boolean;
var d1,d2:dirstr;
    n1,n2:namestr;
    e1,e2:extstr;
begin
  fsplit(f1,d1,n1,e1);
  fsplit(f2,d2,n2,e2);
  if n1+e1 = n2+e2 then
    SameNameAndExt := true
  else
    SameNameAndExt := false;
end;

function DirExists(Dir : string): boolean;
var {d:dirstr;
    n:namestr;
    e:extstr;}
{$IFDEF WINDOWS}
   DosError:integer;
   sr:TSearchRec;
{$ELSE}
   sr:SearchRec;
{$ENDIF}
label ff;
begin
  Dir := DelBackSlash(Dir);

  if (length(dir) <= 3) and (length(dir) >= 2) then begin
    if (dir[2] = ':') then begin
      if ((length(dir) = 3) and (dir[3] <> '\')) then
        goto ff;
      if IsDiskReady(Dir) then
        DirExists := true
      else
        DirExists := false;
      exit;
    end;
  end;

ff:
  {$IFDEF WINDOWS}
  DosError :=
  {$ENDIF}
  FindFirst(Dir, faDirectory, SR);{mytype}
  if DosError = 0 then
    DirExists := true
  else
    DirExists := false;
end;

function CreateDir(Dir : string): boolean;
var
  len : byte;
  p : byte {absolute Dir};
  SDir : DirStr;
  Disk : string[2];
  make : boolean;

begin
  CreateDir := false;
  Dir := DelBackSlash(Dir);

  if (length(Dir) >= 2) and (Dir[2] = ':') then begin
    Disk := copy(Dir, 1, 2);
    Dir := copy(Dir, 3, length(Dir) - 2);
  end else begin
    Disk := '';
  end;
  len := length(Dir);
  if len = 0 then begin
    if disk <> '' then begin
      if DirExists(disk + '\') then   {try to find out if disk exists}
        CreateDir := true;
    end else
      CreateDir := true; {noname = current dir always exists, no need to create anything}
    exit;
  end;
  p := 0;
  repeat
    inc(p);
    make := false;
    if (Dir[p] = '\') and (p <> len) then begin
      SDir := copy(Dir, 1, pred(p));
      if SDir <> '' then
        make := true;
    end else if p = len then begin
      SDir := Dir;
      make := true;
    end;
    if make then begin
      if not DirExists(disk + sdir) then begin
        MkDir(disk + SDir);
        if IOResult <> 0 then
          exit;
      end;
    end;
  until p = len;
  CreateDir := true;
end;

function DeleteDir(ADir:DirStr):boolean;
{var
  DirInfo:SearchRec;}
begin
  DeleteDir := false;
  if not DirExists(ADir) then
    exit;
  ADir := AddBackSlash(ADir);

  EraseFiles(ADir + '*.*');
  ADir := DelBackSlash(ADir);
  RmDir(ADir);
  ioError := ioResult;
end;

{$IFNDEF WINDOWS}
function GetTmpDir: DirStr;
var tmp:DirStr;

  function CheckTmpDir(t:DirStr): DirStr;
  begin
    if t <> '' then begin
      if not DirExists(t) then
        if not CreateDir(t) then
          t:= '';
    end;
    CheckTmpDir := t;
  end;

begin
  tmp := GetEnv('TMP');{sysutils winprocs}
  tmp := CheckTmpDir(tmp);
  if tmp = '' then begin
    tmp := GetEnv('TEMP');
    tmp := CheckTmpDir(tmp);
  end;
  GetTmpDir := tmp;
end;
{$ENDIF}
function GetFilesDiskNum(AFileName:PathStr):byte; {gets number of disk the file is on}
var d:dirstr; n:namestr; e:extstr;
  diskno:byte;
begin
  FSplit(AFileName, d, n, e);
  if d = '' then
    diskno := 0
  else
    diskno :=  ord(upcase(d[1])) - ord('A') + 1;
  GetFilesDiskNum := diskno;
end;

function IsDiskReady(AName:PathStr):boolean;
var diskno:integer;
begin
  diskno := GetFilesDiskNum(AName);
  if (DiskSize(diskno) = -1) then
    IsDiskReady := false
  else
    IsDiskReady := true;
end;


{$IFNDEF WINDOWS}
function TrueName(s:string):string;
{undocumented DOS function TRUENAME, returns real name for
a file S, converts to uppercase, expands . and .., expands
network drives to the form \\nodename\path\file}
var
  regs:registers;
  ls, lo, l : longint;

{
The Flag constants (fXXXX) test individual
flag bits in the Flags register after a call
to Intr or MsDos.

 Constant    Value
 
 fCarry      $0001
 fParity     $0004
 fAuxiliary  $0010
 fZero       $0040
 fSign       $0080
 fOverflow   $0800
}
begin
  FillChar(infile, 128, 0);
  FillChar(outfile, 128, 0);
  if s <> '' then begin
    Move(s[1],infile,length(s));
    regs.ah := $60; {TRUENAME func.}
    regs.ds := seg(infile);
    regs.si := ofs(infile);

    regs.es := seg(outfile);
    regs.di := ofs(outfile);
    Intr($21, regs);
    if (regs.flags and fCarry) = 0 then begin
      s:= StrPas(outfile);
    end;
  end;
  TrueName := s;
end;

function IsNetworkFile(s:string):boolean;
begin
  IsNetworkFile := false;
  s := TrueName(s);
  if (s <> '') and (s[1] = '\') then
    IsNetworkFile := true;
end;
{$ENDIF}
const
  Delimiters : SetOfChar = [' ', ';', ',', ':', '?', '"', '!', '/', chr(39)];

function ScanTextFile(AName:PathStr; var Size : Longint; var Words: word; var Lines : word; var MaxLineLength : word):boolean;
var
  fb:file of byte;
  f:text;
  s:string;
  i:word;
  inword : boolean;
begin
  ScanTextFile := false;
{  inword := false;}
  Words := 0;
  Lines := 0;
  MaxLineLength := 0;

  assign(fb,AName);
  reset(fb);
  if fioError then
    exit;
  Size := FileSize(fb);
  close(fb);
  if fioError then
    exit;

  assign(f,AName);
  reset(f);
  if fioError then
    exit;

  while not eof(f) do begin
    readln(f,s);
    inc(lines);

    if length(s) > MaxLineLength then
      MaxLineLength := length(s);
    inword := false;
    for i := 1 to length(s) do begin
      if not (s[i] in Delimiters) then begin
        if not inword then begin
          inc(words);
          inword := true;
        end;
      end else
        inword := false;
    end;
  end;
  Close(f);
  if ioresult <> 0 then
    exit;
  ScanTextFile := true;
end;

{increments filename, ie. adds last number of base name e.g.:
  name.ext -> name1.ext
  namexxxx.ext -> namexxx1.ext
  namexxx1.ext -> namexxx2.ext}
function IncFileName(AName:PathStr):PathStr;
var
 d:dirstr;
 n:namestr;
 e:extstr;
 num:namestr;
 numval:LongInt;
 base:namestr;
 i:byte;
{ lastnumlen:byte;}
 code:integer;
const
  namemaxlen = sizeof(NameStr) - 1;
begin;
  FSplit(AName, d, n, e);
  i := length(n);
  while n[i] in ['0'..'9'] do dec(i);
  num := system.copy(n,succ(i),255);
  base := system.copy(n,1,i);

  if length(num) = 0 then begin
    if length(base) = namemaxlen then begin
      {$IFDEF WIN32}
      SetLength(base, Length(base) - 1);
      {$ELSE}
      dec(base[0]);
      {$ENDIF}
    end;
    num:='1';
  end else begin
{    lastnumlen := length(num);}
    val(num,numval,code);
    inc(numval);
    str(numval, num);
    if length(num) + length(base) > namemaxlen then begin
      if length(base) > 0 then
        SetLength(base, length(base) - 1);{dec(base[0]);}
    end;
  end;
  IncFileName := d + base + num + e;
end;

  {$IFDEF WIN32}
  {$HINTS OFF}
  {$ENDIF}
function IsMonthFileName(APrefix, AName:PathStr):boolean;
var
  s:namestr;
  l:longint;
  code:integer;
  b:byte;
begin
  IsMonthFileName := false;
  AName := USUppCase(AName);
  b := pos(APrefix, AName);
  if b <> 1 then
    exit;
  b := length(APrefix);
  s := copy(AName, succ(b), 4);
  val(s, l, code);
  if code <> 0 then
    exit;
  IsMonthFileName := true;
end;
  {$IFDEF WIN32}
  {$HINTS ON}
  {$ENDIF}

function GetFileStatus(AFileName:PathStr; var AStatus:integer):boolean;
{true if file found, in AStatus is open state, error}
var f:file;
begin
  GetFileStatus := false;
  assign(f, AFileName);
  reset(f);
  AStatus := ioresult;
  case AStatus of
    0: begin
      GetFileStatus := true;
      close(f);
    end;
    5: begin
      GetFileStatus := true;
    end;
  end;
{ Value dosError(ioerror)
   2    File not found
   3    Path not found
   5    Access denied
   6    Invalid handle
   8    Not enough memory
  10    Invalid environment
  11    Invalid format
  18    No more files
}
end;

function DelBackSlash(Dir : DirStr) : DirStr;
begin
  if (Length(Dir) > 3) then begin
    if (Dir[Length(Dir)] = '\') then SetLength(Dir, length(Dir) - 1);{Dec(Dir[0]);}
  end else begin
    if (Dir[Length(Dir)] = '\') then begin
      if Length(Dir) > 1 then begin
        if (Length(Dir) < 3) or (Dir[2] <> ':') then SetLength(Dir, Length(Dir) - 1);{Dec(Dir[0]);}
      end;
    end;
  end;
  DelBackSlash := Dir;
end;

function AddBackSlash(Dir : DirStr): DirStr;
begin
  if (Dir <>  '') and (Dir[Length(Dir)] <> '\') then begin
    if (Length(Dir) <> 2) or (Dir[2] <> ':') then Dir := Dir + '\';
  end;
  AddBackSlash := Dir;
end;

{----- ReplaceExt(FileName, NExt, Force) -------------------------------}
{  Replace the extension of the given file with the given extension.    }
{  If the an extension already exists Force indicates if it should be   }
{  replaced anyway.                                                     }
{-----------------------------------------------------------------------}

function ReplaceExt(FileName: PathStr; NExt: ExtStr; Force: Boolean):
  PathStr;
var
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
begin
  FSplit(FileName, Dir, Name, Ext);
  if Force or (Ext = '') then
    ReplaceExt := Dir + Name + NExt else
    ReplaceExt := FileName;
end;

function ReplaceDir(FileName: PathStr; NewDir: DirStr; Force:boolean):PathStr;
var d:dirstr;n:namestr;e:extstr;
begin
  FSplit(FileName, d, n, e);
  if (d = '') or Force then
    ReplaceDir := AddBackSlash(NewDir) + n + e
  else
    ReplaceDir := FileName;
end;

const
  ExeName: PathStr = '';

function GetEXEName:pathstr;
{var s:string;}
{$IFDEF PMODE}
var
   n:array[0..255] of char;
{$ENDIF}
begin
  {$IFDEF PMODE}
  if ExeName = '' then begin
    if GetModuleFileName(HInstance, n, 255) <> 0 then begin
      ExeName := StrPas(n);
    end;
  end;
  {$ELSE}
  if ExeName = '' then begin
    if Lo(DosVersion) >= 3 then
    begin
      s := ParamStr(0);
      EXEName := FExpand(s);
      GetExeName := EXEName;
    end else
      EXEName := FExpand(FSearch('GHLink.EXE', '.;' + GetEnv('PATH')));
  end;
  {$ENDIF}
  GetExeName := EXEName;
end;

function GetEXEDir : DirStr;
var
  Dir : DirStr;
  Name : NameStr;
  Exe : ExtStr;
begin
  FSplit(GetEXEName, Dir, Name, Exe);
  GetEXEDir := Dir;
end;

function GetFileBaseName(AFileName:PathStr):NameStr;
var
  Dir : DirStr;
  Name : NameStr;
  Exe : ExtStr;
begin
  FSplit(AFileName, Dir, Name, Exe);
  GetFileBaseName := Name;
end;

function GetFileExt(AFileName:PathStr):ExtStr;
var
  Dir : DirStr;
  Name : NameStr;
  Exe : ExtStr;
begin
  FSplit(AFileName, Dir, Name, Exe);
  GetFileExt := Exe;
end;

function GetFileDir(AFileName:PathStr):DirStr;
var
  Dir : DirStr;
  Name : NameStr;
  Exe : ExtStr;
begin
  FSplit(AFileName, Dir, Name, Exe);
  GetFileDir := Dir;
end;

function GetFileDirAndName(AFileName:PathStr):PathStr;
var
  Dir : DirStr;
  Name : NameStr;
  Exe : ExtStr;
begin
  FSplit(AFileName, Dir, Name, Exe);
  GetFileDirAndName := Dir + Name;
end;

function GetFileBaseNameAndExt(AFileName:PathStr):PathStr;
var
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;
begin
  FSplit(AFileName, Dir, Name, Ext);
  GetFileBaseNameAndExt := Name + Ext;
end;

procedure MChDir(Dir : DirStr);
begin
  Dir := DelBackSlash(Dir);
  {$I-}
  chdir(dir);
  ioError := ioresult;
  {$I+}
end;

{
function FExists(FileName: PathStr): Boolean;
var
  F: file;
  Attr: Word;
begin
  ioError:=0;
  Assign(F, FileName);
  GetFAttr(F, Attr);
  FExists := (DosError = 0);
end;
}
function ConvStreamName(AFileName:PathStr):PathStr;
begin
  ConvStreamName := AFileName;
end;

{$IFNDEF WINDOWS}
function configfiles(count:word):boolean;
         {pokusi se nastavit FILES z CONFIG.SYS na hodnotu count, nepodari-li se
          vrati false, pro verzi dosu <3.3 zastavi program s hlaskou}
var reg:registers;b:byte;
begin
  IF (lo(dosversion)<3)or((lo(dosversion)=3)and(hi(dosversion)<3)) then begin
    writeln('Program can run only under MS-DOS version 3.3 or higher.');
    halt;
  end;
  asm
    mov b,0
    mov bx,count
    mov ah,67h
    int 21h
    jnc @1
    mov b,1
@1:
  end;
  if b=1 then configfiles:=false else configfiles:=true;
end;
{$ENDIF}

{$IFNDEF WIN32}
function CountFilesWithMask(AMask:string; FindAttr, MatchAttr:byte; Recursive:boolean):longint;
var
  i:longint;
  Procedure CountFile(Var Dir: DirStr; Var S : SearchRec); Far;
  begin
    inc(i);
  end;

begin
  i := 0;
  ForEachFile(AMask,  { Give the mask where you want to start looking }
    FindAttr, MatchAttr,{ Specify File attributes here; you'll just get
                  normal Files With 0 }
    Recursive,        { Search recursively }
    @CountFile); { Routine to call For each File }
  CountFilesWithMask  := i;
end;
{$ENDIF}

{$IFDEF WINDOWS}{sysutils}
function FExpand (Path: PathStr): PathStr;
begin
  FExpand := ExpandFileName(Path);
end;
{$ENDIF}

function GetModuleName(AInstance:TInstance):string;
{$IFDEF PMODE}
   var n:array[0..255] of char;
{$ENDIF}
begin
  GetModuleName := '';
  {$IFDEF PMODE}
  if GetModuleFileName(AInstance, n, 255) <> 0 then begin
    GetModuleName := StrPas(n);
  end;
  {$ELSE}
  GetModuleName := FExpand(Paramstr(0));
  {$ENDIF}
end;

function GetFileNamePart(fp:TFileNamePart; const AFileName:String):string;
var
  res:string;
  flag:word;
begin
  res := '';
  flag := fp and $FF00;
  fp := fp and $FF;
  case fp of
    fpBaseName : res := GetFileBaseName(AFileName);
    fpExt : res := GetFileExt(AFileName);
    fpDir : begin
      if (flag and fpDelBackSlash) <> 0 then
        res := DelBackSlash(GetFileDir(AFileName))
      else
        res := GetFileDir(AFileName);
    end;
    fpDirAndBaseName : res := GetFileDirAndName(AFileName);
    fpBaseNameAndExt : res := GetFileBaseNameAndExt(AFileName);
    fpUtlFile : res := FindUtlFile(AFileName);
    fpExpand : res := FExpand(AFileName);
    fpTempFileNameInDir : res := GetTempFileNameInDir(AFileName);
  else
    begin
      case flag of
        fpDelBackSlash: res := DelBackSlash(AFileName);
        fpAddBackSlash: res := AddBackSlash(AFileName);
      else
        SysError('fileu.GetFileNamePart invalid fp ' + inttostr(fp));
      end;
    end;
  end;
  GetFileNamePart := res;
end;

function ReplaceFileNamePart(fp:TFileNamePart; const AFileName:string;
  const ANewPartName:string; ForceEvenIfPresent:boolean):string;
var res:string;
begin
  res := AFileName;
  case fp of
    fpExt: begin
      res := ReplaceExt(AFileName, ANewPartName, ForceEvenIfPresent);
    end;
    fpDir: begin
      res := ReplaceDir(AFileName, ANewPartName, ForceEvenIfPresent);
    end;
  end;
  ReplaceFileNamePart := res;
end;

function GetFilePropInt(fp:TFileProperty; const AFileName:string):longint;
var
  i:longint;
{$IFNDEF WINDOWS}
  function getfileattr:longint;
  var f:file;a:word;
  {var regs:registers;}
  begin
    assign(f, AFileName);
    GetFAttr(f, a);
    if DosError <> 0 then begin
      ioerror := DosError;
      GetFileAttr := -1
    end else begin
      GetFileAttr := a;
    end;
    {
    fillchar(regs,sizeof(regs),0);
    afilename := afilename+#0;
    with regs do begin
      ah:=$43;
      ds:=seg(name);
      dx:=ofs(name)+1;
      msdos(regs);
      ioerror:=al;
      if (al in [2,3,5]) then
        getfileattr := -1
      else begin
        getfileattr := cl;
      ro:=(cl and $01)>0;
      hidden:=(cl and $02)>0;
      sys:=(cl and $04)>0;
      vol:=(cl and $08)>0;
      subdir:=(cl and $10)>0;
      arch:=(cl and $20)>0;
     }
  end;
{$ENDIF}
begin
  i := -1;
  case fp of
    fpFileSize: i := GetFileSize(AFileName);
    fpFileTime: i := GetFileTime(AFileName);
    {$IFNDEF WINDOWS}fpFileAttr: i := GetFileAttr;{$ENDIF}
    fpFileExists: i := Longint(FExists(AFileName));
  else
    SysError('Fileu.GetFilePropInt invalid fp ' + IntToStr(fp));
  end;
  GetFilePropInt := i;
end;


{$IFDEF DEBCRASH}
begin
  {writeln('fileu.begin ' + GetExeName);}
{$ENDIF}
  {DirStack.Init(10, 5);}
end.