unit logtype;{types for LOG module: date/time and logging msgs to file(s)}
{$I define.pas}
interface
uses {$IFNDEF WINDOWS}dos,{$ENDIF} mytype, dpmitype;{dateu}
type
  PDTO = pointer;{pointer to DateTimeObject}

  PLogger = pointer;
  { log file ID }
  TLogResult = integer;
  { result of Logxxx call }
  TLogType = word;
  { type of logging - what to include to log line,
    log file name, etc
  }
  TLogEvent = longint;
  { what event is being logged, used in LogEvent call }

  {TEventCode = longint;}

  DTResult = integer;
  { result of DTxxx call }

  TLogProperty = integer;
  { property identifiers }

const
  LogSectionName = '[LOG]';
  { in what section of ini file to look for parameters }
  NoDateTime = nil;
  NoDate = nil;

{ltXXXX Log Types (can be ored) -
 what include to log line, what to do upon LogEvent}

  ltDefault = 0;{cause log type used from global LogsParams}

  ltText = 1; {logs just the message, no time info}
  ltMilisecond = 2;{logs milisecond info at the begging of the log line: [.]MMM}
  ltTime = 4;{logs time info at the beggining of the log line: [,]HHMMSS}
  ltDate = 8;{logs date info at the beggining of the log line: CCYYMMDD}
  ltEventType = $10;{logs info about message event type (if submitted together
    with the message)}
  ltDaily = $20; {creates new file every midnight, file name contains MMDD}
  ltMonthly = $40;{creates new file every new month, file name contains YYMM}
  ltFlushAlways = $80; {msg written to file immediately upon log (can be changed by setproperty)}
  ltOverWrite = $100; {if log file of given name found, it's overwritten
    upon LogInit call}
  ltAppend = $200; { does not have to be specified, logs append by default,
    only if global parameter OverwriteLogFiles = true, then
    using this type overrides this global setting just for the file beeing
    opened }
  ltPostEvent = $400; {postevent called upon every LogEvent}
  ltUseMailBox = $800; {call to LogLog does not put the message directly
                        to log file but to MailBox from which it
                        is retrieved in TaskLog task, that has priority
                        specified in LogTaskPriority INI variable}

  {combined log types:}
  ltSysLog = ltTime + ltMilisecond + ltEventType + ltPostEvent + ltUseMailBox;
{/ltXXXX}

{leXXXX Log Event type constants (masks) (lines start with
 short name of the event used in log files}
{W }  leWarning = 1; { warning of the system, to programmer that something
                   can be wrong }
{ER}  leError = 2;   { real error encountered by system, but program can continue}
{FA}  leFatalError = 4; { fatal error encountered, program most probably wont work
                      well and usually will be aborted anyway}

  {messages SHOWN to user, i.e. results of user actions}
{UW}  leUserWarning = 8;  { response to some user action, info that
    something might be different than user expects }
{UE}  leUserError = $10;   { response to user incorrect action; similar to leUserInfo }
{UC}  leUserConfirm = $20; { user was asked to confirm (verify) something }
{UI}  leUserInfo = $40;    { info that some action finished, or something
                        similar, no errors, warnings or questions }
  {/messages SHOWN}

{UA}  leUserAction = $80;     { Logs user action (starting and finishing
                            commands, confirming Verify questions) }
{PA}  leProgramAction = $100; { Logs start and end of actions invoked
                            automacitacally by program (time dependent)}
{DE}  leDebug          = $200;{ just for debuggine purposes to know
                                 on what program line we are }


  { more detailed info about specific actions (start/stop):}
{MT}  leMemoryTransfer =  $10000; { memory - modules transfers }
{DB}  leDB             =  $20000; { database actions }
{CO}  leCOM            =  $40000; { com ports actions }
{PR}  lePrint          =  $80000; { printer actions }
{FI}  leFile           = $100000; { file access actions }
{PK}  lePacket         = $200000; { packetu layer events }

  {combined log event masks (for enabling):}
  lemSystem = leWarning + leError + leFatalError;
  lemAction = leMemoryTransfer + leDB + leCOM + lePrint + leFile;
  lemUser = leUserWarning + leUserError + leUserConfirm + leUserInfo + leUserAction;
  lemAll = $7FFFFFFF;


 { syslog events used most often }
  slInfo = leUserInfo;
  slWarning = leUserWarning;
  slError = leError;
  slFatal = leFatalError;
  slAction = leUserAction;
  slDebug = leDebug;
  slConfirm = leUserConfirm;


{lpXXXX Log Properties }
  {for Logger}
  lpFlushAlways = 1; {set/get}
  lpLogEventMask = 2;{set/get, what events to log}
  lpFileName = 3;    {get; filename can change since Init
                      if time dependent}
  lpLogType = 4;
  lpLogWindowProc = 5;{set/get, procedure to be called upon every LogEvent}
  lpFlush = 6;        { LogSetProp(LG, lpFlush, nil) is equivalent to LogFlush}

  {globals for Log module:}
  lpOverwriteLogFiles = 10;
{/lpXXXX}

{lrXXXX Log Results:}
  lrOK = 0;
  lrNotInstalled = 1;
  lrInvalidLogger = 2;
  lrInvalidProcessID = 3;
  lrInvalidSetProp = 4;
  lrInvalidGetProp = 5;

{umXXXX log UseMailboxes param values:}
  umDefault = 0; { Pouvat Mail Boxy pro Logy jen tam, kde to bylo
                   explicitn vydno pi Init }
  umAll = 1;     { Pouvat Mail Boxy vude vdy }
  umNone = 2;    { Nepouvat Mail Boxy nikde }
{/lrXXXX}
  MaxDaysInMonth = 31;
  DaysInWeek = 7;

  dowMo = 0;
  dowSu = 1;

{dtProperties:}
  {constants for determining what incUnit to use in the IncDate proc.}
  dtIncDay = 0;
  dtIncWeek = 1;
  dtIncMonth = 2;
  dtIncYear = 3;

  dtIncSecond = 5;
    incSecond = 5;
  dtIncMinute = 6;
    incMinute = 6;
  dtIncHour = 7;
    incHour = 7;

  dtYYYYMMDD = 11;
   dtDateString = 11;

  dtHHMMSS = 12;
    dtTimeString = 12;
  dtDateTimeString = 13;{YYYYMMDDHHMMSS}
    dtDateTime = 13;
  dtDay = 14;
  dtMonth = 15;
  dtYear = 16;
  dtPackedDate = 17;
  {only Get:}
  dtIsValid = 18;
    dtIsValidDate = 18;
  { DTGet returns dtOK if Date is valid (i.e. repesents some
    real word d/m/y calendar value) }
  dtYYYYMM = 19;
  dtDatum = 20;
  dtDOW = 21;
  dtAbsDayOfWeek = 22;
  dtIsValidTime = 23;
  dtMonthYearDatum = 24;
  dtDayString = 25;
    dtDD = 25;
  dtTodayInSeconds = 26;
  dtShortDatum = 27;
  dtCas = 28;
  dtDayMonth = 29;
  dtHHMM = 30;
  dtYYMMDD = 31;
    dtShortDate = dtYYMMDD;
  dtShortDateTime = 32; {YYMMDDHHMM for GetStr, YYMMDD[HH[MM[SS]]] for SetStr}

  dtDDOW = 33;{returns day of week number in two weeks range:
   0..6 odd week's Mo-Su, 7-13 even week's Mo-Su}
  dtDayInYear = 34;{day's order number in year}
  dtWeekInYear = 35;{week's order number in year}
  dtHour = 36;
  dtMinute = 37;
  dtSecond = 38;

{dtActions}
  dtGetSystemTime = 100;
   dtGetNow = 100;
  dtCopyFrom = 101;
  dtGetRTClockTime = 102;
  dtClear = 103; {set all fields to 0}

  dtGetFileTime = 104;
    { DTDo .. Get time of the file (AInfo = @FileName) }
  dtSetFileTime = 105;
    { DTDo .. Set time to the file (AInfo = @FileName) }
  dtSetSystemTime = 106;
    { Set bios clock to current values of TDTO }
  {v2.09}
  dtGoToYearStart = 107;
    { sets date to 1.1. of current year }
  dtGoToYearEnd = 108;
    { sets date to 31.12. of current year }
  dtGoToMonthStart = 109;
    { sets date to 1. day of current month; AInfo <> 0, then
      specifies different last day in month then is usual, e.g.:
      for AInfo = 25 and current date = xx.3.1999 will be
      result: 26.2.1999. }
  dtGoToMonthEnd = 110;
    { sets date to last day of current month; AInfo <> 0, then
      specifies different last day in month then is usual, e.g.:
      for AInfo = 25 and current date = xx.3.1999 will be
      result: 25.3.1999. }
  dtGoToWeekStart = 111;
    { sets date to first day of current week }
  dtGoToWeekEnd = 112;
    { sets date to last day of current week }

{dtxxxx DateTimeError values}
  dtOK = 0;
  dtError = -1;
  dtInvalidDTO {dtUnregDate} = -2;
  dtUnknownAction = -3;
  dtInvalidDoInfo = - 4;
  dtUnknownGetProperty = -5;
  dtUnknownGetStrProperty = -6;
  dtUnknownSetProperty = -7;
  dtInvalidDate = -8;
  dtInvalidTime = -9;

  {dtInvalidDTO = -10;{non initialized pointer}

const
  DayInSeconds = 24 * 60 * 60;
  HourInSeconds = 60 * 60;
  MinuteInSeconds = 60;
  DateStringLen = 10;
  TimeStringLen = 8;
  ShortTimeStringLen = 5;

const
  EmptyDateStr     = '00000000';
  MinValidFromDate = '19960101';
  { Datum zadvan jako pedvolen minimln u zznam databz
    typu vnRange }
  MaxValidToDate   = '21001231';
  { Datum zadvan jako pedvolen maximln u zznam databz
    typu vnRange }
  fnValidTo = 'VALIDTO';
  { Povinn nzev pole, kter udv od kdy je zznam platn
    a databz typu vnRange }
  fnValidFrom = 'VALIDFROM';
  { Povinn nzev pole, kter udv do kdy je zznam platn
    a databz typu vnRange }

type
  TDayString = string[2];
  TMonthString = string[2];
  TYearString = string[4];
  TDateString = string[DateStringLen];{10}
  TTimeString = string[TimeStringLen];{8}
  TDateTimeString = string[DateStringLen + TimeStringLen];
  TShortTimeString = string[ShortTimeStringLen];
  TDayOfWeekString = String[9];
  TDateTimeRec = record
     Year,Month,Day,Hour,Min,Sec, {z puvodniho DateTime}
     DayOfWeek, Sec100: Word; {navic}
  end;
  TPackedDateTime = longint;

  TSysDate = record
    year,month,day,dayofweek:word;
  end;

const

  {constants for determining what incUnit to use in the IncDate proc.}
  incDay = 0;
  incWeek = 1;
  incMonth = 2;
  incYear = 3;

const
  LogSec = '[Log]';


type
  TLogWindowProc = procedure(const s:string);
  PLogParams = ^TLogParams;
  TLogParams = record
    { Common type for Logs and Logger,
      every new logger takes default values of given ProcessID }
    {Overwrite:boolean; overwrite old log file upon open? }
    LogType:TLogType;
    LogMask:TLogEvent;

    LogDir:DirStr;
    LogName:NameStr;
    LogExt:ExtStr;

    {LogEvent:TLogEvent;{ last logged event }
    {Msg:string; { last message logged }
    {DT:longint; { date/time of last logged message }
    {EventCode:TEventCode; { event code of last logged message }
    ProcessID:TProcessID; { to what process id this Logs or Log params belong }
    LastResult:TLogResult;
  end;

type
  TTimeUnit = byte;
{tuXXXX Time Unit, corresponds to dtIncxxxx}
const
  tuDay = 0;
  tuWeek = 1;
  tuMonth = 2;
  tuYear = 3;
  tuSecond = 5;
  tuMinute = 6;
  tuHour = 7;
{/tuXXXX}

implementation
end.