unit Winini;{international support win.ini changes}

interface
uses inifiles, messages, winprocs, wintypes;
procedure Init;

implementation
uses globals, fileu;
const
  IntlSec = 'intl';

procedure Init;
var
  ifile:TIniFile;
  path, cfg:string;
begin
  ifile := TIniFile.Create('win.ini');
  try
    ifile.WriteInteger(IntlSec, 'iDate', 1);
    ifile.WriteInteger(IntlSec, 'iTime', 1);
    ifile.WriteString(IntlSec, 'sDate', '.');
    ifile.WriteString(IntlSec, 'sTime', ':');

    path := ifile.ReadString('IDAPI', 'DLLPath', '');
    cfg := ifile.ReadString('IDAPI', 'CONFIGFILE01', '');
    if (path = '') and (cfg = '') then
      path := IdapiDir
    else begin
      if path <> '' then begin
        IdapiDir := path
      end else begin
        IdapiDir := GetFileDir(cfg);
      end;
    end;

    if ifile.ReadString('Borland Language Drivers', 'LDPath', '') ='' then
      ifile.WriteString('Borland Language Drivers', 'LDPath', IdapiDir + '\LANGDRV');
    ifile.WriteString('IDAPI','DLLPath',IdapiDir);
    ifile.WriteString('IDAPI','CONFIGFILE01',IdapiDir + '\IDAPI.CFG');
    PostMessage(HWND_BROADCAST, WM_WININICHANGE, 0, 0);
  finally
    ifile.Free;
  end;
end;

end.
