unit MikroToAAAu;{ import of AAA (amino acid analyzer) program from Mikro (DOS program)}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  SysUtils, Classes, Fileu,
  UlanType, ULRecUtl, ULObju, ULObjUsru,
  {v0.50}
  MikroType,
  ULAType, ULAObju,
  ULADType, ULADObju,
  ULIType, ULIObju,
  UtlType, WinUtl, Graphics,
  {/v0.50}

  AAPLType, AAPLObju,
  AAPGType, AAPGObju, AAPrgu;

procedure MicroToAAAPrg(const ASrcFileName: string; const ADestDir: string);

procedure MicroToAAA(const AMicroDir: string; const AAAADir: string);
  { converts all prg files in amicrodir to aap files to AAAADir }

{v0.50}
procedure MikroToULA(const AHeadFileName: string; ULA: TULAObj);
function MikroDateToDate(const AMikroDate: TMikroDate): TDateTime;
{/v0.50}

implementation
{v0.50}
uses ExpImpu;
{/v0.50}

procedure MicroToAAAPrg(const ASrcFileName: string; const ADestDir: string);
var
  ss: TFileStream;
  sr: TMikroProgArrType;
  pg: TAAPrg;
  pr: TAAPrgLine;
  dn: string;
  ac: TAACommand;

begin
  pg := TAAPrg.Load('');
  try
    if ADestDir <> '' then begin
      dn := AddBackSlash(ADestDir) + ExtractFileName(ChangeFileExt(ASrcFileName,
        ULRecDefFileExt(AAPGID)));
    end else begin
      dn := ChangeFileExt(ASrcFileName, ULRecDefFileExt(AAPGID));
    end;

    ss := TFileStream.Create(ASrcFileName, fmOpenRead);
    try
      while ss.Read(sr, sizeof(sr)) = sizeof(sr) do begin
        pr := TAAPrgLine(pg.ChildAdd(nil, AAPLID, ''));
        pr.AAPL.PrgTime := sr.Time * 60;
        pr.AAPL.Temperature := sr.Colu;
        pr.AAPL.BufferNr := TAABufferNr(sr.Buff);
        case sr.Opti of
          0: ac := acNone;
          1: ac := acLoad;{ - next, }
          2: ac := acInject;{ - inject    }
          3: ac := acAcqStop;{ - dataoff, }
          4: ac := acStartEquil;{ - start }
          10: ac := acZero; { 10 - zerro, }
          11: ac := acH2O;   {11 - A, 12 - B }
          12: ac := acNHD;
        {v0.50}
        else
          ac := acNone;
        {/v0.50}
        end;
        pr.AAPL.Command := ac;
        pr.AAPL.Note := sr.Pars;
      end;
    finally
      ss.free;
    end;
    pg.SaveToFile(dn);
  finally
    pg.Free;
  end;
end;

procedure MicroToAAA(const AMicroDir: string; const AAAADir: string);
  { converts all prg files in amicrodir to aap files to AAAADir }
var
  f: TSearchRec;
  sd, dd: string;
begin
  sd := AddBackSlash(AMicroDir);
  dd := AddBackSlash(AAAADir);{filename}
  if findfirst(sd + '*.PRG', faAnyFile, f) = 0 then
  begin
    try
      repeat
        MicroToAAAPrg(sd + f.Name, AAAADir);
      until findnext(f) <> 0;
    finally
      findclose(f);
    end;
  end;
end;

{v0.50}
procedure MikroToULA(const AHeadFileName: string; ULA: TULAObj);
var
  f: file of TMikroSampleHead;
  msh: TMikroSampleHead;

  uli: TULIObj;
  aap: TAAPGObj;
  ulad: TULADObj;

  dt: TDateTime;
  fn: string;
begin
  AssignFile(f, AHeadFileName);
  Reset(f);
  try
    Read(f, msh);
    ULA.SampleName := msh.SName;
    ULA.SampleDesc := msh.SNote;
    ULA.UserName := msh.SGetT;

    dt := MikroDateToDate(msh.SGetD);
    ULA.DateTime := DateTimeToFileDate(dt);

    uli := TULIObj(ULA.FindOrAdd(ULIID, ''));
    aap := TAAPGObj(uli.FindOrAdd(AAPGID, ''));
    aap.PrgName := msh.SProg;


    ulad := TULADObj(ULA.FindOrAdd(ULADID, ''));
    ulad.Data.Size := 0;
    ulad.DataName := 'G';
    ulad.Color := clGreen;
    fn := ChangeFileExt(AHeadFileName, GExt);
    if not TryConvertFromFile(fn, ULA, ulad.Data) then
      raise Exception.Create('MikroToULA Could not convert G line file ' + fn);


    ulad := TULADObj(ULA.FindOrAdd(ULADID, 'B'));
    ulad.Data.Size := 0;
    ulad.DataName := 'B';
    ulad.Color := clBlue;
    fn := ChangeFileExt(AHeadFileName, BExt);
    if not TryConvertFromFile(fn, ULA, ulad.Data) then
      raise Exception.Create('MikroToULA Could not convert B line file ' + fn);

  finally
    CloseFile(f);
  end;
end;

function MikroDateToDate(const AMikroDate: TMikroDate): TDateTime;
var
  i: TDateTimePart;
  dta: TDateTimeArray;
  n, md: string;
begin
  Result := 0;
  md := AMikroDate;
  fillchar(dta, sizeof(dta), 0);
  i := dtHour;{winutl utltype}
  while (i < dtYear) and ExtractWord(['.','-','/'], n, md) do begin
    inc(i);
    dta[i] := StrToInt(n);
    if (i = dtYear) then begin
      if dta[i] < 100 then begin
        if dta[i] < 70 then
          dta[i] := 2000 + dta[i]
        else
          dta[i] := 1900 + dta[i];
      end;
    end;
  end;
  try
    Result := EncodeDate(dta[dtYear], dta[dtMonth], dta[dtDay]);
  except
  end;
end;
{/v0.50}

end.
