unit OptionsFrm;{v0.50}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinUtl, UlanGlob, StdCtrls, ComCtrls;

type
  TOptionsForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    OKButton: TButton;
    CancelButton: TButton;
    TemplatesEdit: TEdit;
    Label1: TLabel;
    DataEdit: TEdit;
    Label2: TLabel;
    TemplatesFullEdit: TEdit;
    DataFullEdit: TEdit;
    MethodsEdit: TEdit;
    Label3: TLabel;
    MethodsFullEdit: TEdit;
    EnvMemo: TMemo;
    Label4: TLabel;
    PrgEdit: TEdit;
    PrgFullEdit: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    SeqEdit: TEdit;
    SeqFullEdit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure TemplatesEditChange(Sender: TObject);
    procedure DataEditChange(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure MethodsEditChange(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure VarToForm;
    procedure FormToVar;
    procedure UpdateEdits;
  end;

var
  OptionsForm: TOptionsForm;

implementation

{$R *.DFM}

procedure TOptionsForm.FormActivate(Sender: TObject);
begin
  VarToForm;
  EnvMemo.Lines := EnvVars;
end;

procedure TOptionsForm.VarToForm;
begin
  TemplatesEdit.Text := IniTemplateDir;
  DataEdit.Text := IniDataDir;
  MethodsEdit.Text := IniMethodDir;
  PrgEdit.Text := IniPrgDir;
  SeqEdit.Text := IniSequenceDir;
end;

procedure TOptionsForm.FormToVar;

  function Fix(const src: string): string;
  var s1: string;
  begin
    s1 := ReplaceEnvVars(src);
    if s1 <> AddBackSlash(s1) then
      Result := src + '\'
    else
      Result := src;
  end;

begin
  IniTemplateDir := Fix(TemplatesEdit.Text);
  IniDataDir := Fix(DataEdit.Text);
  IniMethodDir := Fix(MethodsEdit.Text);
  IniPrgDir := Fix(PrgEdit.Text);
  IniSequenceDir := Fix(SeqEdit.Text);
  UpdateIniDirs;
end;

procedure TOptionsForm.TemplatesEditChange(Sender: TObject);
begin
  UpdateEdits;
end;

procedure TOptionsForm.DataEditChange(Sender: TObject);
begin
  UpdateEdits;
end;

procedure TOptionsForm.OKButtonClick(Sender: TObject);
begin
  FormToVar;
end;

procedure TOptionsForm.MethodsEditChange(Sender: TObject);
begin
  UpdateEdits;
end;

procedure TOptionsForm.UpdateEdits;
var s: string;
begin
  s := ReplaceEnvVars(DataEdit.Text);
  if s <> DataFullEdit.Text then begin
    DataFullEdit.Text := s;
    SetEnv('DataDir', DataFullEdit.Text);
    EnvMemo.Lines := EnvVars;
  end;
  TemplatesFullEdit.Text := ReplaceEnvVars(TemplatesEdit.Text);
  MethodsFullEdit.Text := ReplaceEnvVars(MethodsEdit.Text);
  PrgFullEdit.Text := ReplaceEnvVars(PrgEdit.Text);
  SeqFullEdit.Text := ReplaceEnvVars(SeqEdit.Text);

end;

procedure TOptionsForm.FormDeactivate(Sender: TObject);
begin
  if ModalResult = mrCancel then
    SetEnv('DataDir', IniDataDir);
end;

end.
