unit PickMethodPeakFrm;{v0.54}
{ Form for picking of peak from method peaks, to be assigned to currently
  active analysis peak }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PickFrm, StdCtrls,
  UlanType, ULObju, Spectrum, ULPRType, ULPRObju, ExtCtrls;

type
  TPickPeakForm = class(TPickForm)
    Panel1: TPanel;
    UpdateMethodCheckBox: TCheckBox;
    OKButton: TButton;
    procedure OKButtonClick(Sender: TObject);
  private
    { Private declarations }
    FData: TAcqData;
    FDataPeak: TULPRObj;
    FShouldUpdateMethod: boolean;
    procedure SetData(AData: TAcqData);
    function GetMethodPeak: TULPRObj;
    procedure SetDataPeak(APeak: TULPRObj);
    function GetShouldUpdateMethod: boolean;
    procedure SetShouldUpdateMethod(OnOff:boolean);
  public
    { Public declarations }
    property Data: TAcqData read FData write SetData;
    property DataPeak: TULPRObj read FDataPeak write SetDataPeak;

    property MethodPeak: TULPRObj read GetMethodPeak;
    property ShouldUpdateMethod: boolean read GetShouldUpdateMethod write SetShouldUpdateMethod;
  end;

const
  PickPeakForm: TPickPeakForm = nil;

function PickMethodPeak(AData: TAcqData; ADataPeak: TULPRObj;
  var AMethodPeak: TULPRObj; var AUpdateMethod: boolean): boolean;

implementation

procedure TPickPeakForm.SetData(AData: TAcqData);
var
  o: TULObj;
  i, minInd: integer;
  minDist, dist: single;
  s: string;
begin
  List.Clear;
  minInd := -1;
  dist := MaxSingle;{ulantype Utltype}
  minDist := dist;
  for i := 0 to AData.ULM_ULP.ChildCount - 1 do begin
    o := AData.ULM_ULP.Childs[i];
    if o is TULPRObj then with o as TULPRObj do begin
      s := PeakName + ' ' + o.FindField('X').AsUsrString; {ulobju}{ulprtype}
      List.AddObject(s, o);
      if FDataPeak <> nil then begin
         dist := abs(FDataPeak.X - X);
         if dist < mindist then begin
           minInd := i;
           minDist := dist;
         end;
      end;
    end;
  end; {spectrum}
  if minInd >= 0 then
    ItemIndex := minInd;
end;

function TPickPeakForm.GetShouldUpdateMethod:boolean;
begin
  Result := UpdateMethodCheckBox.Checked;
end;

procedure TPickPeakForm.SetDataPeak(APeak: TULPRObj);
begin
  FDataPeak := APeak;
end;

procedure TPickPeakForm.SetShouldUpdateMethod(OnOff:boolean);
begin
  UpdateMethodCheckBox.Checked := OnOff;
end;

function TPickPeakForm.GetMethodPeak: TULPRObj;
begin
  Result := nil;
  if ItemIndex >= 0 then begin
    Result := TULPRObj(List.Objects[ItemIndex]);
  end;
end;

{$R *.DFM}

procedure TPickPeakForm.OKButtonClick(Sender: TObject);
begin
  inherited;
  ItemIndex := ListBox.ItemIndex;
end;

function PickMethodPeak(AData: TAcqData; ADataPeak: TULPRObj;
  var AMethodPeak: TULPRObj; var AUpdateMethod: boolean): boolean;
begin
  Result := false;
  if PickPeakForm = nil then
    PickPeakForm := TPickPeakForm.Create(Application);
  PickPeakForm.DataPeak := ADataPeak;
  PickPeakForm.Data := AData;
  PickPeakForm.ShouldUpdateMethod := AUpdateMethod;
  if PickPeakForm.ShowModal = mrOK then begin
    AMethodPeak := PickPeakForm.MethodPeak;
    AUpdateMethod := PickPeakForm.ShouldUpdateMethod;
    Result := true;
  end;
end;

end.
