unit ULDrvFilteru;{ uLan driver message filter object }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  Classes, ULDrvTyp, ULDrvUtl;

type
  TULDrvFilterEvent = procedure(AULDrv: TObject; const AMsg: TULMessage; var FilterOut: boolean) of object;

  TULDrvFilter = class(TComponent)
  private
    FFilterEvent: TULDrvFilterEvent;
    FRegisteredAt: TObject;
    FSuspended: boolean;
  public
    Msg: TULMessage;
    constructor Create(Owner: TComponent); reintroduce;
    destructor Destroy; override;
    procedure DoEvent(AULDrv: TObject; const AMsg: TULMessage; var FilterOut: boolean);

    {property Msg: TULMessage read FMsg write FMsg;}
    property FilterEvent: TULDrvFilterEvent read FFilterEvent write FFilterEvent;
    property RegisteredAt: TObject read FRegisteredAt write FRegisteredAt;
    property Suspended: boolean read FSuspended write FSuspended;
  end;

  TULDrvFilterList = class(TList)  { belongs to ULDriver, created to maintain list of filters}
    procedure Suspend;{ called when uldrv.active set to false }
    procedure Resume; { called when uldrv.active set to true }
    {procedure Unregister; { called before destroy to notify all filters, that the uldriver does no exist}
    destructor Destroy; override;
  end;

implementation
uses
  ULDriver;

{TULDrvFilter.}
constructor TULDrvFilter.Create(Owner: TComponent);
begin
  inherited;
end;

destructor TULDrvFilter.Destroy;
begin
  if RegisteredAt is TULDriver then
    TULDriver(RegisteredAt).EventFilterUnregister(Self);
  inherited;
end;

procedure TULDrvFilter.DoEvent(AULDrv: TObject; const AMsg: TULMessage; var FilterOut: boolean);
begin
  if Assigned(FilterEvent) then begin
    FilterEvent(AULDrv, AMsg, FilterOut);
  end;
end;
{/TULDrvFilter.}

{TULDrvFilterList.}

procedure TULDrvFilterList.Suspend;
var
  i: integer;
begin
  for i := 0 to Count - 1 do
    TULDrvFilter(Items[i]).Suspended := true;
end;

procedure TULDrvFilterList.Resume;
var
  i: integer;
begin
  for i := 0 to Count - 1 do begin
    with TULDrvFilter(Items[i]) do begin
      Suspended := false;
      if RegisteredAt is TULDriver then
        TULDriver(RegisteredAt).FilterAdd(Msg.sadr, Msg.cmd);
    end
  end;
end;

destructor TULDrvFilterList.Destroy;
var
  i: integer;
begin
  for i := 0 to Count - 1 do
    TULDrvFilter(Items[i]).RegisteredAt := nil;
  inherited;
end;
{/TULDrvFilterList.}
end.
