unit ULDrvTyp;  {UL_DEV_NAME = '\\.\UL_DRV';}
interface
uses windows;

{ ul_mess_head flags definition defines proccessing
   of message or its frames stored in bll }

type
  HANDLE = THandle;

const
  UL_BFL_LOCK  = $8000;
    { locked message is pointed only once }
  UL_BFL_MSST  = $4000;
    { Message must be received by some proccess }
  UL_BFL_M2IN  = $2000;
    { After succesfull proccessing move to proc_bll }
  UL_BFL_LNMM  = $1000;
    { Length of received frame must match expected len }
  UL_BFL_FAIL  = $0800;
    { Message cannot be proccessed - error }
  UL_BFL_TAIL = $0400;
   { Multiframe message continues by next bll block }
  UL_BFL_SND = $0200;
    { Send this frame }
  UL_BFL_REC   = $0100;
    { Receive answer frame into this bll block }
  UL_BFL_VERL  = $0040;
    { Verify free space in buffer of destination station }
  UL_BFL_NORE  = $0020;
    { Do not try to repeat if error occurs }
  UL_BFL_REWA  = $0010;
    { If error occurs do wait with retry }
  UL_BFL_PRQ   = $0002;
    { Request imediate proccessing of frame by receiver station }
  UL_BFL_ARQ   = $0001;
    { Request imediate acknowledge by receiving station }

{ ioctl definitions }

{ 32768-65535 are reserved for use by customers. }
const
  FILE_DEVICE_ULAN  = $A000;
  { function codes 2048-4095 are reserved for customers. }
  UL_IOCTL_INDEX = $A00;

type
  {deXXXX}
  TULDriverEventID =
    (deMessageOpen,
     deMessageOpenFail,
     deMessageTailOpen,
     deMessageReadBuf,
     deMessageCreate,
     deMessageWriteBuf,
     deMessageClose,
     deMessageAbort,
     deFilterAdd,
     deDrvOpen,
     deDrvClose,
     deMessageTailCreate);
  {/deXXXX}


  TULMessage = record
    case integer of
    0:(
    dadr: longint;  //* destignation address */
    sadr: longint;  //* source address */
    cmd: longint;   //* command/socket number */
    flg: longint;   //* message flags */
    len: longint;  //* length of frame */
    stamp: longint;		//* unigue message number */
    );
    1:(data: array[0..23] of byte);
  end;
  PULMessage = ^TULMessage;

const
  UL_CMD_RES	= $80;	//* Reinitialize RS485 */
  UL_CMD_SFT	= $81;	//* Test free space in input buffer */
  UL_CMD_SID	= $F0;	//* Send identification */
  UL_CMD_SFI	= $F1;	//* Send amount of free space in IB */
  UL_CMD_TF0	= $98;	//* End of stepping */
  UL_CMD_TF1	= $99;	//* Begin of stepping */
  UL_CMD_STP	= $9A;	//* Do step */
  UL_CMD_DEB	= $9B;	//* Additional debug commands */
  UL_CMD_SPC	= $DA;	//* Send state - for 8051 PCL PCH PSW ACC */

  UL_CMD_RDM	= $F8;	//* Read memory   T T B B L L */
  UL_CMD_WRM	= $B8;	//* Write memory  T T B B L L */

const
{  UL_DEV_NAME = '\\\\.\\UL_DRV';}
  {v0.53 moved to DevMode unit, now it is function. It's result
         depends on OS Version}
  {/v0.53
  UL_DEV_NAME = 'UL_DRV';}
  {'\\.\UL_DRV'}
  UL_CMD_OISV = $10;	//* Object Interface Service */
  UL_CMD_LCDABS	= $4f;	//* Absorbance data block */
  UL_CMD_LCDMRK	= $4e;	//* Mark */

  {v0.50}
  UL_CMD_NCS    = $7F;  //* Network control services */
  UL_CMD_GST    = $C1;  //* Fast module get status */
  {/v0.50}


//*******************************************************************/
//* definitions of basic uLan OI commands */
const
  ULOI_AOID   =10;	//* name is defined in ASCII for DOIx */
  ULOI_DOII   =12;	//* description of input objects */
  ULOI_DOIO   =14;	//* description of output objects */
  ULOI_QOII   =16;	//* ID numbers of recognized input objects */
  ULOI_QOIO   =18 ;	//* ID numbers of recognized output objects */
  ULOI_RDRQ   =20 ;	//* object values read request */
  ULOI_STATUS =30 ;	//* read instrument status */
  ULOI_ERRCLR =31 ;	//* clear error status */

//*******************************************************************/
//* UL_CMD_NCS	Network Control Service

{v0.50}
const
  ULNCS_RQ_ADDR  = $C0; //* SN0 SN1 SN2 SN3 */
  ULNCS_SET_ADDR = $C1;	//* SN0 SN1 SN2 SN3 NEW_ADR */
  ULNCS_SID_RQ =   $C2;	//* send serial num and ID string request */
  ULNCS_SID_RPLY = $C3;	//* SN0 SN1 SN2 SN3 ID ... */
{/v0.50}

{type

  uloi_coninfo = record
    adr:longint;	//* address of target module */
    cmd:longint;	//* service/cmd number for uLOI on target */
    bcmd:longint;	//* service/cmd number for returned messages */
    sn:longint;	        //* sequence counter */
    bsn:longint;	//* sequence counter of target module */
    outflg:longint;	//* flags used for outgoing messages */
    ul_fd:HANDLE;	//* handle for ul_drv */
    timeout:longint;	//* timeout */
  end;
  Puloi_coninfo = ^uloi_coninfo;
}
  
{
 standard command codes
   00H .. 3FH    store to buffer
   40H .. 7FH    store to buffer without ACK
   80H .. 9FH    proccess at onece
   A0H .. BFH    process with additional receive
   C0H .. FFH    process with additional send
}
implementation
end.


