unit AAFrm;{v0.23}{ Amino Acid Analyzer application window }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
{$DEFINE ULANLIB}{units included just because of recompiling units for ULanLib.BPL }
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls{v0.23},
  ValuePanel, OneEditPanel, LineConnector,

  ULRecTyp, ULObju, ULFObju, ULObjCtrl, ULObjUsru, { ulanrecs.lst ulbrowu
    ulbrowsefrm ulstringgrid}
  AAAType, AAAu, AAPrgu, Sequenceu,{history.txt ulsrtype uldpobju type}

  ExeLogu, LogFrm, TVType, MyType, Msgu, ShowMsg
  {$IFDEF ULANLIB}
  , IniObj, UlanLibu, CommInt, FileMenuHdl,
  BomeOneInstance,PBBinHexEdit,PBSpinEdit,
  AlRep, ExtComDl, StrGrdEx, Menus {$ENDIF}{v0.26}, UlanType, Spectrum{/v0.26}
  {v0.28}, Language, ComCtrls, URLLabel{/v0.28} ;{tilemode messages clientstyle}

  {tstringgrid timer timegettime ulatype ulmtype ulobju}

type
  TAAPanel = (apVersion, apStatus{v0.44}, apDebug{/v0.44});
  TAAChild = (acSequence, acDefPrg, acDefMethod);

  TAAForm = class(TForm)
    BuffersPanel: TOneEditPanel;
    Valve1Panel: TOneEditPanel;
    Pump1Panel: TValuePanel;
    Valve2Panel: TOneEditPanel;
    Temp1Panel: TValuePanel;
    Pump2Panel: TValuePanel;
    Temp2Panel: TValuePanel;
    LineConnector1: TLineConnector;
    LineConnector2: TLineConnector;
    LineConnector3: TLineConnector;
    LineConnector4: TLineConnector;
    LineConnector5: TLineConnector;
    LineConnector6: TLineConnector;
    LineConnector7: TLineConnector;
    LineConnector8: TLineConnector;
    LineConnector9: TLineConnector;
    LineConnector10: TLineConnector;
    LineConnector11: TLineConnector;
    CommandPanel: TPanel;
    HelpBtn: TButton;
    StartBtn: TButton;
    SettingsBtn: TButton;
    SequenceBtn: TButton;
    OnOffBtn: TButton;
    DisplayBtn: TButton;
    ProgramBtn: TButton;
    TableBtn: TButton;
    GraphBtn: TButton;
    StatusBtn: TButton;
    VersionPanel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    StatusPanel: TPanel;
    SamplePanel: TPanel;
    LineConnector12: TLineConnector;
    ULObjCtrl1: TULObjCtrl;
    ULObjCtrl3: TULObjCtrl;
    ULObjCtrl2: TULObjCtrl;
    ULObjCtrl4: TULObjCtrl;
    ULObjCtrl5: TULObjCtrl;
    ULObjCtrl6: TULObjCtrl;
    ULObjCtrl7: TULObjCtrl;
    ULObjCtrl8: TULObjCtrl;
    NHDPanel: TOneEditPanel;
    ULObjCtrl9: TULObjCtrl;
    ULObjCtrl10: TULObjCtrl;
    ULObjCtrl11: TULObjCtrl;
    AAAStatusPanel: TOneEditPanel;
    ULObjCtrl12: TULObjCtrl;
    ULObjCtrl13: TULObjCtrl;
    ULObjCtrl14: TULObjCtrl;
    ULObjCtrl15: TULObjCtrl;
    ULObjCtrl16: TULObjCtrl;
    DevicesPanel: TPanel;
    P1StateLabel: TLabel;
    P1StateEdit: TEdit;
    ULObjCtrl17: TULObjCtrl;
    P2StateEdit: TEdit;
    P2StateLabel: TLabel;
    ULObjCtrl18: TULObjCtrl;
    ColStateEdit: TEdit;
    ULObjCtrl19: TULObjCtrl;
    Label4: TLabel;
    ULObjCtrl20: TULObjCtrl;
    Label5: TLabel;
    ReactStateEdit: TEdit;
    ASStateEdit: TEdit;
    Label6: TLabel;
    ULObjCtrl21: TULObjCtrl;
    UsrStateTimeEdit: TEdit;
    ULObjCtrl22: TULObjCtrl;
    DetStateEdit: TEdit;
    ULObjCtrl23: TULObjCtrl;
    ULObjCtrl24: TULObjCtrl;
    ULObjCtrl25: TULObjCtrl;
    Label7: TLabel;
    DetAPanel: TOneEditPanel;
    DetBPanel: TOneEditPanel;
    Label8: TLabel;
    Label9: TLabel;
    ChildMenu: TPopupMenu;
    NewItem: TMenuItem;
    OpenItem: TMenuItem;
    EditItem: TMenuItem;
    SimulationCheckBox: TCheckBox;
    SkipCalCheckBox: TCheckBox;
    DebugPanel: TPanel;
    AcqDebRunBtn: TButton;
    AcqDebStopBtn: TButton;
    AcqLogCheckBox: TCheckBox;
    ProgramNamePanel: TOneEditPanel;
    SampleNamePanel: TOneEditPanel;
    SampleStatePanel: TOneEditPanel;
    AAAStateLbl: TLabel;
    TimeLabel: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    ULObjCtrl26: TULObjCtrl;
    ULObjCtrl27: TULObjCtrl;
    ULObjCtrl28: TULObjCtrl;
    AlarmButton: TButton;
    FatalButton: TButton;
    LineConnector13: TLineConnector;
    LineConnector14: TLineConnector;
    Label13: TLabel;
    ULObjCtrl29: TULObjCtrl;
    SequenceNamePanel: TOneEditPanel;
    test: TButton;
    ProgramMenu: TPopupMenu;
    PrgEditDefaultItem: TMenuItem;
    PrgSelectDefaultItem: TMenuItem;
    PrgNewDefaultItem: TMenuItem;
    PrgShowRunningItem: TMenuItem;
    PageControl: TPageControl;
    VersionSheet: TTabSheet;
    DevicesSheet: TTabSheet;
    DebugSheet: TTabSheet;
    ULObjCtrl30: TULObjCtrl;
    PumpStartInhibitCheckBox: TCheckBox;
    VersionLabel: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    URLLabel1: TURLLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AcqDebRunBtnClick(Sender: TObject);
    procedure ProgramBtnClick(Sender: TObject);
    procedure SettingsBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SequenceBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OnOffBtnClick(Sender: TObject);
    procedure StatusBtnClick(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure NewItemClick(Sender: TObject);
    procedure OpenItemClick(Sender: TObject);
    procedure EditItemClick(Sender: TObject);
    procedure TableBtnClick(Sender: TObject);
    procedure SimulationCheckBoxClick(Sender: TObject);
    procedure SkipCalCheckBoxClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DisplayBtnClick(Sender: TObject);
    procedure GraphBtnClick(Sender: TObject);
    procedure AcqDebStopBtnClick(Sender: TObject);
    procedure AcqLogCheckBoxClick(Sender: TObject);
    procedure AlarmButtonClick(Sender: TObject);
    procedure FatalButtonClick(Sender: TObject);
    procedure testClick(Sender: TObject);
    procedure PrgEditDefaultItemClick(Sender: TObject);
    procedure PrgSelectDefaultItemClick(Sender: TObject);
    procedure PrgNewDefaultItemClick(Sender: TObject);
    procedure PrgShowRunningItemClick(Sender: TObject);
  private
    { Private declarations }
    {FValuePanel: TValuePanel;
    FLineConnector: TLineConnector;
    FOneEditPanel: TOneEditPanel;}
    FLastWndText: string;
    FAAA: TAAA;{aaau}
    FCurAAPanel: TAAPanel;
    FCurAAChild: TAAChild;
    {v0.36}
    FObj: TULObj;
    {/v0.36}
  protected
    procedure WMAppMessage(var Message:TMessage);message WM_APPMESSAGE;
    procedure WndProc(var Message:TMessage);override;
    function GetAAA: TAAA;
    procedure SetCurAAPanel(ap: TAAPanel);
    procedure ChildMenuPopupAt({v0.38}AMenu: TPopupMenu;{/v0.38}AWinControl: TWinControl);
    {v0.36}
    procedure AAAUpdated;
    {/v0.36}
  public
    { Public declarations }
    property AAA: TAAA read GetAAA;
    property CurAAPanel: TAAPanel read FCurAAPanel write SetCurAAPanel;
  end;

const
  AAForm: TAAForm = nil;

implementation

{$R *.DFM}

procedure TAAForm.FormCreate(Sender: TObject);
begin
{  FValuePanel:= TValuePanel.Create(Self);
  FValuePanel.Top := 60;
  FValuePanel.Parent := Self; uldpobju}

{  FLineConnector:= TLineConnector.Create(Self);
  FLineConnector.Source := Button1;
  FLineConnector.Dest := ValuePanel1;
  FLineConnector.Parent := Self;}
  {FOneEditPanel:= TOneEditPanel.Create(Self); ulstringgrid}

  {v0.44}
  DebugPanel.Visible := UserMode = umSysOp;
  {/v0.44
  if UserMode = umSysOp then begin
    DebugPanel.Visible := true;
  end else begin
    DebugPanel.Visible := false;
  end;}
  {v0.36}
  AAA.Obj.UserRegister(Self);
  FObj := AAA.Obj;
  {/v0.36}
  {v0.44}
  SetCurAAPanel(apVersion);
  {/v0.44}
  {v0.50}
  VersionLabel.Caption := 'Chromulan v' + uLanVersion;
  {/v0.50}

end;

procedure TAAForm.FormActivate(Sender: TObject);
{var l,t,w,h: integer;}
begin
{  l := FValuePanel.Left;
  h := FValuePanel.Height;
  w := FValuePanel.Width;
  t := FValuePanel.Top;}
end;

function TAAForm.GetAAA: TAAA;
begin
  if FAAA = nil then
    FAAA := AAAu.AAA;
  Result := FAAA;
end;

{v0.36}
procedure TAAForm.WMAppMessage(var Message:TMessage);
begin
  case Message.WParam of
    cmULObjUpdated: begin
      if TULObj(Message.LParam) = AAA.Obj then
        AAAUpdated;
    end;
    cmULObjDestroyed: begin
      if TULObj(Message.LParam) = FObj then begin
        FObj.UserUnregister(Self);
        FObj := nil;
      end;
    end;
  end;
  inherited;
end;
{/v0.36}

procedure TAAForm.WndProc(var Message:TMessage);
var
  s:string;
  i:integer;
begin
  s := '';
  case Message.Msg of
    WM_Command: s := 'cmd';
    WM_MOVE: s := 'move';
    WM_ParentNotify: begin
      for i := 0 to ControlCount - 1 do begin
        Controls[i].Invalidate;
      end;
      Invalidate;
      s := 'parent';
    end;
    WM_Size: s := 'size';
    WM_APPMESSAGE: begin
      case Message.WParam of
        cmLogEvent: {ExeLog.Log(FLastWndText)};
      end;
    end;
  end;
  inherited;
  if s <> '' then begin
    FLastWndText := s;
    PostMessage(Handle, WM_APPMESSAGE, cmLogEvent, 0);
  end;
{  ExeLog.Log(s);}{uldptype}
end;

procedure TAAForm.AcqDebRunBtnClick(Sender: TObject);
begin
  {LogForm.Show;}
  AAA.AcqDebugStart;
end;

procedure TAAForm.ProgramBtnClick(Sender: TObject);
begin
  FCurAAChild := acDefPrg;
  ChildMenuPopupAt(ProgramMenu, ProgramBtn);
  {AAA.ProgramEdit; ulobju}
  {v0.29}{/v0.29 BringToFront;}
end;

procedure TAAForm.SettingsBtnClick(Sender: TObject);
begin
  AAA.SettingsEdit;{aaau}
  BringToFront;
end;

procedure TAAForm.FormDestroy(Sender: TObject);
begin
  {FAAA.Free;}
  {v0.36}
  if FObj <> nil then begin
    FObj.UserUnregister(Self);
    FObj := nil;
  end;
  {/v0.36}

  AAForm := nil;
end;

procedure TAAForm.ChildMenuPopupAt({v0.38} AMenu: TPopupMenu;{/v0.38}AWinControl: TWinControl);
var p:TPoint;
begin
  p.X := 0;
  p.Y := 0;
  p := AWinControl.ClientToScreen(p);
  {v0.38}AMenu{/v0.38 ChildMenu}.Popup(p.X, p.Y);
end;

procedure TAAForm.SequenceBtnClick(Sender: TObject);
begin
  {v0.25}
  if AAA.State = aasRunning then begin
    AAA.SequenceBrowse;
  end else
  {/v0.25}
  begin
    FCurAAChild := acSequence;
    ChildMenuPopupAt({v0.38}ChildMenu, {/v0.38}SequenceBtn);
    {AAA.SequenceEdit; {ulbrowseu }
    {BringToFront;}
  end;
end;

procedure TAAForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{  Action := caFree;}
end;

procedure TAAForm.OnOffBtnClick(Sender: TObject);
begin
  AAA.UsrRequestOnOff;
  {v0.36}
  SetCurAAPanel(apStatus);
  {/v0.36}
end;

procedure TAAForm.StatusBtnClick(Sender: TObject);
begin
  if CurAAPanel <> apStatus then
    CurAAPanel := apStatus
  else
    CurAAPanel := apVersion;
  {v0.44}
  DebugPanel.Visible := (UserMode = umSysOp);
  {/v0.44}
end;

procedure TAAForm.SetCurAAPanel(ap: TAAPanel);
begin
  {if FCurAAPanel = ap then
    exit;}
  {v0.44}
  case ap of
    apVersion: begin
      PageControl.ActivePage := VersionSheet;
    end;
    apStatus: begin
      PageControl.ActivePage := DevicesSheet;
    end;
    apDebug: begin
      PageControl.ActivePage := DebugSheet;
    end;
  end;
  {/v0.44
  case ap of
    apVersion: begin
      VersionPanel.Visible := true;
      DevicesPanel.Visible := false;
    end;
    apStatus: begin
      VersionPanel.Visible := false;
      DevicesPanel.Visible := true;
    end;
  end;}                                   {ulobjctrl}
  FCurAAPanel := ap;
end;

procedure TAAForm.StartBtnClick(Sender: TObject);
var r: integer;
begin
  if AAA.State = aasRunning then begin
    if ShowMessage(GetTxt({#}'Abort sequence run?'), smNoYes, 0) <> cmYes then
      exit;

    AAA.UsrSetAAAState(aasReady);
    {v0.36}{/v0.36
    StartBtn.Caption := 'Start';}
  end else begin
    r := AAA.UsrSetAAAState(aasRunning);
    if r <> 0 then begin
      {v0.38}
      if r = arNoSamples then begin
        ShowMessage(GetTxt({#}'No samples'), smError, 0);
      end else
      {/v0.38}
        ShowMessage(GetTxt({#}'AAA not ready'), smError, 0);
    end else begin
      {v0.36}{/v0.36
      StartBtn.Caption := 'Stop';}
    end;
  end;
end;

procedure TAAForm.NewItemClick(Sender: TObject);
begin
  case FCurAAChild of
    acSequence: begin
      AAA.SequenceNew;
    end;
    acDefPrg: begin
      AAA.DefPrgNew;
      {v0.29}{/v0.29 BringToFront;}{aapgtype}
    end;
    acDefMethod: begin
      AAA.DefMethodNew;
      BringToFront;
    end;
  end;
end;

procedure TAAForm.OpenItemClick(Sender: TObject);
begin
  case FCurAAChild of
    acSequence: AAA.SequenceOpen;
    acDefPrg:  begin
      AAA.DefPrgOpen; {aapgobju}
      {v0.29}{/v0.29 BringToFront;}
    end;
    acDefMethod: begin
      AAA.DefMethodOpen;
      BringToFront;
    end;
  end;
end;

procedure TAAForm.EditItemClick(Sender: TObject);
begin
  case FCurAAChild of
    acSequence: AAA.SequenceBrowse;
    acDefPrg: begin
      AAA.DefPrgBrowse;
      {v0.29}{/v0.29 BringToFront;}
    end;
    acDefMethod: begin
      AAA.DefMethodEdit;
      BringToFront;
    end;
  end;
end;

procedure TAAForm.TableBtnClick(Sender: TObject);
begin
  FCurAAChild := acDefMethod;
  ChildMenuPopupAt({v0.38}ChildMenu,{/v0.38}TableBtn);
  BringToFront;
end;

procedure TAAForm.SimulationCheckBoxClick(Sender: TObject);
begin
  AAA.SimulationOn := SimulationCheckBox.Checked;
end;

procedure TAAForm.SkipCalCheckBoxClick(Sender: TObject);
begin
  AAA.SkipCalibration := SkipCalCheckBox.Checked;
end;

procedure TAAForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if AAA.State > aasOff then begin
    CanClose := False;
    ShowMessage(GetTxt({#}'AAA is not Off yet'), smError, 0);
  end;
end;

procedure TAAForm.DisplayBtnClick(Sender: TObject);
begin
  AAA.AcqShow;
end;

procedure TAAForm.GraphBtnClick(Sender: TObject);
begin
  AAA.SeqFileOpen;
end;

procedure TAAForm.AcqDebStopBtnClick(Sender: TObject);
begin
  AAA.AcqDebugStop;
end;

procedure TAAForm.AcqLogCheckBoxClick(Sender: TObject);
begin
  AAA.DebLogAcq := AcqLogCheckBox.Checked;
end;

procedure TAAForm.AlarmButtonClick(Sender: TObject);
begin
  AAA.DebugAlarmActivate;
end;

procedure TAAForm.FatalButtonClick(Sender: TObject);
begin
  AAA.DebugFatalActivate;
end;

procedure TAAForm.testClick(Sender: TObject);
{var
  f: TAcqData;
  i: integer;
  m0, m: longint;}
begin
{  for i := 0 to 5 do begin
    m0 := AllocMemSize;
    f := TAcqData.Create('D:\ULAN\Data\Sample2.ULF', omRead);
    m := AllocMemSize;
    f.Free;
    ExeLog.Log('TEST MEM: Cycle=' + IntToStr(i) + ' StartMem=' + IntToStr(m0) +
      ' AfterCreate=' + IntToStr(m) + ' Size=' + IntToStr(m - m0) + ' AfterFree=' + IntToStr(AllocMemSize)
        + ' Dif=' + IntToStr(AllocMemSize - m0));
  end;
}
end;

{v0.36}
procedure TAAForm.AAAUpdated;
begin
  case AAA.State of {aaau}
    aasDisconnected,
    aasAborted,
    aasFinished,
    aasStandby,
    aasOff,
    aasStarting,
    aasStopping,
    aasFinishing,
    aasAborting: begin
      StartBtn.Caption := 'Start';
      StartBtn.Enabled := false;
    end;

    aasReady, aasStopRunning: begin
      StartBtn.Caption := 'Start';
      StartBtn.Enabled := true;
    end;

    aasRunning: begin
      StartBtn.Caption := 'Stop';
      StartBtn.Enabled := true;
    end;

  end;

  if AAA.State > aasOff then begin
{    SetCurAAPanel(apStatus);}
  end else begin
{    SetCurAAPanel(apVersion);}
  end;
end;

{/v0.36}

{v0.38}
procedure TAAForm.PrgEditDefaultItemClick(Sender: TObject);
begin
   AAA.DefPrgBrowse;
end;

procedure TAAForm.PrgSelectDefaultItemClick(Sender: TObject);
begin
  AAA.DefPrgOpen;
end;

procedure TAAForm.PrgNewDefaultItemClick(Sender: TObject);
begin
  AAA.DefPrgNew;
end;

procedure TAAForm.PrgShowRunningItemClick(Sender: TObject);
begin
  AAA.ShowRunningPrg;
end;
{/v0.38}

end.
