unit Medit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  Broadcst, Mask;

const
  etUser = 0;
  etDate = 1;
  etTime = 2;

type
  TMEdit = class(TMaskEdit)
  private
    { Private declarations }
    (*
    FEditType:byte;
    FUserEditMask:string;
    function GetEditType:byte;
    procedure SetEditType(AEditType:byte);
    *)
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AComponent:TComponent);virtual;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
  published
    { Published declarations }
    {property EditType:byte read GetEditType write SetEditType;}
  end;


procedure Register;

implementation

constructor TMEdit.Create(AComponent:TComponent);
begin
  inherited Create(AComponent);
{  FUserEditMask := EditMask;
  EditType := etUser;}
end;
(*
function TMEdit.GetEditType:byte;
begin
  GetEditType := FEditType;
end;

procedure TMEdit.SetEditType(AEditType:byte);
begin
  if FEditType = AEditType then
    exit;
  FEditType := AEditType;
  case FEditType of
    etUser: EditMask := FUserEditMask;
    etDate: EditMask := '####-##-##;1;';
    etTime: EditMask := '##:##';
  end;
end;
*)

procedure TMEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  inherited KeyUp(Key, Shift);
  PostMessage(Application.MainForm.Handle, WM_APPMESSAGE, cmTextSelected, longint(Self))
end;

procedure TMEdit.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseUp(Button, Shift, X, Y);
  PostMessage(Application .MainForm.Handle, WM_APPMESSAGE, cmTextSelected, longint(Self));
end;

procedure Register;
begin
  RegisterComponents('Samples', [TMEdit]);
end;

end.
