unit ULScriptType;
{ - types, constants used by scripts;
  -  list of functions accessible from the
     ULScripts }


interface
{ function GetCurPath(AULObjPathAlias: string): string; }

  { Returns absolute ULObjPath of an ULObject that correspond to the
    folowing pnXXXX parameters used as input.
    Returns empty string if the objects does not exist (or the input parameter
    is wrong). }

{paXXXX Path Aliases}
const
  paActiveChannel = 'ActiveChannel';
    { Returns ULObjPath to the channel (ULLType) that belongs to the Processor
      that executes the script }
  paActiveSequence = 'ActiveSequence';
    { Retuns ULObjPath to the active sequence (ULSQType) that belongs to the
      Processor that is executing the script. Returns empty string if no
      sequence is active. }
  paActiveSampleHead = 'ActiveSampleHead';
    { Returns ULObjPath to the active sample head (ULSRType) of the active
      sequence.  Returns empty string if no such beast exists. }
  paActiveSampleData = 'ActiveSampleData';
    { Returns ULObjPath to the active sample data (ULAType), i.e. the acquistion
      for the current sample must be running }
  paNextSampleHead = 'NextSampleHead';

  paActiveProgram = 'ActiveProgram';

{/paXXXX}

{ function ObjSetStr(AULObjPath: string; APropName: string; AValue: string): boolean; }

  { Modify property of ULObject using its ULObjPath, property name and
    new property value. Returns false if input parameters are wrong or the
    object does not exist. }

{ function ObjGetStr(AULObjPath: string; APropName: string): string; }
  { Retrieve value of the property of ULObject specified by ULObjPath
    and property name. Returns empty string if object not found (or if
    the property value is really empty - for number properties return empty
    string only in the case of error) }

{ function GetDevicePath(ADeviceAlias: string): string; }
  { Returns absolute ULObjPath of active channel device specified by its
    alias. }

{ function DevSetStr(ADeviceAlias: string; ADevPropName: string; AValue: string): boolean;}
  { Function to directly modify property of the active channel device, shortcut
    for ObjSetStr(GetDevicePath(ADeviceAlias) + '.' + ADevPropName, 'ValueInPC',
    AValue) }

{ funtion DevGetStr(ADeviceAlias: string; ADevPropName: string): string; }
  { Function to directly retrieve property of the active channel device.
    Shortcut for ObjGetStr(GetDevicePath(ADeviceAlias) + '.' + ADevPropName,
    pnValueInPC) }

{neXXXX Named Events}
  { Can be used from scripts to set paActiveProgram's property 'WaitingFor';
    will cause suspending of the programs until this program's property
    is cleared (usually when the event occurs - in the case of mark by
    mark packet or by user action - mouse click/button press) }

const
  neMark = 'mark';

{/neXXXX}

implementation

end.
