unit ULADType;
 { Raw sample data head record }
interface
uses
  UlanType, ULRecTyp;{ULREC.LST}{ulobju ulobjrwu}

const
  ULADID = ord('U') + 256*ord('L') + 256*256*ord('A') + 256*256*256*ord('D');

type{uladobju}
  TULADRec = packed record{<Caption="Raw Data" DataChild=1
    Uses=ULDType,ULDRType NameProp=DataName UsingColors=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    DataName: string;{<Enabled=1 Caption="Data Line Name"
      Hint="User defined name of this data line">}
    Color: integer;{<Type=Color>}
    {v0.50}
    PropDesc: string;{<Enabled=1 Caption="Prop.Name" Type=ULEnum
      ValuesSourceRecID=ULDRID
      Hint="Name of the property the value of that should be aquired">}
    SamplingInterval: single;{<Enabled=1 Caption="Sampling Interval[s]"
      Hint="How often ask for the value of Prop.Name property">}
    SamplingKind: TSamplingKind;{<Enabled=1 Caption="Sampling Kind"
      Hint="How to take samples - poll or scan packets">}
    DeviceName: string;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULDID>}
    PointTimeInterval: single;{<Enabled=1 Caption="Point interval[ms]"
      Hint="Interval of data points in packets">}
    Addr: integer;{<Hint="What was the uLan network address of the DeviceName">}
    MultiplyY: TYValue;{<Enabled=1 DefVal=1
      Hint="Acquired Y value multiply by this before storing to file">}
    AddY: TYValue;{<Enabled=1 Hint="Add to acquired Y value before storing to file">}
    {/v0.50}
  end;
  PULADRec = ^TULADRec;

implementation

end.
