unit ULDRType;
  { ULDR device description record. uldrobju }
interface

uses
  UlanType, ULRecTyp, ModuType;{ULREC.LST}

const
  ULDRID = ord('U') + 256*ord('L') + 256*256*ord('D') + 256*256*256*ord('R');

type
  TULDRRec = packed record {<Caption="Device"
    ChildRecIDs=ULDPID
    Uses=ModuType,ULDPType Enabled=1 Visible=1 HasRecName=1 NameProp=DeviceName
    BrowseFieldList=IDDesc,DetectState,DeviceName,DeviceMode,DeviceType,ExtDevDrvName,DevicePortName>}
    Head: TULRecHead;
    Info: TULRecInfo;
    AddrStr: TModuleAddrStr;
      { Address of the device in uLan network, has meaning only for
        DeviceMode = dmUlan }
    IDName: string;
      { Autodetected name of the device/module }
    DeviceName: TDeviceName;{<Enabled=1>}
     { System wide unique name of the device in ULD list,
       can be modified by user }
    DeviceMode: TDeviceMode;{<Enabled=1 Type=Enum StripPrefix=dm>}
    DeviceType: TDeviceType;{<Enabled=1 Type=Enum StripPrefix=dt>}
    IDDesc: string;
      { The text describing the module in the form
        obtained from autodetcted module. }
    {v0.14}
    ExtDevDrvName: TExtDevDrvName;{<Enabled=1>}
      { if DeviceMode = dmExtDev then here should be specified name
        of the DLL that handles communication with the device,
        eventually followed by DLL initialization parameters
        (to dll submited the rest of this string stripped off
        of the DLL name itself, that must be the first word of the ExtDevDrvName)
        E.g. DEVDRV.PARAM DEVDRV.DLL will be tried to initialize with
        parameter 'PARAM'; see extdevintu.pas }
    DevicePortName: TDevicePortName;{<Enabled=1>}
      { For DeviceMode = dmExtDev or dmApex is this name of the
        COM port ("COM1","COM2",...), that should be used to
        communicate with the device (usually just receive data);
        if empty, it is assumed, that the DLL handles communication
        by itself and no COM port is opened by the Chromulan program.
        For dmApex only for device of DeviceType = dtDetector must
        be this value specified.}
    {/v0.14}
    {v0.23}
    SerialNumber: integer;{<NonVisible=1>}
      { ulrectyp }
    {/v0.23}
    {v0.24}
    DetectState: TModuleDetectState;{<Caption="State"
      Colors=clGray,clWhite,clGray,clWhite,clWhite,clRed,clGreen,clWhite,clBlack,clGray
      StripPrefix=ds>}
      { modutype  dsUnknown, dsDetecting, dsNotPresent, dsPresent dsSuspended,
        corresponding colors tcolor }
    AliveTimeout: TAcqTime;{<Enabled=1 Caption="Alive timeout[s]"
      Hint="For how long to wait for answer from module">}
      { How long to wait for answer from module before setting status
        to dsNotPresent. If no value assigned - 5 seconds is default.}
   {/v0.24}
  end;
  PULDRRec = ^TULDRRec;

implementation

end.
