unit USPDType;{v0.49}
  { Ulan Sequence Program Device time line; source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;{UlanRecs.lst}
const
  USPDID = ord('U') + 256* ord('S') + 256 * 256 * ord('P') + 256 * 256 * 256 * ord('D');
  {USPDtype}
type

  TUSPDRec = packed record {<Caption="Dev.Prg.Line" Enabled=1 Visible=1
    Hint="Program line to be sent to the device"
    SortExp=PrgTime SortedByNumber=1 EditModal=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PrgTime: TAcqTime;{<Enabled=1 UserCoef=60 NumDec=2 Caption="Time [min]"
      IsSortField=1>}
      { At what time from program start (in seconds internally, to user
        shown in minutes) the program line should execute }
    DeviceAlias: string;{<Enabled=1 Caption="Device alias"
      Hint="In what current channel device should be the command executed">}
    LineType: TInDeviceLineType;{<Enabled=1 Caption="Line Type"
      Hint="Type of the program line in device">}
    Param1: TScriptParam;{<Enabled=1 Caption="1st param."
      Hint="First script command line parameter">}
    Param2: TScriptParam;{<Enabled=1 Caption="2nd param."
      Hint="Second script command line parameter">}
    Param3: TScriptParam;{<Enabled=1 Caption="3rd param."
      Hint="Third script command line parameter">}
    Note: TPrgLineNote;{<Enabled=1 Caption="Note">}
    State: TPrgLineState;{<Hint="State of the program line" Type=Enum
      Colors=clBlacke,clWhite,clWhite,clGreen,clBlack,clYellow,clBlack,clGray,clWhite,clRed,clBlack,clWhite
      StripPrefix=pls>}
  end;
  PUSPDRec = ^TUSPDRec;

implementation

end.
