unit USPEType;{v0.50}
  { Ulan Sequence Program Event line; source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;{UlanRecs.lst}
const
  USPEID = ord('U') + 256* ord('S') + 256 * 256 * ord('P') + 256 * 256 * 256 * ord('E');

type

  TUSPERec = packed record {<Caption="Prg.Event Line" Enabled=1 Visible=1
    EditModal=1 SortExp="-100000 + ord(PrgEvent)" SortedByNumber=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PrgEvent: TPrgEvent;{<Enabled=1 Caption=Event>}
      { At what event the program line should execute }
    Condition: TPrgEventCondition;{<Enabled=1 Caption="Condition" Type=Enum StripPrefix=sc>}
    Script: TScriptName;{<Enabled=1 Caption="Script" Type=FileName
      Filter="Scripts (*.IFS)|*.IFS" Hint="Name of the script to be run at the Time">}
    Param1: TScriptParam;{<Enabled=1 Caption="1st param."
      Hint="First script command line parameter">}
    Param2: TScriptParam;{<Enabled=1 Caption="2nd param."
      Hint="Second script command line parameter">}
    Param3: TScriptParam;{<Enabled=1 Caption="3rd param."
      Hint="Third script command line parameter">}
    Note: TPrgLineNote;{<Enabled=1 Caption="Note">}
    State: TPrgLineState;{<Hint="State of the program line" Type=Enum
      Colors=clBlack,clWhite,clWhite,clGreen,clBlack,clYellow,clBlack,clGray,clWhite,clRed,clBlack,clWhite
      StripPrefix=pls>}
  end;
  PUSPERec = ^TUSPERec;

implementation

end.
