unit simport;

interface

TYPE TPORT = CLASS (TObject)
      PRIVATE
      PROCEDURE SetPort(pn : Word; a : Byte);
      FUNCTION GetPort(pn : Word) : Byte;
      PUBLIC
      PROPERTY RPORT[a : Word] : Byte READ GetPort WRITE SetPORT;  DEFAULT;
END;
     TPORTW = CLASS (TObject)
      PRIVATE          
      PROCEDURE SetPort(pn : Word; a: Word);
      FUNCTION GetPort(pn : Word) : Word;
      PUBLIC
      PROPERTY RPORTW[a : Word] : Word READ GetPort WRITE SetPort; DEFAULT;
END;
     TPORTL = CLASS (TObject)
      PRIVATE
      PROCEDURE SetPort(pn : worD; a: LongInt);
      FUNCTION GetPort(pn : Word) : LongInt;
      PUBLIC
      PROPERTY RPORTL[a : Word] : LongInt READ GetPort WRITE SetPort; DEFAULT;
END;

VAR PORT : TPort;
    PORTW : TPortW;
    PORTL : TPortL;

implementation

FUNCTION TPort.GetPort;
Var a : Byte;
BEGIN
     ASM
        MOV DX, pn;
        IN AL, DX;
        MOV a, AL;
     END;
     GetPort:=a;
END;

PROCEDURE TPort.SetPort;
BEGIN
     ASM
        MOV DX, pn;
        MOV AL, a;
        OUT DX, AL;
     END;
END;

FUNCTION TPortW.GetPort;
Var a : Word;
BEGIN
     ASM
        MOV DX, pn;
        IN AX, DX;
        MOV a, AX;
     END;
     GetPort:=a;
END;

PROCEDURE TPortW.SetPort;
BEGIN
     ASM
        MOV DX, pn;
        MOV AX, a;
        OUT DX, AX;
     END;
END;

FUNCTION TPortL.GetPort;
Var a : LongInt;
BEGIN
     ASM
        MOV DX, pn;
        IN EAX, DX;
        MOV a, EAX;
     END;
     GetPort:=a;
END;

PROCEDURE TPortL.SetPort;
BEGIN
     ASM
        MOV DX, pn;
        MOV EAX, a;
        OUT DX, EAX;
     END;
END;

INITIALIZATION
     PORT:=TPORT.Create;
     PORTW:=TPORTW.Create;
     PORTL:=TPORTL.Create;
FINALIZATION
     Port.Free;
     PortW.Free;
     PortL.Free;
end.
end.
