unit RdsFrm;{v0.21}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, Mask, ComCtrls, Buttons, TypInfo,
  DsnPanel, DsnProp, DsnSpctr, DsnUnit, DsnSubMl, DsnSubGr, DsnSubDp, DsnSelect;


type
  TRdsForm = class(TForm)
    RdsStage: TDsnStage;
    RdsRegister: TDsnDpRegister;
    RdsInspector: TDsnInspector;
    RdsSelect: TDsnSelect;
    ColorDialog: TColorDialog;
    FontDialog: TFontDialog;
    PopupMenu: TPopupMenu;
    DesignStartStop_Item: TMenuItem;
    DesignCancel_Item: TMenuItem;
    DesignLoad_Item: TMenuItem;
    DesignSaveToFile: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure Start1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RdsSelectChangeSelected(Sender: TObject;
      Targets: TSelectedComponents; Operation: TSelectOperation);
    procedure RdsStageControlCreate(Sender: TObject;
      Component: TComponent);
    procedure RdsStageDeleteQuery(Sender: TObject; Component: TComponent;
      var CanDelete: Boolean);
    procedure RdsInspectorBtnClick(Sender: TObject;
      Targets: TSelectedComponents; PropName: String; var Value: String);
    procedure FormDestroy(Sender: TObject);
    procedure Cancel1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure DesignLoad_ItemClick(Sender: TObject);
    procedure RdsStageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DesignSaveToFileClick(Sender: TObject);
  private
    Stream: TStream;
    FileName: String;
  public

  end;

var
  RdsForm: TRdsForm;

implementation

uses RdsToolBarFrm;

{$R *.DFM}
procedure TRdsForm.FormCreate(Sender: TObject);
var
  c: TComponent;
  i: integer;
  t: TClass;
begin
  //DsnRegister and DsnPanel are on different form,
  //1) You have to link them by coding.

  RdsRegister.DsnPanel:= RdsToolBarForm.RdsPanel;
  RdsRegister.ArrowButton:= RdsToolBarForm.ArrowButton;

  //2) You have to Register Classes before Creating. dsnpanel
  {RegisterClass(TDBMemo); tpersistent class tclass}
  for i := 0 to RdsToolBarForm.ComponentCount - 1 do begin
    c := RdsToolBarForm.Components[i];
    if c is TDsnButton then with c as TDsnButton do begin
      t := ControlClass;
      if t <> nil then begin
        {RegisterClass(TPersistentClass(t));}
      end;
    end;
  end;
end;

procedure TRdsForm.Start1Click(Sender: TObject);
begin
  if not RdsRegister.Designing then
  begin
    //Save Layout
    if Stream = nil then
      Stream:= TMemoryStream.Create;
    RdsStage.SaveToStream(Stream);
    //ObjectInspector.Position Setting
    //You have to do before starting Design.
    RdsInspector.Position.Top:= 120;
    RdsInspector.Position.Left:= 10;
    //Starting Design
    RdsRegister.Designing:= True;
    //Select Control by the Method
    {RdsSelect.Select(DBImage1);}
    //Menu
    {Start1.Caption:= 'End';
    Cancel1.Enabled:= True;}

    DesignStartStop_Item.Caption := 'Design &Stop';
    DesignCancel_Item.Enabled := true;
  end
  else
  begin
    //Ending Design
    RdsRegister.Designing:= False;
    //Menu
    {Start1.Caption:= 'Start';
    Cancel1.Enabled:= False;}

    DesignStartStop_Item.Caption := 'Design &Start';
    DesignCancel_Item.Enabled := false;
  end;
end;

procedure TRdsForm.Button2Click(Sender: TObject);
var
  List: TList;
begin
  //Select Controls by the Method
  {
  List:= TList.Create;
  List.Add(Label1);
  List.Add(Label2);
  RdsSelect.MultipleSelect(List);
  List.Free;}
end;

procedure TRdsForm.RdsSelectChangeSelected(Sender: TObject;
  Targets: TSelectedComponents; Operation: TSelectOperation);
begin
  //Change Selected Control by the Control that user selected.
  {
  if Operation = opAdd then
  begin
    if Targets.List.IndexOf(Label3) > -1 then
      RdsSelect.Select(DBImage1);

    if Targets.List.IndexOf(PageControl1) > -1 then
      RdsSelect.Select(PageControl1.ActivePage);
  end;
  }
end;

procedure TRdsForm.RdsStageControlCreate(Sender: TObject;
  Component: TComponent);
var
  PropInfo:PPropInfo; // TypInfo.pas
  Value: String;
begin
  //If the New Component is DBControl....
  //DataSource
  {
  PropInfo:= GetPropInfo(Component.ClassInfo,'DataSource');

  if PropInfo <> nil then
    SetOrdProp(Component,PropInfo,Integer(DataSource1));

  //DataField
  PropInfo:= GetPropInfo(Component.ClassInfo,'DataField');

  if PropInfo <> nil then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;

    SetStrProp(Component,PropInfo,Value);
  end;
  }
  //Compare with the Sample 1's Coding of Same Event-Handler.
end;

procedure TRdsForm.RdsStageDeleteQuery(Sender: TObject;
  Component: TComponent; var CanDelete: Boolean);
begin
{
  if (Component = DBNavigator1) or (Component is TDBImage)
    or (Component is TLabel) then
    CanDelete:= False;}
  if not CanDelete then
    ShowMessage(Component.Name + ', This Can Not Be Deleted');
end;

procedure TRdsForm.RdsInspectorBtnClick(Sender: TObject;
  Targets: TSelectedComponents; PropName: String; var Value: String);
// Targets:  List of Selected Controls
// PropName: Property Name of User Selecting
var
  PropInfo:PPropInfo; // TypInfo.pas
  aFont:TFont;
  i:integer;
  Component: TComponent;
begin
// Object Inspector Buntton Click
// Popupmenu Click

{  if PropName = 'DataField' then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;
  end;
}

  if PropName = 'Color' then
    if ColorDialog.Execute then
      Value:=IntToStr(ColorDialog.Color);


  if PropName = 'Font' then
  begin
    Component:= Targets[0];
    PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
    aFont:=TFont(GetOrdProp(Component,PropInfo));
    FontDialog.Font.Assign(aFont);
    if FontDialog.Execute then
      for i:= 0 to Targets.Count -1 do
      begin
        Component:= Targets[i];
        PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
        aFont:=TFont(GetOrdProp(Component,PropInfo));
        aFont.Assign(FontDialog.Font);
      end;
  end;
end;

procedure TRdsForm.FormDestroy(Sender: TObject);
begin
  if Stream <> nil then
    Stream.Free;
end;

procedure TRdsForm.Cancel1Click(Sender: TObject);
begin
  //Ending Design
  RdsRegister.Designing:= False;
  //Menu
  {Start1.Caption:= 'Start';
  Cancel1.Enabled:= False;}

  DesignStartStop_Item.Caption := 'Design &Start';
  DesignCancel_Item.Enabled := false;
  //Load Layout
  RdsStage.LoadFromStream(Stream);
end;

procedure TRdsForm.BitBtn1Click(Sender: TObject);
begin
{  Form3.Showmodal;}
end;

procedure TRdsForm.DesignLoad_ItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    FileName := OpenDialog.FileName;
    RdsStage.LoadFromFile(FileName);
    Stream.Position := 0;
    Stream.Size := 0;
    RdsStage.SaveToStream(Stream);
  end;
end;

procedure TRdsForm.RdsStageMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then
    PopupMenu.Popup(X + Left,Y + Top);
end;

procedure TRdsForm.DesignSaveToFileClick(Sender: TObject);
begin
  SaveDialog.FileName := FileName;
  if SaveDialog.Execute then begin
    FileName := SaveDialog.FileName;
    RdsStage.SaveToFile(FileName);
    Stream.Position := 0;
    Stream.Size := 0;
    RdsStage.SaveToStream(Stream);
  end;
end;

end.
