unit SeqPrgToDevu;
{ sending plkDevice program lines to device }

interface
uses
  SysUtils,
  SeqPrgu,
  USPDType, USPDObju,
  Channelsu,
  ULNType, ULNObju;

procedure SeqPrgToDev(ASeqPrg: TSeqPrg; AChannel: TChannel;
  const ADeviceAlias: string; const AParam: string);

implementation

uses
  Modulu,SeqPrgLCPbs1;

function StrToAuxOut(const S:string):Word;
var
  w: Word;
  i: integer;
  c: char;
begin
  w:=0;
  for i := 1 to length(S) do begin
    c := S[i];
    if (Ord(c)>=Ord('1')) and (Ord(c)<=Ord('9')) then
      w := w or (1 shl (Ord(c)-Ord('1')));
  end;
  Result := w;
end;

procedure LCPLineSend(AModule:TModule; var AOffset:Word; var ABuf; ASize:Word);
var
  prop:TModuleProp;
  {modulu}
begin
  with AModule do begin
    if not FindPropByDesc('PRGBYTES',prop) then exit;
    if OIMessageCreate = 0 then begin
      OIMessageWriteWord(StrToInt(prop.ULDP.PropIDStr));
      OIMessageWriteWord(ASize or $8000);
      OIMessageWriteWord(AOffset);
      OIMessageWriteBuf(ABuf,ASize);
      OIMessageWriteWord(0);
      OIMessageClose;
      inc(AOffset,ASize);
    end;
  end;
end;

procedure SeqPrgToDev(ASeqPrg: TSeqPrg; AChannel: TChannel;
  const ADeviceAlias: string; const AParam: string);
var
  i: integer;
  dl: TSeqPrgDeviceLine;
  m: TModule;
  offset: Word;
  LCPLine:TlcpbsLine;
begin
  if AChannel = nil then
    exit;
  if ASeqPrg = nil then
    exit;
  offset:=0;
  with ASeqPrg do begin
    for i := 0 to DeviceLineCount - 1 do begin
      dl := DeviceLines[i];
      with dl.USPD do begin {uspdtype}
        if DeviceAlias = AdeviceAlias then begin
          if AChannel.DeviceAliasToDevice(DeviceAlias,  m) then begin
            if AParam = 'LCP5020' then begin
              if LineType = 'FLOW' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineFlow);
                LCPLine.Head.LineType:=lcpltFlow;
                LCPLine.Flow.Time:=round(PrgTime*100/60);
                LCPLine.Flow.Flow:=round((StrToFloat(Param1)*1000));
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'GRADBC' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineGradient);
                LCPLine.Head.LineType:=lcpltGradient;
                LCPLine.Gradient.Time:=round(PrgTime*100/60);
                LCPLine.Gradient.GradB:=round((StrToFloat(Param1)*256));
                LCPLine.Gradient.GradC:=round((StrToFloat(Param2)*256));
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'AUXOUT' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineAuxOut);
                LCPLine.Head.LineType:=lcpltAuxOut;
                LCPLine.AuxOut.Time:=round(PrgTime*100/60);
                LCPLine.AuxOut.AuxOut:=StrToAuxOut(Param1);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'END' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLinePrgEnd);
                LCPLine.Head.LineType:=lcpltPrgEnd;
                LCPLine.PrgEnd.Time:=round(PrgTime*100/60);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'WAITSW' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineWaitSW_Mark);
                LCPLine.Head.LineType:=lcpltWaitSW_Mark;
                LCPLine.WaitSW_Mark.Time:=round(PrgTime*100/60);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'SENDMARK' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineSendMark);
                LCPLine.Head.LineType:=lcpltSendMark;
                LCPLine.SendMark.Time:=round(PrgTime*100/60);
                LCPLine.SendMark.DestAddr:=StrToInt(Param1);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'AUXVALV' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineAuxValv);
                LCPLine.Head.LineType:=lcpltAuxValv;
                LCPLine.AuxValv.Time:=round(PrgTime*100/60);
                LCPLine.AuxValv.AuxValv:=StrToInt(Param1);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'GRADVALV' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLineGradValv);
                LCPLine.Head.LineType:=lcpltGradValv;
                LCPLine.GradValv.Time:=round(PrgTime*100/60);
                LCPLine.GradValv.GradValv:=StrToInt(Param1);
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end else if LineType = 'PRESSCORR' then begin
                FillChar(LCPLine,sizeof(LCPLine),0);
                LCPLine.Head.LineSize:=sizeof(TlcpbsLineHead)+sizeof(TlcpbsLinePressCorr);
                LCPLine.Head.LineType:=lcpltPressCorr;
                LCPLine.PressCorr.Time:=round(PrgTime*100/60);
                LCPLine.PressCorr.PressCorr:=round((StrToFloat(Param1)*10));;
                LCPLineSend(m,offset,LCPLine,LCPLine.Head.LineSize);
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

end.
