unit FileEditFrm;

interface

uses
  SysUtils, Windows, Classes, Graphics, Forms, Controls, StdCtrls,
  RawPrinting, Menus, Language, Dialogs, WinUtl;

type
  TFileEditForm = class(TForm)
    Memo: TMemo;
    PopupMenu1: TPopupMenu;
    CopyAll_Item: TMenuItem;
    PrintAll_Item: TMenuItem;
    CopySelected_Item: TMenuItem;
    PrintSelected_Item: TMenuItem;
    Find_Item: TMenuItem;
    FindDialog: TFindDialog;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CopyAll_ItemClick(Sender: TObject);
    procedure PrintAll_ItemClick(Sender: TObject);
    procedure CopySelected_ItemClick(Sender: TObject);
    procedure PrintSelected_ItemClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Find_ItemClick(Sender: TObject);
    procedure FindDialogFind(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

procedure TFileEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

{v1.08}
procedure TFileEditForm.CopyAll_ItemClick(Sender: TObject);
begin
  Memo.SelectAll;
  Memo.CopyToClipboard;
end;

procedure TFileEditForm.PrintAll_ItemClick(Sender: TObject);
begin{rawprint}
  RawPrint('', Caption, Memo.Text);
end;
{/v1.08}

procedure TFileEditForm.CopySelected_ItemClick(Sender: TObject);
begin
  Memo.CopyToClipboard;
end;

procedure TFileEditForm.PrintSelected_ItemClick(Sender: TObject);
begin
  RawPrint('', Caption, Memo.SelText);
end;

procedure TFileEditForm.FormCreate(Sender: TObject);
begin
  LanguageCheckForm(Self);
end;
{/v1.08}
procedure TFileEditForm.Find_ItemClick(Sender: TObject);
begin
  FindDialog.Position := Point(Memo.Left + Memo.Width, Memo.Top);
  FindDialog.Execute;
end;

procedure TFileEditForm.FindDialogFind(Sender: TObject);
var
  FoundAt: LongInt;
  StartPos{, ToEnd}: integer;

  i, j: integer;
  ok: boolean;
  ft, s: string;

  function Match(c1, c2: char): boolean;
  begin
    if frMatchCase in FindDialog.Options then begin
      Result := (c1 = c2)
    end else begin
      Result := (AnsiUppercase(c1) = AnsiUppercase(c2));
    end;
  end;

begin {from delphi help TFindDialog example (for richedit):}
  StartPos := Memo.SelStart;
  FoundAt := -1;
  s := Memo.Text;
  ft := FindDialog.FindText;

  if frDown in FindDialog.Options then begin
    if Memo.SelLength <> 0 then
      StartPos := Memo.SelStart + Memo.SelLength;
    for i := StartPos to Length(s) do begin
      ok := true;
      for j := 1 to Length(ft) do begin
        if not Match(s[i + j - 1], ft[j]) then begin
          ok := false;
          break;
        end;
      end;
      if ok then begin
        FoundAt := i;
        break;
      end;
    end;
  end else begin
    if Memo.SelLength <> 0 then
      StartPos := StartPos - Memo.SelLength;
    for i := StartPos downto 1 do begin
      ok := true;
      for j := 1 to Length(ft) do begin
        if not Match(s[i + j - 1], ft[j]) then begin
          ok := false;
          break;
        end;
      end;
      if ok then begin
        FoundAt := i;
        break;
      end;
    end;
  end;
    {
    FoundAt := FindText(FindDialog1.FindText, StartPos, ToEnd, [stMatchCase]);}
  if FoundAt = -1 then
    exit;

  if frWholeWord in FindDialog.Options then begin
    if FoundAt > 1 then begin
      if not (s[FoundAt-1] in WordDelimitors) then
        exit;
    end;
    if (FoundAt + Length(ft)) <= Length(s) then begin
      if not (s[FoundAt + Length(ft)] in WordDelimitors) then
        exit;
    end;
  end;

  Memo.SetFocus;
  Memo.SelStart := FoundAt - 1;
  Memo.SelLength := Length(ft);
  Application.MainForm.SetFocus;
  SetFocus;
  if Parent <> nil then
    Parent.SetFocus;
  {BringToFront;}{tform}
end;

end.
