unit USPType;{v0.49}
  { Sequence program ; source for MakeComp program }
interface
uses
  UlanType, ULRecTyp;
const
  USPExt = '.USP';
  USPID = ord('U') + 256* ord('S') + 256 * 256 * ord('P');
  USPFilter = 'Sequence Programs (*.USP)|*.USP';
  {USPTType, USPEType}{ulanrecs.lst}
type
  TSeqPrgName = string[60];
  TSeqPrgDesc = string;

  TUSPRec = packed record {<Caption="Sequence Program" RootChild=1 ChildSorted=1
    ChildRecIDs=USPTID,USPEID,USPDID HasRecName=1 Uses=USPTType,USPEType,USPDType
    SortedByNumber=1 AskForSave=1 Enabled=1 Visible=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PrgName:TSeqPrgName;{<Enabled=1 Caption="Sequence Program Name">}
      { Name of the program }
    PrgDesc:TSeqPrgDesc;{<Enabled=1 Caption="Sequence Program Desc.">}
      { Longer description of the program. }
    WaitingFor: string;{<Hint="Named event for which is the program waiting to occur">}
      { Used only runtime for suspending the program }
  end;
  PUSPRec = ^TUSPRec;

implementation

end.
