unit mcollect;{collection with error handling}
interface
{$I define.pas}
{$I nodebug.pas}
uses
  objects;
type
  PMCollection = ^TMCollection;
  TMCollection = object(TCollection)
    ErrorCode:integer;
    constructor Init(ALimit, ADelta:integer);
    function IsOK:boolean;
    procedure Error(Code, Info: Integer); virtual;
  end;

  PMSortedCollection = ^TMSortedCollection;
  TMSortedCollection = object (TSortedCollection)
    procedure Insert(Item:Pointer);virtual;
  end;

implementation
{$IFDEF DPMI}
 uses msgboxi;
{$ELSE}
{ uses mymsgbox;}
{$ENDIF}


constructor TMCollection.Init(ALimit, ADelta:integer);
begin
  if not inherited Init(ALimit, ADelta) then
    Fail;
  ErrorCode := 0;
end;

function TMCollection.IsOK:boolean;
begin
  IsOK := ErrorCode = 0;
end;

procedure TMCollection.Error(Code, Info: Integer);
var
  s1,s2,s3,s4,s5:string[10];
begin
  ErrorCode := Code;
  if Code <> 0 then begin
    str(Code, s1);
    str(Info, s2);
    str(Count, s3);
    str(Limit, s4);
    str(Delta, s5);
    {$IFDEF DPMI}
    SysError('Collection error: ' +
      'code = ' + s1 +
      ', info = ' + s2 +
      ', count = ' + s3 +
      ', limit = ' + s4 +
      ', delta = ' + s5);
    {$ENDIF}
  end;
end;
{
coIndexError  -1     Index out of range. The Info parameter passed to the
                     Error method contains the invalid index.
                    
coOverflow    -2     Collection overflow. TCollection.SetLimit failed to
                     expand the collection to the requested size. The
                     Info parameter passed to the Error method contains
                     the requested size.
}

procedure TMSortedCollection.Insert(Item:Pointer);
var i:integer;
begin
  if not Search(KeyOf(Item),i) or Duplicates then AtInsert(i,Item);
end;


end.