unit BEMain;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Grids, DsgnIntf, ToolIntf, EditIntf, ExptIntf,
  TypInfo, Menus, Explor, Registry, ExtCtrls, ActnList;


// Uncomment next line fo Winamp panel - default if off becouse of small slow down ...
//{$DEFINE WINAMP_SUPPORT}
const sizeofbobrispanel=12;
      version='1.01';
type
  TUlanExpert=class(TIExpert)
  private
    panel,panel1,panel2,panel3:TPanel;
    cb:TControlBar;
    mb:TToolBar;
    mainm:TMainMenu;
    pbar:TWinControl;
    sizeoi:integer;
    savefont:TFont;
    form,oi:TForm;
    savedconsresize:TConstrainedResizeEvent;
    savedshortcut:TShortCutEvent;
    savedmainmenuchange:TMenuChangeEvent;
    findeditems:integer;
    {$IFDEF WINAMP_SUPPORT}
    winamppanel:TPanel;
    wapb:TPaintBox;
    songpos:integer;
    {$ENDIF}
  public
    constructor Create;
    destructor Destroy; override;
    function GetName: string; override;
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
    function GetAuthor: string; override;
    function GetComment: string; override;
    function GetPage: string; override;
    function GetGlyph: HICON; override;
    function GetState: TExpertState; override;
    function GetMenuText: string; override;
    procedure Execute; override;
    procedure MainConsResize(Sender:TObject;var MinWidth,MinHeight,MaxWidth,MaxHeight:Integer);
    procedure Timer(Sender:TObject);
    procedure AboutExec(Sender:TObject);
    procedure PanelMouseDown(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
    procedure PanelMouseUp(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
    procedure CommMinimize(Sender:TObject);
    procedure CommExit(Sender:TObject);
    procedure CommExplorer(Sender: TObject);
    procedure CommInspector(Sender: TObject);
    procedure CommProjectManager(Sender: TObject);
    procedure CommEditWindow(Sender: TObject);
    procedure CommPackage(Sender: TObject);
    procedure CommInspectorLeft(Sender: TObject);
    procedure CommInspectorRight(Sender: TObject);
    {$IFDEF WINAMP_SUPPORT}
    procedure CommPlayPause(Sender: TObject);
    procedure CommStopSong(Sender: TObject);
    procedure CommPrevSong(Sender: TObject);
    procedure CommNextSong(Sender: TObject);
    procedure WAPBPaint(Sender: TObject);
    procedure WAPBMouseDown(Sender:TObject; Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
    {$ENDIF}
    procedure MainShortCut(var Msg: TWMKey; var Handled: Boolean);
    procedure MainMenuChange(Sender: TObject; Source: TMenuItem; Rebuild: Boolean);
  end;

implementation

procedure TUlanExpert.MainShortCut(var Msg: TWMKey; var Handled: Boolean);
begin
 if ((GetKeyState(VK_CONTROL) and $8000)=0) and ((GetKeyState(VK_SHIFT) and $8000)<>0) and ((GetKeyState(VK_MENU) and $8000)<>0) then begin
  case Msg.CharCode of
   ord('z'),ord('Z'):begin Handled:=true; CommMinimize(nil); end;
{$IFDEF WINAMP_SUPPORT}
   ord('p'),ord('P'):begin Handled:=true; CommPlayPause(nil); end;
   ord('s'),ord('S'):begin Handled:=true; CommStopSong(nil); end;
   ord('n'),ord('N'):begin Handled:=true; CommNextSong(nil); end;
   ord('v'),ord('V'):begin Handled:=true; CommPrevSong(nil); end;
{$ENDIF}
   ord('i'),ord('I'):begin Handled:=true; CommInspector(nil); end;
   ord('b'),ord('B'):begin Handled:=true; CommExplorer(nil); end;
   ord('m'),ord('M'):begin Handled:=true; CommProjectManager(nil); end;
   ord('w'),ord('W'):begin Handled:=true; CommEditWindow(nil); end;
   ord('g'),ord('G'):begin Handled:=true; CommPackage(nil); end;
   ord('.'),ord('<'):begin Handled:=true; CommInspectorLeft(nil); end;
   ord(','),ord('>'):begin Handled:=true; CommInspectorRight(nil); end;
  end;
 end;
 if Handled then exit;
 if Assigned(savedshortcut) then begin
  savedshortcut(Msg,Handled);
 end;
end;

procedure TUlanExpert.MainConsResize(Sender:TObject;var MinWidth,MinHeight,MaxWidth,MaxHeight:Integer);
begin
 MaxHeight:=sizeofbobrispanel+cb.Height;
 cb.Top:=sizeofbobrispanel; cb.Width:=form.Width;
 MinHeight:=MaxHeight;
 if assigned(oi) then oi.SetBounds(0,MaxHeight,sizeoi,form.Monitor.Height-MaxHeight);
end;

procedure TUlanExpert.AboutExec(Sender:TObject);
var i:integer; ac:TAction;
begin
 for i:=0 to screen.DataModuleCount-1 do begin
  if screen.DataModules[i].ClassNameIs('TDelphiCommands') then break;
 end;
 ac:=screen.DataModules[i].FindComponent('HelpAboutCommand') as TAction;
 ac.Execute;
end;

procedure TUlanExpert.Timer(Sender:TObject);
var f:TForm; mi:TMenuItem;
{$IFDEF WINAMP_SUPPORT}
    time1,time2:integer; whwnd:HWND;
{$ENDIF}
    s,s2:string;
    i,j:integer;
    wasnonoptions:boolean;
begin
 try
  form.SetBounds(form.Monitor.Left,form.Monitor.Top,form.Monitor.Width,cb.Height+sizeofbobrispanel);
  if (findeditems and 8)=0 then begin
   mb:=form.FindComponent('MenuBar') as TToolBar;
   with mb do begin
    ParentFont:=true;
    Font.Charset:=DEFAULT_CHARSET;
    Font.Name:='Small Font';
    Font.Size:=6;
    AutoSize:=false;
    AutoSize:=true;
   end;
   pbar:=form.FindComponent('PaletteBar') as TWinControl;
   findeditems:=findeditems or 8;
  end else if (findeditems and 3)=1 then begin
   i:=mb.Left+mb.Width;
   j:=mb.Top;
   if abs(pbar.Top-j)<3 then pbar.Left:=i;
   findeditems:=findeditems or 2;
  end;
  s:=ToolServices.GetProjectName;
  if s<>'' then panel1.Hint:='Delphi 4 with Bobris Expert - '+s else panel1.Hint:='Delphi 4 with Bobris Expert V'+version;
  s:=ToolServices.GetCurrentFile;
  if s<>'' then panel1.Caption:=' '+ToolServices.GetCurrentFile else panel1.Caption:=' '+panel1.Hint;
  if (findeditems and 1)=0 then begin
   mi:=mainm.Items;
   if Assigned(mi) then begin
    for i:=0 to mi.Count-1 do begin
     s:=mi[i].Name; s2:=mi[i].Caption;
     if s='FileMenu' then s2:='&Fi' else
     if s='EditMenu' then s2:='&Ed' else
     if s='SearchMenu' then s2:='&Sr' else
     if s='ViewsMenu' then s2:='&Vi' else
     if s='ProjectMenu' then s2:='&Pr' else
     if s='RunMenu' then s2:='&Ru' else
     if s='ComponentMenu' then s2:='&Co' else
     if s='DatabaseMenu' then s2:='&Db' else
     if s='BoundsCheckerItem' then s2:='&Bc' else
     if s='ToolsMenu' then s2:='&Tl' else
     if s='HelpMenu' then s2:='&He';
     if s2<>mi[i].Caption then begin
      mi[i].Caption:=s2;
      findeditems:=findeditems and (not 2);
     end;
    end;
   end;
   findeditems:=findeditems or 1;
  end;
  if assigned(oi) then oi.SetBounds(0,form.Height,sizeoi,form.Monitor.Height-form.Height);
{$IFDEF WINAMP_SUPPORT}
  whwnd:=FindWindow('Winamp v1.x',nil);
  if whwnd<>0 then begin
   winamppanel.Visible:=true;
   SetLength(s,256);
   SetLength(s,GetWindowText(whwnd,PChar(s),255));
   wapb.Hint:=s;
   time1:=SendMessage(whwnd,WM_USER,0,105) div 1000;
   time2:=SendMessage(whwnd,WM_USER,1,105);
   if time2<>-1 then begin
    if time1<0 then time1:=0;
    songpos:=(wapb.Width*time1) div time2;
    time1:=time2-time1;
    if time1<0 then time1:=0;
    s:=Format('%2.2d:%2.2d\%2.2d:%2.2d',[time1 div 60,time1 mod 60,time2 div 60,time2 mod 60]);
   end else begin
    s:='Stopped';
    songpos:=0;
   end;
   if winamppanel.Hint<>s then begin
    winamppanel.Hint:=s;
    wapb.Invalidate;
   end;
  end else begin
   winamppanel.Visible:=false;
  end;
{$ENDIF}
  wasnonoptions:=false;
  for i:=0 to screen.FormCount-1 do begin
   f:=screen.Forms[i];
   if f.Caption='About Delphi' then begin
    f.Caption:='About Delphi with Bobris Expert';
    for j:=0 to f.ComponentCount-1 do if f.Components[j] is TLabel then begin
     if pos('Copyright',TLabel(f.Components[j]).Caption)>0 then begin
      TLabel(f.Components[j]).Caption:=TLabel(f.Components[j]).Caption+#13#10'BOBRIS EXPERT Version '+version+#13#10'Copyright 1998 by Bobris@usa.net';
     end;
    end;
   end else if f.ClassNameIs('TMenuBuilder') then begin
    wasnonoptions:=true;
    if (f.Visible) and (f.WindowState=wsNormal) and (f.Floating) then begin
     f.SetBounds(oi.Width,form.Height,form.Monitor.Width-oi.Width,form.Monitor.Height-form.Height);
     if (not oi.Visible) and (f=Screen.ActiveForm) then oi.Visible:=true;
    end;
   end else if f.ClassNameIs('TPackageEditorForm') then begin
    wasnonoptions:=true;
    if (f.Visible) and (f.WindowState=wsNormal) and (f.Floating) then begin
     if oi.Visible then begin
      f.SetBounds(oi.Width,form.Height,form.Monitor.Width-oi.Width,form.Monitor.Height-form.Height);
     end else begin
      f.SetBounds(0,form.Height,form.Monitor.Width,form.Monitor.Height-form.Height);
     end;
    end;
   end else if f.ClassNameIs('TProjectManagerForm') then begin
    wasnonoptions:=true;
    if (f.Visible) and (f.WindowState=wsNormal) and (f.Floating) then begin
     if oi.Visible then begin
      f.SetBounds(oi.Width,form.Height,form.Monitor.Width-oi.Width,form.Monitor.Height-form.Height);
     end else begin
      f.SetBounds(0,form.Height,form.Monitor.Width,form.Monitor.Height-form.Height);
     end;
    end;
   end else if f.ClassNameIs('TEditWindow') then begin
    wasnonoptions:=true;
    f.BorderStyle:=bsNone;
    if (f.Visible) and (f.WindowState=wsMaximized) then begin
     f.SetBounds(0,sizeofbobrispanel,form.Monitor.Width,form.Monitor.Height-sizeofbobrispanel);
    end else if (f.Visible) and (f.WindowState=wsNormal) then begin
     if oi.Visible then begin
      f.SetBounds(oi.Width,form.Height,form.Monitor.Width-oi.Width,form.Monitor.Height-form.Height);
     end else begin
      f.SetBounds(0,form.Height,form.Monitor.Width,form.Monitor.Height-form.Height);
     end;
    end;
   end else if f.ClassNameIs('TProjectOptionsDialog') then begin
    if (wasnonoptions) then f.Show;
   end;
  end;
 except
 end;
end;

constructor TUlanExpert.Create;
var i:integer;
    tim:TTimer;
begin
 inherited Create;
 oi:=nil;
 findeditems:=0;
 sizeoi:=200;
 mainm:=nil;
 form:=Application.MainForm;
 mainm:=TMainMenu(form.FindComponent('MainMenu1'));
 savedmainmenuchange:=mainm.OnChange;
 mainm.OnChange:=MainMenuChange;
 savefont:=form.Font;
 form.Font.Name:='Small Font';
 form.Font.Size:=7;
 form.AutoScroll:=false;
 savedshortcut:=Application.OnShortCut;
 Application.OnShortCut:=MainShortCut;
 mb:=form.FindComponent('MenuBar') as TToolBar;
 with mb do begin
  ParentFont:=true; ParentFont:=false;
  Font.Charset:=DEFAULT_CHARSET;
  Font.Name:='Small Font';
  Font.Size:=6;
  AutoSize:=true;
 end;
 savedconsresize:=form.OnConstrainedResize;
 form.OnConstrainedResize:=MainConsResize;
 cb:=form.controls[0] as TControlBar;
 cb.Align:=alNone;
 for i:=0 to screen.FormCount-1 do begin
  if screen.Forms[i].ClassNameIs('TPropertyInspector') then begin
   oi:=screen.Forms[i]; break;
  end;
 end;
 if Assigned(oi) then begin
  if not oi.Floating then oi.ManualFloat(Rect(0,form.Height,200,form.Monitor.Height-form.Height));
  oi.BorderStyle:=bsNone;
  oi.SetBounds(0,form.Height,200,form.Monitor.Height-form.Height);
  oi.Font.Name:='Small Font';
  oi.Font.Size:=7;
 end;
 panel:=TPanel.Create(form);
 panel.Parent:=form;
 panel.Font.Name:='Small Font';
 panel.Font.Size:=7;
 panel.Align:=alNone;
 panel.BevelOuter:=bvNone;
 panel.ShowHint:=true;
 panel.Name:='BobrisExplorerPanel';
 panel.Caption:='';
 panel1:=TPanel.Create(panel);
 panel1.Parent:=panel;
 panel1.BevelOuter:=bvNone;
 panel1.Align:=alLeft;
 panel1.SetBounds(0,0,300,12);
 panel1.Color:=clWhite;
 panel1.Alignment:=taLeftJustify;
 panel1.Font.Name:='Arial';
 panel1.Font.Size:=8;
 panel1.OnDblClick:=AboutExec;
 panel2:=TPanel.Create(panel);
 panel2.Parent:=panel;
 panel2.SetBounds(500,0,24,12);
 panel2.BevelOuter:=bvNone;
 panel2.Align:=alRight;
 panel3:=TPanel.Create(panel);
 panel3.Parent:=panel;
 panel3.SetBounds(300,0,144,12);
 panel3.BevelOuter:=bvNone;
 panel3.Align:=alLeft;
 with TPanel.Create(panel2) do begin
  Parent:=TWinControl(Owner);
  SetBounds(0,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommMinimize;
  Caption:='_';
  Hint:='MinimiZe Delphi'#13#10'Alt+Shift+Z';
  Font.Size:=6;
 end;
 with TPanel.Create(panel2) do begin
  Parent:=TWinControl(Owner);
  SetBounds(12,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommExit;
  Caption:='X';
  Hint:='Exit Delphi'#13#10'Alt+X';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(0,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommInspectorLeft;
  Caption:='';
  Hint:='Smaller Object Inspector'#13#10'Alt+Shift+<';
  Font.Name:='Wingdings';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(12,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommInspectorRight;
  Caption:='';
  Hint:='Bigger Object Inspector'#13#10'Alt+Shift+>';
  Font.Name:='Wingdings';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(24,0,24,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommInspector;
  Caption:='O&I';
  Hint:='Show/Hide Object Inspector'#13#10'Alt+Shift+I';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(48,0,24,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommExplorer;
  Caption:='&BEE';
  Hint:='Show Bobris Everything Explorer'#13#10'Alt+Shift+B';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(72,0,24,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommProjectManager;
  Caption:='P&M';
  Hint:='Show/Hide Project Manager'#13#10'Alt+Shift+M';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(96,0,24,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommEditWindow;
  Caption:='E&W';
  Hint:='Focus Edit Window'#13#10'Alt+Shift+W';
  Font.Size:=6;
 end;
 with TPanel.Create(panel3) do begin
  Parent:=TWinControl(Owner);
  SetBounds(120,0,24,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommPackage;
  Caption:='PK&G';
  Hint:='Focus PacKaGe Editor'#13#10'Alt+Shift+G';
  Font.Size:=6;
 end;
{$IFDEF WINAMP_SUPPORT}
 winamppanel:=TPanel.Create(panel);
 winamppanel.Parent:=panel;
 winamppanel.SetBounds(0,0,124,12);
 winamppanel.Align:=alRight;
 winamppanel.BevelOuter:=bvNone;
 with TPanel.Create(winamppanel) do begin
  Parent:=TWinControl(Owner);
  SetBounds(0,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommPlayPause;
  Caption:='&P';
  Hint:='Play/Pause Song'#13#10'Alt+Shift+P';
  Font.Size:=6;
 end;
 with TPanel.Create(winamppanel) do begin
  Parent:=TWinControl(Owner);
  SetBounds(12,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommStopSong;
  Caption:='&S';
  Hint:='Stop Song'#13#10'Alt+Shift+S';
  Font.Size:=6;
 end;
 with TPanel.Create(winamppanel) do begin
  Parent:=TWinControl(Owner);
  SetBounds(24,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommPrevSong;
  Caption:='';
  Hint:='PreVious Song'#13#10'Alt+Shift+V';
  Font.Name:='Wingdings';
  Font.Size:=6;
 end;
 with TPanel.Create(winamppanel) do begin
  Parent:=TWinControl(Owner);
  SetBounds(36,0,12,12);
  OnMouseDown:=PanelMouseDown; OnMouseUp:=PanelMouseUp;
  OnClick:=CommNextSong;
  Caption:='';
  Hint:='Next Song'#13#10'Alt+Shift+N';
  Font.Name:='Wingdings';
  Font.Size:=6;
 end;
 wapb:=TPaintBox.Create(winamppanel);
 with wapb do begin
  Parent:=TWinControl(Owner);
  ControlStyle:=ControlStyle+[csOpaque];
  SetBounds(48,0,winamppanel.Width-48,12);
  OnPaint:=WAPBPaint;
  OnMouseDown:=WAPBMouseDown;
  Hint:='Winamp panel';
  Font.Size:=8;
 end;
{$ENDIF}
 tim:=TTimer.Create(panel);
 tim.Interval:=250;
 tim.OnTimer:=Timer;
 tim.Enabled:=true;
 form.WindowState:=wsMaximized;
 form.BorderStyle:=bsNone;
 form.SetBounds(form.Monitor.Left,form.Monitor.Top,form.Monitor.Width,cb.Height+sizeofbobrispanel);
 panel.SetBounds(0,0,form.Width,sizeofbobrispanel);
 cb.SetBounds(0,sizeofbobrispanel,form.Width,cb.Height);
 BExplorer:=nil;
end;

destructor TUlanExpert.Destroy;
begin
 if not Application.Terminated then begin
  BExplorer.Free;
  panel.Free;
  cb.Align:=alTop;
  if Assigned(oi) then begin
   oi.BorderStyle:=bsSizeToolWin;
   oi.Font:=savefont;
  end;
  mainm.OnChange:=savedmainmenuchange;
  form.Font:=savefont;
  form.OnConstrainedResize:=savedconsresize;
  form.BorderStyle:=bsSizeable;
  form.WindowState:=wsNormal;
  form.WindowState:=wsMaximized;
  Application.OnShortCut:=savedshortcut;
 end;
 inherited Destroy;
end;

function TUlanExpert.GetName: string;
begin
 Result:='Bobris Expert';
end;

function TUlanExpert.GetStyle:TExpertStyle;
begin
 Result:=esAddIn;
end;

function TUlanExpert.GetIDString: string;
begin
 Result:='Bobris.ExpertIDE';
end;

function TUlanExpert.GetAuthor: string;
begin
 Result:='Bobris@usa.net';
end;

function TUlanExpert.GetComment: string;
begin
end;

function TUlanExpert.GetPage: string;
begin
end;

function TUlanExpert.GetGlyph: HICON;
begin
 Result:=0;
end;

function TUlanExpert.GetState: TExpertState;
begin
 Result:=[];
end;

function TUlanExpert.GetMenuText: string;
begin
end;

procedure TUlanExpert.Execute;
begin
end;

procedure TUlanExpert.CommExit(Sender: TObject);
begin
 Application.MainForm.Close;
end;

procedure TUlanExpert.CommMinimize(Sender: TObject);
begin
 Application.Minimize;
end;

procedure TUlanExpert.PanelMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 (Sender as TPanel).BevelOuter:=bvLowered;
end;

procedure TUlanExpert.PanelMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 (Sender as TPanel).BevelOuter:=bvRaised;
end;

procedure TUlanExpert.CommExplorer(Sender: TObject);
var i:integer;
    hwnd1,hwnd2,hwnd3,hwnd4:HWND;
    f,f2:TForm;
begin
 if not Assigned(BExplorer) then begin
  BExplorer:=TBExplorer.Create(Application);
  BExplorer.Show;
 end else begin
  f:=BExplorer;
  if Assigned(Sender) then f2:=form else f2:=nil;
  if f.Visible then begin
   hwnd4:=f.Handle;
   hwnd1:=GetTopWindow(0);
   for i:=0 to screen.FormCount-1 do if (screen.Forms[i].Visible) and (screen.Forms[i]<>f) and (screen.Forms[i]<>f2) then begin
    hwnd2:=hwnd1;
    hwnd3:=screen.Forms[i].Handle;
    repeat
     if hwnd2=hwnd4 then break;
     if hwnd2=hwnd3 then break;
     hwnd2:=GetNextWindow(hwnd2,GW_HWNDNEXT);
    until (hwnd1=hwnd2) or (hwnd2=0);
    if hwnd3=hwnd2 then begin f.Show; exit; end;
   end;
   f.Hide;
  end else f.Show;
 end;
end;

procedure TUlanExpert.CommInspector(Sender: TObject);
begin
 if not Assigned(oi) then exit;
 if oi.Visible then oi.Hide else oi.Show;
end;

procedure TUlanExpert.CommEditWindow(Sender: TObject);
var i:integer;
    f:TForm;
begin
 for i:=0 to screen.FormCount-1 do begin
  f:=screen.Forms[i];
  if f.ClassNameIs('TEditWindow') then begin
   if f.Visible then begin f.Show; break; end;
  end;
 end;
end;

procedure TUlanExpert.CommProjectManager(Sender: TObject);
var i:integer;
    hwnd1,hwnd2,hwnd3,hwnd4:HWND;
    f,f2:TForm;
begin
 f:=nil;
 if Assigned(Sender) then f2:=form else f2:=nil;
 for i:=0 to screen.FormCount-1 do begin
  f:=screen.Forms[i];
  if f.ClassNameIs('TProjectManagerForm') then break;
  f:=nil;
 end;
 if Assigned(f) then begin
  if f.Visible then begin
   hwnd4:=f.Handle;
   hwnd1:=GetTopWindow(0);
   for i:=0 to screen.FormCount-1 do if (screen.Forms[i].Visible) and (screen.Forms[i]<>oi) and(screen.Forms[i]<>f) and (screen.Forms[i]<>f2) then begin
    hwnd2:=hwnd1;
    hwnd3:=screen.Forms[i].Handle;
    repeat
     if hwnd2=hwnd4 then break;
     if hwnd2=hwnd3 then break;
     hwnd2:=GetNextWindow(hwnd2,GW_HWNDNEXT);
    until (hwnd1=hwnd2) or (hwnd2=0);
    if hwnd3=hwnd2 then begin f.Show; exit; end;
   end;
   f.Hide;
  end else f.Show;
 end;
end;

procedure TUlanExpert.CommPackage(Sender: TObject);
var i:integer;
    f:TForm;
begin
 for i:=0 to screen.FormCount-1 do begin
  f:=screen.Forms[i];
  if f.ClassNameIs('TPackageEditorForm') then begin
   if f.Visible then begin f.Show; break; end;
  end;
 end;
end;

procedure TUlanExpert.CommInspectorLeft(Sender: TObject);
begin
 if (sizeoi>100) then dec(sizeoi,20);
end;

procedure TUlanExpert.CommInspectorRight(Sender: TObject);
begin
 if (sizeoi<500) then inc(sizeoi,20);
end;

{$IFDEF WINAMP_SUPPORT}
procedure TUlanExpert.CommNextSong(Sender: TObject);
var whwnd:HWND;
begin
 whwnd:=FindWindow('Winamp v1.x',nil);
 if whwnd<>0 then begin
  SendMessage(whwnd,WM_COMMAND,40048,0);
 end;
end;

procedure TUlanExpert.CommPlayPause(Sender: TObject);
var whwnd:HWND; i:integer;
begin
 whwnd:=FindWindow('Winamp v1.x',nil);
 if whwnd<>0 then begin
  i:=SendMessage(whwnd,WM_USER,0,104);
  if i<>1 then SendMessage(whwnd,WM_COMMAND,40045,0) else SendMessage(whwnd,WM_COMMAND,40046,0);
 end;
end;

procedure TUlanExpert.CommPrevSong(Sender: TObject);
var whwnd:HWND;
begin
 whwnd:=FindWindow('Winamp v1.x',nil);
 if whwnd<>0 then begin
  SendMessage(whwnd,WM_COMMAND,40198,0);
 end;
end;

procedure TUlanExpert.CommStopSong(Sender: TObject);
var whwnd:HWND;
begin
 whwnd:=FindWindow('Winamp v1.x',nil);
 if whwnd<>0 then begin
  SendMessage(whwnd,WM_COMMAND,40047,0);
 end;
end;

procedure TUlanExpert.WAPBPaint(Sender: TObject);
begin
 with wapb.Canvas do begin
  Brush.Color:=clSilver;
  FillRect(Rect(songpos,0,wapb.Width,12));
  Brush.Color:=clAqua;
  FillRect(Rect(0,0,songpos,12));
  Brush.Style:=bsClear;
  TextOut(2,0,winamppanel.Hint);
 end;
end;

procedure TUlanExpert.WAPBMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var whwnd:HWND; time2:integer;
begin
 if Button=mbLeft then begin
  whwnd:=FindWindow('Winamp v1.x',nil);
  if whwnd<>0 then begin
   time2:=SendMessage(whwnd,WM_USER,1,105);
   if time2<>-1 then begin
    SendMessage(whwnd,WM_USER,1000*time2*X div wapb.Width,106);
   end;
  end;
 end;
end;
{$ENDIF}

procedure TUlanExpert.MainMenuChange(Sender: TObject; Source: TMenuItem;
  Rebuild: Boolean);
begin
 findeditems:=findeditems and not 1;
 if assigned(savedmainmenuchange) then savedmainmenuchange(sender,source,rebuild);
end;

initialization
  RegisterLibraryExpert(TUlanExpert.Create);
end.

