unit Peaksu;{v0.50}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, Baseline developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses Classes, ULRecTyp, ULRecUtl, ULObju, ULObjUsru,
  ULPType, ULPObju,
  ULPRType, ULPRObju;

type
  TPeaks = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetULP: TULPObj;
    function ChildCreate(AChildObj: TULObj): TULObjUsr; override;
  public
    property ULP: TULPObj read GetULP;
  end;


  TPeak = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetULPR: TULPRObj;
    function ChildCreate(AChildObj: TULObj): TULObjUsr; override;
  public
    property ULPR: TULPRObj read GetULPR;
  end;

implementation

function TPeaks.GetULP: TULPObj;
begin
  Result := TULPObj(Obj);
end;

function TPeaks.ChildCreate(AChildObj: TULObj): TULObjUsr;
var
  id:TULRecID;
  blr: TPeak;
begin
  Result := nil;
  if AChildObj = nil then begin
    id := ULPRID
  end else begin
    id := AChildObj.RecID;
  end;
  case id of
    ULPRID: begin
      blr := TPeak.Create(Self, AChildObj, id);
      Result := TULObjUsr(blr);
    end;
  else
    SetResult(urUnknownChildRecID, ULRecIDToStrStrip(id));{ulrecutl}
  end;
end;

function TPeaks.GetRecID: TULRecID;
begin
  Result := ULPID;
end;

{TPeak.}
function TPeak.GetULPR: TULPRObj;
begin
  Result := TULPRObj(Obj);
end;

function TPeak.ChildCreate(AChildObj: TULObj): TULObjUsr;
begin
  Result := nil;
end;

function TPeak.GetRecID: TULRecID;
begin
  Result := ULPRID;
end;
{/TPeak.}

{v0.24}
initialization
  RegisterClasses([TPeaks]);
{/v0.24}
end.
