unit ULObjUsrTreeFrm;{v0.47}{Form for rendering ULObj in TreeView }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,

  ULObjUsru, ComCtrls, ULStringGrid;

type
  TULObjUsrTreeForm = class(TForm)
    TreeView: TTreeView;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FULObjUsr: TULObjUsr;
    FGrid: TULStringGrid;
    FOwnsObjUsr: boolean;
    procedure SetULObjUsr(AULObjUsr: TULObjUsr);
    procedure AddChilds(ANode: TTreeNode; AULObjUsr: TULObjUsr);
  public
    { Public declarations }
    property ULObjUsr: TULObjUsr read FULObjUsr write SetULObjUsr;
    property OwnsObjUsr: boolean read FOwnsObjUsr write FOwnsObjUsr;
  end;

var
  ULObjUsrTreeForm: TULObjUsrTreeForm;

implementation

{$R *.DFM}

procedure TULObjUsrTreeForm.SetULObjUsr(AULObjUsr: TULObjUsr);
var
{  i: integer;}
  n: TTreeNode;

begin
  {ttreeview}
  if FULObjUsr = AULObjUsr then
    exit;
  if FULObjUsr <> nil then begin
    if FOwnsObjUsr then
      FULObjUsr.Free;
  end;
  FULObjUsr := AULObjUsr;
  TreeView.Items.Clear;
  if FULObjUsr <> nil then begin
    n := TreeView.Items.AddObject(nil, AULObjUsr.Caption, AULObjUsr);
    AddChilds(n, AULObjUsr);
  end;
end;

procedure TULObjUsrTreeForm.AddChilds(ANode: TTreeNode; AULObjUsr: TULObjUsr);
var
  n: TTreeNode;
  u: TULObjUsr;
  i: integer;
begin
  for i := 0 to AULObjUsr.ChildCount - 1 do begin
    u := AULObjUsr.Childs[i];
    n := TreeView.Items.AddChildObject(ANode, u.Caption, u);
    AddChilds(n, u);
  end;
end;

procedure TULObjUsrTreeForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;{ulstringgrid}
end;

procedure TULObjUsrTreeForm.FormCreate(Sender: TObject);
begin
  FGrid := TULStringGrid.Create(Self);
  FGrid.AutoSizeBrowseCols := true;{ulstringgrid}
  FGrid.Align := alClient;{alRight;}
  FGrid.Left := 350;
  FGrid.Top := 5;
  FGrid.Width := 200;
  FGrid.Height := 400;
  FGrid.Parent := Self;
end;

procedure TULObjUsrTreeForm.TreeViewChange(Sender: TObject;
  Node: TTreeNode);
begin
  FGrid.Obj := TULObjUsr(Node.Data).Obj;
end;

procedure TULObjUsrTreeForm.FormDestroy(Sender: TObject);
begin
  ULObjUsr := nil;
end;

end.
