program h2pas;
{$APPTYPE CONSOLE}
{converts C constants file to pascal constants file }
uses
  SysUtils;

procedure FSplit(AFileName:string; var ADir:string; var AName:string; var AExt:string);
var p:integer;
begin
  p := length(AFileName);
  ADir := '';
  AName := '';
  AExt := '';
  while (p > 0) and (AFileName[p] <> '.') do dec(p);
  if p > 0 then begin
    AExt := copy(AFileName, p, 255);
    AFileName := copy(AFileName, 1, p -1); dec(p);
  end;
  while (p > 0) and (AFileName[p] <> '\') and (AFileName[p] <> ':') do
    dec(p);
  if p > 0 then begin
    ADir := copy(AFileName, 1, p);
    AName := copy(AFileName, p + 1, 255);
  end else begin
    AName := AFileName;
  end;
end;
  

procedure Convert(InFile, OutFile: string);
var
  s,valu:string;
  p:byte;
  fin,fout:text;
  d:string;
  n:string;
  e:string;
begin
  InFile := ChangeFileExt(InFile, '.H');
  if OutFile = '' then
    OutFile := ChangeFileExt(InFile, '.PAS')
  else
    OutFile := ChangeFileExt(InFile, '.PAS');
  AssignFile(fin, InFile);
  reset(fin);
  assign(fout, OutFile);
  rewrite(fout);
{  d := ExtractFilePath(OutFile);
  n := ExtractFileName(OutFile);}
  FSplit(OutFile, d, n, e);
  writeln(fout,'unit ' + n + ';');
  writeln(fout,'interface');
  writeln(fout,'const');

{  writeln(}
  while not eof(fin) do begin
    readln(fin, s);
    p := pos('#', s);
    if p > 0 then begin
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      s := trim(copy(s, p, 255));{split off #define}
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      valu := trim(copy(s, succ(p),255));
{      dec(valu[0]);{remove ';'}
      s := trim(copy(s,1,pred(p)));
      writeln(fout, '  ', s, ' = ', valu,';');
    end;
  end;
  writeln(fout,'implementation');
  writeln(fout,'end.');
  close(fin);
  close(fout);
end;

begin
  if paramcount = 0 then begin
    writeln('Usage: H2PAS file1[.H] [file2[.PAS]]');
    writeln(' Converts C constants file to PAS constants file.');
  end else begin
    convert(paramstr(1), paramstr(2));
  end;
end.
