unit UPEXType;{v0.22}
interface
uses
  UlanType, ULRecTyp, ModuType;{ULanRECs.LST}

const
  UPEXID = ord('U') + 256*ord('P') + 256*256*ord('E') + 256*256*256*ord('X');

type
  TUPEXRec = packed record {<Caption="Expression" Enabled=1 Visible=1
    HasPointer=1
    Uses=ModuType,UPEPType,ULDType,ULDRType HasRecName=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PrgExpName: TULPrgExpName;{<Enabled=1 Caption="Exp.Name">}
    CmpOper: TULCmpOper;{<Enabled=1 Caption="Compare" Type=Enum StripPrefix=co>}
      { compare operator to be applied to this exp if some previous exp exists }
    MathOper: TULMathOper;{<Enabled=1 Caption="Operator" Type=Enum StripPrefix=mo>}
      { math. operator to be applied to this exp (AND, OR, Plus, Multiply,
        Divide only if some previous exists and coNone cmp oper set) }
    LeftBracket: boolean;{<Caption="Left bracket" Enabled=1 Enum=1>}
      { set if before this exp should be left bracket }
    PrgExpSrcType: TULPrgExpSrcType;{<Caption="Source" Enabled=1 Type=Enum StripPrefix=st>}
      { what type of source is used to get value }
    Value: string;{<Caption="Constant" Enabled=1>}
      { constant value used for PrgExpSrcType is stConstant }
    PrgExpsName: TULPrgExpsName;{<Caption="Source Expression Set" Enabled=1
      Type=ULEnum ValuesSourceRecID=UPEPID>}
      { name of the program expression set used as source
        if PrgExpSrcType is stPrgExps }
    PrgExpsName_Src_Ptr: longint;{<NonVisible=1>}
    DeviceName: TDeviceName;{<Caption="Device Name" Enabled=1
      Type=ULEnum ValuesSourceRecID=ULDID>}
    DeviceName_Src_Ptr: longint;{<NonVisible=1>}
    PropIDStr: TModulePropIDStr;{<Caption="Property Name" Enabled=1
      Type=ULEnum ValuesSourceRecID=ULDRID>}
    PropIDStr_Src_Ptr: longint;{<NonVisible=1>}
    RightBracket: boolean;{<Caption="Right bracket" Enabled=1 Enum=1>}
     { Set if after this exp should be right bracket }
  end;
  PUPEXRec = ^TUPEXRec;

implementation

end.
