unit dbftype;{dbfu}
{$I define.pas}
interface

type
  TDBFResult = integer;
  PDBF = pointer;

const
  DBFDLL = 'DBF';
  DBFVersion = '1.02';
  NoDBF = nil;

  DBFExt = '.DBF';
  DBFMaxRecBytes = 4000; { dBASE III record limit }
  DBFMaxFieldCount = 128; { dBASE III field limit  }
  DBFMaxFieldNameLen = 10;
  UnDeleteChar = 32;   {Character for Undeleted Record}
  DeleteChar   = 42;   {Character for Deleted Record}
  DBFDateLen = 8;
  DBFTimeLen = 6;
  DBFLogicalLen = 1;
  DBFDateTimeLen = DBFDateLen + DBFTimeLen;
  {DBFMoneyLen = 10;
  DBFMoneyDec = 2;}


{MY}
  DBFMaxIndexCount = 20;
  DBFMaxIndexExpLen = 40;
  DBFFieldTypes = ['C','N','D','L'];
{/MY}
type


  PDBFHead = ^TDBFHead;
  TDBFHead = Record
    DBFType     : Byte;
    Year       : Byte;
    Month      : Byte;
    Day        : Byte;
    RecCount   : LongInt;
    Location   : SmallInt;
    RecordLen  : SmallInt;
    Reserved   : Array[1..20] of Byte;
  end;

  PDBFRecord = ^TDBFRecord;
  TDBFRecord = ARRAY[0..DBFMaxRecBytes] OF Byte;

  TDBFFieldType = char;
  TDBFFieldAddr = longint;
  TDBFFieldLen = byte;
  TDBFFieldDec = byte;

  PDBFField = ^TDBFField;
  TDBFField = Record
    N    : Array[0..DBFMaxFieldNameLen{10}] of Char;{pchar}
    {.. FieldName}
    T    : TDBFFieldType;
    {.. FieldType}
    A    : TDBFFieldAddr;
    {.. FieldAddress}
    L     : TDBFFieldLen;
    {.. FieldLen}
    D     : TDBFFieldDec;
    {.. FieldDec}
    R     : Array[1..14] of Char;
  end;

  PDBFFields = ^TDBFFields;
  TDBFFields = ARRAY[1..DBFMaxFieldCount] OF TDBFField;

{MY}
  TDBFFieldNo = byte;
  TDBFFieldNameStr = string[DBFMaxFieldNameLen];
  PDBFIndexDef = ^TDBFIndexDef;
  TDBFIndexDef = record
    Tag:TDBFFieldNameStr;{ Jmno indexu pouvan k jeho vbru,
      obvykle je vhodn pout jmno pole, jeho hodnota
      vytv klovou hodnotu }
    Exp:PChar;{ DBase vraz udvajc klovou hodnotu pro index }
    Unique:boolean; { M bt klov hodnota pro kad zznam odlin? }
    Caption:PChar;{ Popis indexu pro uivatele, ukazuje se v nabdce
     pro vbr aktivnho indexu pro browse }
    Typ:char;{ DBF typ pole, ktermu klov hodnota odpovd.
      Pouv se pro uren jak doplnit uivatelem zadanou
      hodnotu pro vyhledn v indexu }
  end;

  PDBFIndexesDef = ^TDBFIndexesDef;
  TDBFIndexesDef = array[1..DBFMaxIndexCount] of TDBFIndexDef;

  {
    TRecordCount = longint;
    TTblResult = TDBFResult;
    TFldNum = TDBFFieldNo;
    TFldName = TDBFFieldNameStr;
    TFldStrVal = string;
    TFldNumVal = real;
    TFldIntVal = longint;
    TTblProperty = integer;
    TFieldCount = integer;}

{/MY}
(*
{$IFDEF TEST}
{sample xxxtype file for dbf file definition:}
const
  TestAlias = 'TEST';
  TestFieldCount = 2;
  TestDBFFields : array[1..TestFieldCount] of TDBFField =
  (
   (N:'TESTIK';T:'C';A:0;L:10),
   (N:'TEST2';T:'C';A:0;L:10)
  );
  TestIndexCount = 1;
  TestIndexes: array[1..TestIndexCount] of TDBFIndexDef =
  (
   (Tag:'TEST';Exp:'TEST';Unique:false)
  );

{sample xxxinc file containig templates for handlers}

{$ENDIF}
*)
implementation
end.