unit keyboard;
{$I define.pas}
{$i nodebug.pas}
{keyboard related stuff}
interface
uses dos, crt;

function StuffKeyboardBuffer(s:string):boolean;{puts chars from s to keyboard buffer,
                                                returns false if overflows}
procedure EmptyKeyboardBuffer; {epties keyboard buffer}


implementation

function StuffKeyboardBuffer(s:string):boolean;
var
  regs:Registers;
  res:boolean;
  i : byte;
begin
  res := true;
  for i := 1 to length(s) do begin
    regs.cl := ord(s[i]);
    regs.ch := 0;

    regs.ah := 5;     {put char to keyboard buf. function}
    Intr($16,regs);   {keyboard interrupt}
    if regs.al = 1 then begin
      res := false; {buffer full}
      break;
    end;
  end;
  StuffKeyBoardBuffer := res;
end;

procedure EmptyKeyboardBuffer; {epties keyboard buffer}
var
  ch : char;
begin
  while KeyPressed do begin
    ch := ReadKey;
    if ch = #0 then
      ch := ReadKey;
  end;
end;

end.