unit ControlFrm;{v0.55}
{ Window with controls for simulation of actions from devices }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TControlForm = class(TForm)
    SendMarkButton: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SendMarkButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  ControlForm: TControlForm = nil;

procedure ControlWindowShow;

implementation
uses
  Processoru;

{$R *.DFM}

procedure ControlWindowShow;
begin
  if ControlForm = nil then begin
    ControlForm := TControlForm.Create(Application);
    ControlForm.Show;
  end else begin
    ControlForm.BringToFront;
  end;
end;

procedure TControlForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
  ControlForm := nil;
end;

procedure TControlForm.SendMarkButtonClick(Sender: TObject);
begin
  Processors.DoMark(Sender);
end;

end.
