unit DevMode;{ Checking possible device modes for communication (ULAN/Pasive) }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls,
  UlanType, UlanGlob, {v0.53}{/v0.53 devsetfr,} MyType, Msgu, ShowMsg
  {v0.28}, Language{/v0.28};

type
  EInvalidDeviceMode = class(Exception);

function DeviceModeCheck(var ADevMode:TDeviceMode): boolean;
  { checks if ADevMode= dmUlan is allowed (WinNT), if not,
    sets to dmApex (then changes also CurDevMode do dmApex) }

{v0.53}
function UlanModeAllowedByOS: boolean;
{ returns true for Win98,WinNT,Win2000, false for Win95 }
function UL_DEV_NAME: string;
{ = 'UL_DRV'}
{/v0.53}

implementation

function DeviceModeCheck(var ADevMode:TDeviceMode): boolean;
  { checks if ADevMode is allowed, if not, gives
    user a chance to change it to some allowed value }
begin
  if {v0.53}
    (not UlanModeAllowedByOS)
    {/v0.53 (OSVersion.dwPlatformID <> VER_PLATFORM_WIN32_NT)}
     and
    (ADevMode = dmUlan)
  then begin
    Result := false;
    ShowMessage(GetTxt({#}
      {v0.53}
      'uLan driver can not be loaded in your operating system'
      {/v0.53
      'uLan driver can be loaded only under Windows NT/2000'}
      ), smError, 0);
    ADevMode := {v0.14}dmPasive;{/v0.14 dmUnspecified;}
    CurDeviceMode := dmPasive;
  end else begin
    Result := true;
  end;
  {v0.14}
  {/v0.14
  if (ADevMode = dmUnspecified) then begin
    if DevSetupForm.ShowModal = mrOK then
      ADevMode := CurDeviceMode;
  end;}
end;

{v0.53}
function OSIsWin98: boolean;
begin
  Result :=
    (OSVersion.dwPlatformID = VER_PLATFORM_WIN32_WINDOWS)
    and
    (
      (OSVersion.dwMajorVersion = 4) and (OSVersion.dwMinorVersion >= 10)
    );
  {win98????}
end;

function UlanModeAllowedByOS: boolean;
begin
  Result := false;
  if OSVersion.dwPlatformID = VER_PLATFORM_WIN32_NT then
    Result := true
  else if OSVersion.dwPlatformID = VER_PLATFORM_WIN32s then
    Result := false
  else if OSVersion.dwPlatformID = VER_PLATFORM_WIN32_WINDOWS then begin
    if OSIsWin98 then begin
      Result := true;
    end else begin
      Result := false;
    end;
  end;
end;

function UL_DEV_NAME: string;
begin
  Result := 'UL_DRV';
  {
  if OSVersion.dwPlatformID = VER_PLATFORM_WIN32_NT then begin
    Result := 'UL_DRV';
  end else if OSIsWin98 then begin
    Result := 'COM2';
  end;}
end;
{/v0.53}

end.
