unit udlrtype;{ Raw sample data line definition }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  UlanType, ULRecTyp;{ULANRECS.LST}{ulobjusru udlstype udlrobju}

const
  UDLRID = ord('U') + 256*ord('D') + 256*256*ord('L') + 256*256*256*ord('R');

type
  TUDLRRec = packed record{<Caption="Raw Data Def." NameProp=DataName Visible=1
    UsingColors=1 Uses=ULDType,ULDRType DataChild=1
    BrowseFieldList=DataName,Color,DeviceName,PropDesc,SamplingInterval,SamplingKind>}
    Head: TULRecHead;
    Info: TULRecInfo;
    DataName: string;{<Enabled=1 Caption="Data Line Name"
      Hint="User defined name of this data line">}
    Color: integer;{<Type=Color Enabled=1 DefVal=clBlue>}
    {v0.50}
    PropDesc: string;{<Enabled=1 Caption="Prop.Name" Type=ULEnum
      ValuesSourceRecID=ULDRID
      Hint="Name of the property the value of that should be acquired">}
    SamplingInterval: single;{<Enabled=1 Caption="Sampling Interval[s]"
      Hint="How often ask for the value of Prop.Name property">}
    SamplingKind: TSamplingKind;{<Enabled=1 Caption="Sampling Kind"
      Hint="How to take samples - poll or scan packets">}
    DeviceName: string;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULDID
      Hint="Name of the device (if any), which property should be scanned">}
    PointTimeInterval: single;{<Enabled=1 Caption="Point interval[ms]"
      Hint="Interval of data points in packets" DefVal=40>}
      { For SamplingKind = Packet specifies what it the interval between
        consecutive data points in the packet }
    MultiplyY: TYValue;{<Enabled=1 DefVal=1
      Hint="Acquired Y value multiply by this before storing to file">}
    AddY: TYValue;{<Enabled=1 Hint="Add to acquired Y value before storing to file">}
    {/v0.50}
  end;
  PUDLRRec = ^TUDLRRec;                                              {ulndtype}

  { must be defined as DataChild because it is beeing assigned to ULAD obj }

implementation

end.
