unit AAFatalFrm;{ Error reporting form for Amino Acid Analyzer application }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Timer, Timersu{v0.25}, beeper{/v0.25};

type
  TAAFatalForm = class(TForm)
    lbl: TLabel;
    NoBtn: TButton;
    YesBtn: TButton;
    procedure NoBtnClick(Sender: TObject);
    procedure YesBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FStartTime: integer;
    FTimeout: integer;
    FIsAlarm: boolean;
    {v0.25}
    FBeeper: TBTBeeper;
  protected
    function GetText: string;
    procedure SetText(AValue: string);
  public
    { Public declarations }
    procedure DoTimer(Sender: TObject);
    property Text: string read GetText write SetText;
    property Timeout: integer read FTimeout write FTimeout;
    property IsAlarm: boolean read FIsAlarm write FIsAlarm;
  end;

implementation
uses
  AAAu;
{$R *.DFM}

function TAAFatalForm.GetText: string;
begin
  Result := lbl.Caption;
end;

procedure TAAFatalForm.SetText(AValue: string);
begin
  lbl.Caption := AValue;
end;

procedure TAAFatalForm.NoBtnClick(Sender: TObject);
begin
  AAA.ErrorCanceled;
  Release;
end;

procedure TAAFatalForm.YesBtnClick(Sender: TObject);
begin
  AAA.ErrorConfirmed;
  Release;
end;

procedure TAAFatalForm.FormCreate(Sender: TObject);
begin
  FStartTime := mstime;
  FTimeout := 60*1000;
  {v0.25}
  FBeeper := TBTBeeper.Create(Self);
  {/v0.25}
  Timers.AddTimerProc(DoTimer, 1000);
end;

procedure TAAFatalForm.DoTimer(Sender: TObject);
var
  ps: TPresetSound;
begin
  if (mstime - FStartTime) > FTimeout then begin
    AAA.ErrorConfirmed;
    Release;
  end else begin
    BringToFront;
{ TPresetSound = ( psOK,
                   psError,
                   psWelcome,
                   psEmergency,
                   psWrong,
                   psCall,
                   psOfficial,
                   psDaze,
                   psFall,
                   psChord,
                   psWhisle,
                   psHanging,
                   psClimb );
}
    if FIsAlarm then
      ps := psError
    else
      ps := psEmergency;
    FBeeper.PlayPresetSound(ps);
  end;{spectrum}
end;

procedure TAAFatalForm.FormDestroy(Sender: TObject);
begin
  Timers.DeleteTimerProc(DoTimer);
end;

end.
