unit DrvLogu;
{ Logging modules communication }
{$I define.pas}
interface
uses Timer, LogType, Logu{v0.19}, MyType, ConfType, Confu{/v0.19};

procedure DrvLogInit;
procedure DrvLogDone;
procedure DrvLog(const msg: string);

{v0.19}
procedure DrvLogRegister;
const
  UseDrvLog: boolean = false;
{/v0.19}
implementation

const
  dlog: PLogger = nil;

procedure DrvLogInit;
var l: PLogger;
begin
  {v0.19}
  if not UseDrvLog then
    exit;
  {/v0.19}
  if dlog <> nil then
    exit;
  LogInit(0, ltSysLog, 'DRV.LOG', l);
  dlog := l;
end;

procedure DrvLogDone;
begin
  if dlog = nil then
    exit;
  LogDone(dlog);
end;

procedure DrvLog(const msg: string);
begin
  if dlog = nil then
    exit;
  LogLog(dlog, msg);
end;

procedure DrvLogRegister;
begin
   AddGlobalVar(LogSec, 'UseDrvLog', @UseDrvLog, ptByte);
end;
{
initialization
  DrvLogInit;

finalization
  DrvLogDone;
}
end.
