unit InfoFrm;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TShowInfoForm = class(TForm)
    ShowInfoLabel: TLabel;
  private
    { Private declarations }
    procedure SetMsg(const AMsg: string);
    function GetMsg: string;
  public
    { Public declarations }
    property Msg: string read GetMsg write SetMsg;
  end;

var
  ShowInfoForm: TShowInfoForm;

procedure InfoFormShow(AMsg:string);
procedure InfoFormHide;

implementation

procedure TShowInfoForm.SetMsg(const AMsg: string);
begin
  ShowInfoLabel.Caption := AMsg;
end;

function TShowInfoForm.GetMsg: string;
begin
  Result := ShowInfoLabel.Caption;
end;

procedure InfoFormShow(AMsg:string);
begin
  ShowInfoForm.ShowInfoLabel.Caption := AMsg;
  ShowInfoForm.Show;
  Application.ProcessMessages;
end;

procedure InfoFormHide;
begin
  ShowInfoForm.Hide;
end;

{$R *.DFM}

end.
