unit Instrumentu;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses Classes, ULRecTyp, ULObju, ULObjUsru, ULIType, ULIObju;

type
  TInstrument = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetULI: TULIOBj;
    function ChildCreate(AChildObj: TULObj): TULObjUsr; override;
  public
    property ULI: TULIObj read GetULI;
  end;

implementation

function TInstrument.GetULI: TULIOBj;
begin
  Result := TULIObj(Obj);
end;

function TInstrument.ChildCreate(AChildObj: TULObj): TULObjUsr;
begin
  Result := nil;
end;

function TInstrument.GetRecID: TULRecID;
begin
  Result := ULIID;
end;

{v0.24}
initialization
  RegisterClasses([TInstrument]);
{/v0.24}
end.
