unit ModuType;
interface
uses
  Classes, Forms;

type
  TCharBuffer= array[0..64000] of char;
  PCharBuffer = ^TCharBuffer;
  TByteBuffer = array[0..64000] of byte;
  PByteBuffer = ^TByteBuffer;
  TLongintBuffer = array[0..16000] of longint;
  PLongintBuffer = ^TLongintBuffer;
  TWinPtr = TForm;

const
  NoWinPtr = nil;
  MaxModulePropCount = 100;
  ModulePropUpdateInterval = 1000;
    { readable values should be updated from device after every
      ModulePropUpdateInterval ms (if pfUpdateFromDeviceInTimer set) }
  {v0.13}
  MinModulePropUpdateInterval = 200;
    { update intervals can be only numbers dividable by this number }
  {/v0.13}

type
  TModulePropID = word;
    { Unique ID of the property in given device }
  TModulePropIDStr = string[6];
    { Ascii form of TModulePropID used in ULDPType/ULDPObju for searching the property
      (RecName) }
  TModulePropTypeDesc = string;
  TModulePropDesc = string;
  TModuleAddr = longint;
  TModuleAddrStr = string[6];
    { Ascii form of TModuleAddr used in ULDRType/ULDRObj, RecName }

type
  TModulePropFlags = longint;{see pfXXXX}

{pfXXXX module property flags, permanent properties of the module property }
const
  pfWrite = 1;
    { Property can be written to device }
  pfRead = 2;
    { Property can be read from device }
  pfUpdateToDeviceInTimer = 4;
    { Send "write value to device request" to device during next DoTimer if
      change of value in PC detected, if not set then the request is sent
      immediately after the value of property was changed from PC (= default). }
  pfUpdateFromDeviceInTimer = 8;
    { Value of the property is requested from device during every DoTimer call.
      If the flag is not set (=default), than the value is requested from
      the device only if the state flag of the property psReadRequested is set
      (automatically only after program start) }
  {v0.25}
  {pfNeedUpdateFromDevice = $10;}
  {/v0.25}
{/pfXXXX}

type
  TModulePropState = longint;
    { Runtime state flags of the property }
{psXXXX}
const
  psDetected = 1;
    { The property was autodetected in the device (as valid=present),
      i.e. it's value can be safely read/written from/to the device,
      (not controlled normally - autodetection takes place only if
      change in device description detected.). }
  {psWriteRequested = 2;
    { Set on (together with psModifiedFromPC) when value of the property was
      changed in PC and the property flag pfUpdateToDeviceInTimer is set.
      I.e. request for update will be sent in next DoTimer call.
      not used, modified is enough }
  psWriteSubmitted = 4;
    { Set by communication module if message to device containing request
      for setting device's property value was sent. This request is made
      either from timer or if pfUpdateToDeviceInTimer is not set, then
      from SetPropVal calls. }
  psReadRequested = 8;
    { Set on by user if wants the property copy its value from device during
      next DoTimer call. }
  psReadSubmitted = $10;
    { Set by communication module if message to device containing request
      for getting device's property value was sent }
  psModifiedFromPC = $20;
    { Current value of the property was set from PC (i.e. it is not sure
      that the same value is in device). Write value request to device
      might have been sent if  pfUpdateToDeviceInTimer is not set, otherwise
      it will be sent during the next DoTimer call }
  psUpdatedFromDevice = $40;
    { Current value of the property was set from device (from received ulan
      message) and was not modified from PC since that time) }
{/psXXXX}


{ptXXXX TModulePropTypeID constants}
type
  TModulePropTypeID = (
    ptCommand,{no data}
    ptWord,   {2 bytes data}
    ptInt32, {4 bytes data}
    ptSingle,  {4 bytes data}
    ptInt16
    {v0.50}
    ,ptUnknown
    {/v0.50}
  );
{/ptXXXX}

{piXXXX ModulePropertyIDs }
const
  piFlow = 220;{u2/.3;rw}

  piPCFG = 224;{u2}
  piPress = 225;{u2/.1;r}
  piPress_H = 226;{u2/.1;rw}
  piPress_L = 227;{u2/.1;rw}

  piStop = 250;{e}
  piStart = 251;{e}
  piPurge = 252;{e}

  piGrad_B = 231;{u2/*256}
  piGrad_C = 232;{u2/*256}

  piGradDir = 239;{u2}

  { ID of properties if TModule object (not ModuleProp objects) are negative }
  piULDR = -1;
    { access ULDR object of the module }
  piDeviceName = -2;
{/piXXXX}
const
  MaxModulePropID = 1000;

type
  TModuleResult = integer;
{mrXXXX}
const
  morOK = 0; {mrOK is modulresult}
  mr0 = 9900;
  mrInvalidOIState = mr0 + 1;
  mrInvalidPropDesc = mr0 + 2;
  mrInvalidTypeDesc = mr0 + 3;
  mrPropIsReadOnly = mr0 + 4;
  mrPropIsWriteOnly = mr0 + 5;

  mrNotInUlanMode = mr0 + 6;
  mrUlanDriverInitFailed = mr0 + 7;
  {v0.49}
  mrCanNotFreeULDrv = mr0 + 8;
  {/v0.49}
{/mrXXXX}

type
  TModuleActionID = integer;
    { specifies what the TModule object should do as soon as possible }
{maXXXX}
const
  ma0 = 11000;
  maGetRWPropIDList = ma0 + 1;
    { Send message requesting list of input propety IDs. No info. }
  maGetROPropIDList = ma0 + 2;
    { Send message requesting list of readonly propety IDs. No info. }
  maGetRWPropIDDesc = ma0 + 3;
    { Send message requesting description of the r/w property. Info = PropID. }
  maGetROPropIDDesc = ma0 + 4;
    { Send message requesting description of the read only property.
      Info = PropID. }
  maGetPropVal = ma0 + 5;
    { Send message requesting value of property. Info = ModuleProp. }
  maSetPropVal = ma0 + 6;
    { Send message requesting upload of new value to device. Info = ModuleProp. }
  maGetPropVals = ma0 + 7;
    { Send message requesting values of all readable properties from device.
      No info. }
  maSetPropVals = ma0 + 8;
    { Send message that will upload values of all writable properties to device.
      No info. }
{/maXXXX}

{dsXXXX}
type
  TModuleDetectState = (
    dsUnknown,  { state after starting the program until some communication takes place }
    dsDetecting, { request sent to device }
    dsNotPresent, { no answer came from device for AliveTimeout  }
    dsPresent {v0.24}, { device answered ok }
    dsSuspended{/v0.24} { user set the module state to this value manually,
      only in this state no attempt for connection are made by the program }
  );
{/dsXXXX}
{v0.24}
const
  DefaultAliveTimeout = 5; { in seconds, after what time without answer is
    module considered to be lost - disconnected }
  pvValueInPC = 'ValueInPC';
{/v0.24}
implementation

end.
