unit RectValsu;{v0.57 rectangle related values wrapped to classes }
 { e.g. for rectangles, margins }

interface
uses
  Windows;

type

  TRectVals = class(TObject)
  private
    FRect: TRect;
    function GetLeft: integer; virtual;
    function GetRight: integer; virtual;
    function GetTop: integer; virtual;
    function GetBottom: integer; virtual;
    function GetWidth: integer; virtual;
    function GetHeight: integer; virtual;
    procedure SetAll(AValue: integer);
  public
    property Left: integer read GetLeft;
    property Right: integer read GetRight;
    property Top: integer read GetTop;
    property Bottom: integer read GetBottom;
    property Width: integer read GetWidth;
    property Height: integer read GetHeight;
    property All: integer write SetAll;
  end;

implementation

function TRectVals.GetLeft: integer;
begin
  Result := FRect.Left;
end;

function TRectVals.GetRight: integer;
begin
  Result := FRect.Right;
end;

function TRectVals.GetTop: integer;
begin
  Result := FRect.Top;
end;

function TRectVals.GetBottom: integer;
begin
  Result := FRect.Bottom;
end;

function TRectVals.GetWidth: integer;
begin
  Result := FRect.Right - FRect.Left;
end;

function TRectVals.GetHeight: integer;
begin
  Result := FRect.Bottom - FRect.Top;
end;

procedure TRectVals.SetAll(AValue: integer);
begin
  FRect.Left := AValue;
  FRect.Top := AValue;
  FRect.Right := AValue;
  FRect.Bottom := AValue;
end;

end.
