unit ULSQType; { Ulan Sequence, source for MakeComp program }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  UlanType, ULRecTyp;
const
  ULQExt = '.ULQ';{template}
  ULSExt = '.ULS';
  ULSQID = ord('U') + 256* ord('L') + 256 * 256 * ord('S') + 256 * 256 * 256 * ord('Q');

type
  TSequenceName = string[40];
  TSequenceDesc = string;
  TSequenceStatus = (ssWaiting, ssRunning, ssIdle, ssBreak);
  TActionOnSignal = (asStop, asRunAgain, asIgnore);


type
  TULSQRec = packed record {<Caption="Sequence" RootChild=1
     OpenFilter="Sequence (*.ULS)|*.ULS" SaveFilter="Sequence (*.ULS)|*.ULS"
     ChildRecIDs=ULSRID,ULIID,ULMID,USPID HasRecName=1 BrowseChildRecIDs=ULSRID
     BrowseFieldList=SequenceName,SequenceDesc,Status,VialNr,FileMask
     Uses=ULSRType,ULIType,ULMType,USPType Enabled=1 Visible=1 EditModal=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    SequenceName:TSequenceName;{<Caption="Sequence name" ReadOnly=1
      Hint="Sequence name is a name of the subdirectory where samples data will be stored">}
      { Name of the sequence (= subdirectory). This subdirectory will be created
        in the dir where is this .ULS file (for AAA specified by AAAObj.SeqsDir).
        The name is created automatically from current date (yymmdd), order number
        in the current date is added (yymmdd-n).
        Base name of the .ULS file also equals to Sequence name, bat has in addition
        .ULS extension. }
    SequenceDesc:TSequenceDesc;{<Enabled=1 Caption="Sequence Desc.">}
      { Description of the sequence (what are the samples from, etc.). }
    Active_: boolean;{<NonVisible=1>}
      { If true then controlled by software otherwise by sampler (NOT USED?)}
    ActionOnSignal_: TActionOnSignal;{<NonVisible=1>}
      { What to do upon signal from device (NOT USED?)}
    Duration_: single;{<Hint="Value specified in the instrument info" NonVisible=1>}
      { Default duration of one analysis (see ulitype) in seconds }
    IdleTime_: single;{<Hint="Value specified in the instrument info" NonVisible=1>}
      { interval between samples (end of first - start of second) in seconds }
    Status: TSequenceStatus;{<StripPrefix=ss>}
      { in what run status is the sequence }
    VialNr: integer;
      { What is the current sample (vial in autosamlper), 0 if none }
    FileMask_: string;{<Hint="Value specified in the instrument info" NonVisible=1>}
      { How should look file names for acquired data of each run.
        E.g. "Sample*" will generate names Sample1, Sample2, ... .
        Copied from Template instrument. }
    PrgFileName: string;{<Enabled=1 Caption="Program" Type=FileName
      Filter="Sequence Program (*.AAP)|*.AAP">}
      { Default program file name for new sequence sample.
        Copied from instrument info. }
    MethodFileName: string;{<Enabled=1 Caption="Method" Type=FileName
      Filter="Method (*.ULM)|*.ULM">}
      { Default method file name for new sequence sample.
        Copied from method info. }
    ResultTableValue: TResultTableValue;{<Enabled=1 Caption="Results Value"
      Type=Enum Hint="Value of what peak property will be shown in results table"
      StripPrefix=tv>}
    DataTemplateFileName: string;{<Caption="Template" Type=FileName
      Filter="Template (*.ULF)|*.ULT">}
      { v0.41 template used for creation of the sequence (and data files) -
         for accessing instrument, channel settings. Used in standalone
         (non AAA) sequences. Template used for default values
         (Instrument - PrgFileName  Method - MethodFileName, ResultTableValue }
    {v0.49}
    SequenceKind: TSequenceKind;{<Caption="Sequence Kind" StripPrefix=sk>}
      { Specifies if the sequence was generated by Amino Acid Analyser
        application (old style) or for standalone - channel device set
        (new style) }
    {/v0.49}
  end;
  PULSQRec = ^TULSQRec;

implementation

end.
