unit FormUtl;{v0.60}
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  TypInfo, PropUtl, WinUtl;

procedure ObjectToForm(AObject: TObject; AForm: TForm);
  { Copy values of published properties of AObject to those input controls
    of AForm that has Name property that starts with the name of some
    AObject's property (case sensitive), and follows with underscore
    (or nothing). AObject's property names should not contain uderscore. }

procedure FormToObject(AForm: TForm; AObject: TObject);
  { Does the oposite of the above }

implementation


procedure FormToObject(AForm: TForm; AObject: TObject);
var
  c: TObject;
  n: string;
  v: string;
  i: integer;
  j: integer;
  buffer: PChar;
  size: integer;
  pi: PPropInfo;

begin
  if (AForm = nil) or (AObject = nil) then
    exit;
  for i := 0 to AForm.ComponentCount - 1 do begin
    c := TObject(AForm.Components[i]);
    n := TComponent(c).Name;
    j := pos('_', n);
    if j > 0 then
      n := copy(n, 1, j - 1); {winutl}
    if not ClassGetPropInfo(AObject, n, pi) then
      continue;
    if c is TEdit then begin
      with c as TEdit do begin
        v := Text;
      end;
    end else if c is TComboBox then begin
      with c as TComboBox do begin
        v := Text;
      end;
    end else if c is TCheckBox then begin
      with c as TCheckBox do begin
        if Checked then
          v := 'True'
        else
          v := 'False';
      end;
    end else if c is TMemo then begin
      with c as TMemo do begin
        SelectAll;
        Size := SelLength + Lines.Count * 2 + 1;
        GetMem(Buffer, Size);
        try
          GetSelTextBuf(Buffer, Size);
          v := StrPas(Buffer);
        finally
          FreeMem(Buffer, Size);
        end;
      end;
    end else begin
      continue;
    end;
    ClassSetPropStr(AObject, pi, v);
  end;
end;


procedure ObjectToForm(AObject: TObject; AForm: TForm);
var
  c: TObject;
  n: shortstring;
  v: string;
  i: integer;
  j: integer;
  buffer: PChar;
  size: integer;
  pi: PPropInfo;

begin
  if (AForm = nil) or (AObject = nil) then
    exit;
  for i := 0 to AForm.ComponentCount - 1 do begin
    c := TObject(AForm.Components[i]);
    n := TComponent(c).Name;
    j := pos('_', n);
    if j > 0 then
      n := copy(n, 1, j - 1); {winutl}
    if not ClassGetPropInfo(AObject, n, pi) then
      continue;
    v := ClassGetPropStr(AObject, pi);
    if c is TEdit then begin
      with c as TEdit do begin
        Text := v;
      end;
    end else if c is TComboBox then begin
      with c as TComboBox do begin
        Text := v;
      end;
    end else if c is TCheckBox then begin
      with c as TCheckBox do begin
        Checked := (v = 'True');
      end;
    end else if c is TMemo then begin
      with c as TMemo do begin
        Lines.Clear;
        SelText := v;
      end;
    end else begin
      continue;
    end;
  end;
end;


end.
