unit gwportio;
{-----------------------------------------------
Functions for accessing I/O Ports with Delphi 2 and 3.
These work as-is under Win95 (and presumably Win98).

However, use of I/O instructions by "user-mode" applications
under NT is blocked by by the IO Permissions mechanism.
To get around that, use gwiopm unit etc.

Revisions
----------
98-05-23 GW original

------------------------------------------------}
interface
uses windows, winsvc;

//-----------------------------------
// lowest-complexity I/O port functions
//-----------------------------------

function  PortIn(  PortNum: word)  : byte;
procedure PortOut( PortNum: word; a: byte);

function  PortInW( PortNum: word)  : word;
procedure PortOutW(PortNum: word; a: word);

function  PortInL( PortNum: word)  : longint;
procedure PortOutL(PortNum: word; a: longint);

//-------------------------------------------
implementation
//-------------------------------------------

//-----------------------------------------
function  PortIn( PortNum: word): byte;
//-----------------------------------------
Var a : byte;
Begin
  asm
    mov DX, PortNum;
    in  AL, DX;
    mov a, AL;
  end; {asm}
  PortIn := a;
end;

//-----------------------------------------
procedure PortOut( PortNum: word; a: byte);
//-----------------------------------------
Begin
  asm
    mov DX, PortNum;
    mov AL, a;
    out DX, AL;
  end; {asm}
end;

//-----------------------------------------
function  PortInW( PortNum: word): word;
//-----------------------------------------
Var a : word;
Begin
  asm
    mov DX, PortNum;
    in  AX, DX;
    mov a, AX;
  end; {asm}
  PortInW := a;
end;

//-----------------------------------------
procedure PortOutW( PortNum: word; a: word);
//-----------------------------------------
Begin
  asm
    mov DX, PortNum;
    mov AX, a;
    out DX, AX;
  end; {asm}
end;

//-----------------------------------------
function  PortInL( PortNum: word): longint;
//-----------------------------------------
Var a : longint;
Begin
  asm
    mov DX, PortNum;
    in  EAX, DX;
    mov a, EAX;
  end; {asm}
  PortInL := a;
end;

//-----------------------------------------
procedure PortOutL( PortNum: word; a: longint);
//-----------------------------------------
Begin
  asm
    mov DX, PortNum;
    mov EAX, a;
    out DX, EAX;
  end; {asm}
end;

end.

