unit dbtype;
{$I define.pas}
interface
uses
  dbftype, dpmitype, mytype{v1.15}, logtype{/v1.15};

const
  DBDLL = 'DB';
  DBSectionName = '[DB]';

{vrec.psl}
const
  MaxVariableRecLength = $FFF0;

{/vrec.psl}

{Tbl properties}

{tpXXXX}

  tpActive = 1;
  { Parametr pro funkci GetPropInt. Je soubor oteven? }
  tpAutoCalcFields = 2; {should call DoOnCalcFields method?}
  tpBOF = 3; {is at beggining of file? (after call to Prior if on first,
    or if has zero records (delphi also after call to First and after Open)}
  tpCanModify = 4; {can modify data in table? (runtime value), see also tpReadOnly}
  tpDatabase = 5; {to what database this table belongs}
  tpDatabaseName = 6; {directory to the database set of files}
  tpDBHandle = 7; {handle to underlying db interface, i.g. file handle
    or handle to bde engine}
  tpDBLocale = 8; {dont use}
  tpEOF = 9; {after call to Next if on last record; if opened empty table}
  tpFieldCount = 10; {number of fields in table}
  tpExclusive = 11; {in network, exclusive access; can change only in not Active state}
  tpFieldDefs = 12; {pointer to fields definitions table}
  tpFields = 13; {pointer to fields table (array)}
  tpHandle = 14; {dont use - HDBICur}
  tpIndexDefs = 15; {Pointer to table of index definitions}

  tpIndexFieldCount = 16; {pocet poli pouzivanych pro aktualni index (0 if not active}
  tpIndexFieldNames = 17; {string of human readable fieldnames separated by ';'}
  tpIndexName = 18; {selected secondary index name; if not assigned primary
    index is used (or none)}
  tpIndexFields = 19; {table of fields contained in current index; accessible
    only in Active state}
  tpKeyExclusive = 20; {boolean; false by default i.e. filter set by
    SetRangeStart and SetRangeEnd includes key limit; if true,
    then the filter applies to records with less or greater value than
    specified field limits}
  tpKeyFieldCount = 21; {specifies number of key fields to use with search
    functions GotoKey, FindKey, EditKey (if not all index fields should be
    used (i.e. index value consits of more field values)}
  tpLocale = 22; {pointer to language driver}
  tpMasterFields = 23; {list of Master tbl linked field names separated by ';',
    if those fields change in Master tbl, corresp values wil be located in
    detail tbl (index value)}
  tpMasterSource = 24; {pointer to MasterSource(has info about Master Table)}

  tpModified = 25; {is current record modified? cleared by call to Cancel or Post}
  tpName = 26;  {component name (not the file name)}
  tpReadOnly = 27; {if true prevents user from changing tbl; can be changed
                    only in not Active state}
  tpOwner = 28; {pointer to components owner}
  tpRecordCount = 29;
    { number of records in table (if range filter in effect,
      then number of filtered records) }
  tpDataSetState = 30; {see Data Set State constants}
  tpTableName = 31; {filename (without dir) of data file}
  tpTableType = 32; {format of data file}
  tpTag = 33;       {longint with on meaing for Tbl; available for user}
  tpUpdateMode = 34; {how to update displaed data in multiuser environg see below}


  tpEditRangeStart = 40;{set RangeStartRecord as the record to be accessed by
                         GetXXX/SetXXX methods (leaves the current value of
                         RangeStartRecord unchanged);
                         DataSetState changes to tsSetKey}
  tpSetRangeStart = 41; {as above, but clears RangeStartRecord}
  tpEditRangeStop = 42; {set RangeStopRecord as the record to be accessed by
                         GetXXX/SetXXX methods (leaves the current value of
                         RangeStopRecord unchanged);
                         DataSetState changes to tsSetKey}
  tpSetRangeStop = 43;  {as above but Clears RangeStopRecord}

  tpRangeApplied  = 44; { get info if range filter set, see tdApplyRange }
  tpDisableControls = 47; {disconects eventually connected visual controls
                           until the call to SetProp(tpEnableControls);
                           useful if browsing tbl heavily, and visual
                           controls do not have to be updated}
  tpEnableControls = 48;  {connects again the visual controls}

  tpEdit           = 49;  {call SetPropInt(tpEdit, @true/@false) sets
                           tbl to tsEdit/tsBrowsw state (if succ.)
                           and CanModify will be true}

{   tpSetKey        = 50;  {sets KeyRecord as the active CurRecord
                           and clears it (keyRecord values used when
                           SetPropInt(tpGotoKey) is issued}
{   tpEditKey       = 51;  {as above but does not change the KeyRecord value}

{   tpGotoKey      = 52;   {positions currec to that that equals to KeyRecord}

   {tpFindKey       = 54;  {SetKey(or EditKey) and GotoKey in one call to SetProp
                           with AValue=@string; if exact match not found
                           currec position in the table wont be changed}

   tpEmptyTable   = 53;   {zap(must be exclusive) or check if empty}

   {tpFindNearest   = 55;  {as tpFindKey, but always reposition to
                           the nearest match (KeyExclusive prop. defines
                           it to position onto or after the matching rec.)}
   tpFieldNames    = 56;  {get list of fieldnames (stringlist/collection)}
   tpIndexNames    = 57;  {get list of indexnames}
   tpGotoCurrent   = 58;  {SetProp, AValue = ATbl, synchronises RecNumbers to
                           ATbl recnumber}
   {tpIndexFields   = 59;  {get array of index expression creating fields}
   tpUpdateRecord  = 60;  {notifies visual controls to put edit values to currec
                           does not Post currec}

{MY}
  tpBrowseLine = 100;
  tpBrowseHeader = 101;
  {tpUseDefBrowseLine = 101;{ use to switch on/off using default browse
    line; set off if you defined OnGetBrowseLine handler }
  tpLastResult = 102;
  tpLastError = 103;
  tpRecordNr = 105;{current record number}
  tpIndexNr = 106; {currently selected index number (CurKeyNr)}
  tpIgnoreNextError = 107;
  { Pouv se jako paramter ve funkci TblSetPropInt.
    Ped volnm "njak funkce", kter obvykle v ppad, e se neukon
    korektn, hls chybu uivateli, lze zavolat TblSetPropInt(Tbl
    ,tpIgnoreNextError, 1), aby se  hlen potlailo.
    Pak je nutno volat TblSetPropInt(Tbl, tpIgnoreNextError, 0),
    jinak bude potlaeno hlen chyb navdy. }
  tpDDFBrowse = 108; {get DDF for browse window}
  tpDDFEdit = 109;   {get DDF for edit window}
  tpBrowsing = 110;  {is the Tbl beeing used in DBBrow window?}
  tpRecordSelected = 111;
  { Parameter pro funkce TblGetPropInt a TblSetPropInt,
    Funkc TblSetPropInt(Tbl, tpRecordSelected, 1) je aktuln zznam
     oznaen jako "vybran" pro ppadn nsledujc akce, funkc
     TblSetPropInt(Tbl, tpRecordSelected, 0) se vybrn zru.
    Pokud zznam databze nem definovno pole s nzvem SELECTED,
    lze takto vybrat pouze max. 16000 zznam.
    Viz tpSelectedRecordCount }

  tpIsValidRecord = 112;
  tpHasActiveRecords = 113;
  tpRecordEnabled = 114; {currecord accessible by user?}
  tpAlias = 116;
  tpBaseAlias = 117;
  tpFileName = 118;   {full path, name and ext}
  {tpErrorProc = 119;  {assign pointer to error message proc of type procedure(msg:string)}


  {128: up to tpxxxFieldxxx + 128 no other properties!!!; used
   with TblGetPropStr(tpxxxFieldxxx + FieldNr)}
  tpFieldName = 200;
  tpFieldType = 329;
  tpFieldLen = 458;
  tpFieldDec = 587;
  tpBrowseFieldValue = 720;

  {/128}

  tpEventsHandler = 900;
  {reserve up to tpEventsHandler + MaxTblEventIDCount, i.e. 924, for now
   see teXXXX}
  tpTagName = 950;
  {reserve up to tpTagName + BTMaxNrOfKeys (=100) for all possible tags,
   tpTagName + 1 for 1st tag,..; returns name of given tag}
  tpTagCaption = 1050;
  {reserve up to 1150..; human readable names of the tag[1]..tag[indexcount];
  use GetPropStr(tpTagCaption + indexnr) to retrieve it}

  {following extended field properties - reserved 128 tpXXXX values
    for each field one}
  tpFieldCaption = 1151;
  tpFieldHint = 1280;
  tpFieldPicture = 1409;
  tpFieldDefValue = 1538;
  tpFieldAllowedValues = 1667;
  tpFieldAutoInc = 1796;
  tpFieldRequired = 1925;
  tpFieldStyle = 2054;
  tpFieldListSource = 2183;
  tpFieldKeyField = 2312;
  tpFieldListField = 2441;
  tpFieldHelpCtx = 2570;
  tpFieldEnabled = 2699;
  tpFieldVisible = 2828;
  tpFieldMinLen = 2957;
  tpFieldListAlias = 3086;
  tpFieldColWidth = 3215;{max(fieldlen,length(fieldname)}

  tpIndexCount = 4000;
  { Poet index v databzi }

  tpTimeType = 4001;
  { Druh databze v souvislosti s asem, viz pnTimeType
   normal (dsNormal), range (dsRange, kad zznam obsahuje pole
   VALIDFROM a VALIDTO), month (dsMonth, cel soubor se tk jednoho
   msce, je je obsaen v nzvu souboru) }

  tpDetailAlias = 4002;
  { Jmno souboru (basealias), je m podrobn rozpis zznam,
    je-li njak. }
  tpMasterAlias = 4003;
  { Jmno souboru (basealias), je obsahuje jmna psluejc
    ID zznam, je-li njak }
  tpCaption = 4004;
  tpHint = 4005;
  tpDetailRecCount = 4006;
  { Kolik zznam se m vytvoit v databzi detail pnDetailAlias
    pro jeden nov zznam v tto databzi }
  tpTempFileName = 4007;
  { Vrac jmno doasnho souboru pouvanho pro tuto databzi }
  tpCurRecordPtr = 4008;
  { Parametr pro TblGetPropInt - vrac ukazatel na buffer obsahujc
    kopii aktulnho zznamu (nebo Key bufferu); pro TblSetPropInt
    zkopruje do bufferu  pro aktuln zznam data z bufferu, ukazatel
    na nj je parametr Value tto funkce. Viz take tpCurRec }
  tpDetailTbl = 4009;
  { Parametr k zskn ukazatele na otevenou databzi s detaily
    (tj. zznamy pro rzn obdob a pro jednotliv SubID)
    pro aktuln master databzi pomoc funkce GetPropInt}
  tpEditNewDateRange = 4010;
  { Poadavek vytvoit v Details doasn soubor pro nov obdob,
    ponajc datem, ukazatel na nj je posledn parametr (DT:PDTO) funkce
    TblSetPropInt(Tbl, tpEditNewDateRange, DT);
    Zznamy v doasn databzi je pak mono editovat run nebo
    zmnit programov, a zmny potvrdit volnm TblPost(Tbl) }
  {Viz tpDetailTbl, tpTempDetailTbl}
  tpTempDetailTbl = 4011;
  { Parametr k zskn ukazatele na otevenou doasnou databzi s detaily
    pro aktuln databzi pomoc funkce GetPropInt }
  {Viz tpDetailTbl}
  tpDetailEditMode = 4012;
  { Vrac stav detail databaze, tj. jsou-li v doasn databzi
    modifikovan, nebo nov vytven zznamy, mon hodnoty jsou:
    emBrowse, emAppend, emEdit, emEditNewDateRange }
  tpCurRangeDate = 4013;
  { Parametr pro funkce TblGetPropInt, TblSetPropInt k nastaveni
    aktualniho data pro details databazi;
    TblGetPropInt vraci ukazatel na inicializovany PDTO - nemenit;
    TblSetPropInt musi pouzit inicializovany PDTO nastaveny na
    zadanou hodnotu (viz tpDate) }
  tpDetailsChanged = 4014;
  { Parametr pro TblGetPropInt - vrac 1, pokud se databze detail
    njak zmnila, nebo byl nastaven pznak funkc TblSetPropInt
    (docl se tak pekreslen detail pi browse); volnm TblGetPropInt
    se pznak vynuluje, prv tak jako pi pekreslen }
  tpNextErrorToIgnore = 4015;
  { Parametr pro TblSetPropInt, nastav se kd chyby, kter se
    m ignorovat pi jejm ptm vskytu (tj. neohls se uivateli)}
  tpSelectedRecordCount = 4016;
  { Parametr pro TblGetPropInt, vrac poet prv vybranch zznam.
    Maximln poet vybratelnch zznam u databz, kter nemaj
    definovno pole SELECTED je 16000.
    Viz tpRecordSelected }
  tpDetailsConnected = 4017;
  { Parametr pro TblGetPropInt, TblSetPropInt. Slou k odpojen
    a pipojen databze detail za chodu programu, kdy detaily jsou
    ji oteveny, ale je teba modifikovat pouze zznam master
    databze. Normln se pi zavoln funkce TblSetPropInt(Tbl, tpEdit, 1)
    nebo TblAppend  vytvo doasn databze detail, jej obsah
    se pi TblPost zkopruje nebo pid k databzi detail.
    Pokud tomu chceme zabrnit, zavol se ped nap. TblAppend
    funkce TblSetPropInt(MasterTbl, tpDetailsConnected, 0),
    dle se provedou pravy master zznamu, zavol se TblPost a pak
    se znovu aktivuj detaily funkc
    TblSetPropInt(MasterTbl, tpDetailsConnected, 1).}
  tpIndexType = 4018;
  { Parametr pro TblGetPropInt, vrac typ aktulnho indexu, tj.
    obvykle bu ord('N') nebo ord('C'), hodnota definovan
    vlastnost cnTag.pnType }
  tpIndexLen = 4019;
  { Parametr pro TblGetPropInt, vrac dlku klov hodnoty aktulnho
    indexu }
  tpDataCopies = 4020;
  { Vrac rkou oddlovan seznam nzv databz, je maj bt
    pesn kopie tto databze, tj. updatuj se po kadm append
    delete, pack, index.. NEPOUZIVAT}
  tpViewProcName = 4021;
  { Jmno defaultn viewproc procedury pro Browser window }
  tpPopupFields = 4022;
  { Vrac mezerou oddlovan seznam pol databze, kter se
    maj objevovat pi browse pro editan dek jin databze,
    viz pnPopupFields }
  tpMenuMask = 4023;
  { Vrac mezerou oddlovan seznam standardnch nzv poloek
    menu, je maj bt ptomny v loklnm menu browse okna
    viz ddftype.pnMenuMask }
  tpStatusLineMask = 4024;
  { Vrac mezerou oddlovan seznam standardnch nzv poloek
    menu, je maj bt ptomny ve stavovm dku pi aktivace
    browse okna viz ddftype.pnMenuMask }
  tpEditViewProc = 4025;
  { Vrac jmno viewproc procedury pro okno k editaci aktulnho
    zznamu }
  tpCurKey = 4026;
  { Vrac indexovou hodnotu aktuln zznamu }
  tpTempTbl = 4027;
  { Vrac pointer na doasn soubor, kter obsahuje kopii aktuln
    vyfiltrovanch zznam (byl-li vytvoen, tj. v prbhu BrowEdit,
    jinak vrac nil) }
  tpBrowseEditViewProc = 4028;
  { Vrac jmno ViewProc procedury pro BrowseEdit okno }
  tpHeadHeight = 4029;
  { (integer) Vrac kolik dek m mt nadpis sloupc v browse oknu (default=1)}
  tpColumnSpaces = 4030;
  { (integer) Vrac kolik mezer m bt mezi sloupci v browse oknu (default=1)}
  tpSubIDFieldName = 4031;
  { (string) Vrac ppadn jmno pole, kter je zahrnuto v indexovm
    vrazu pro platnost od-do (krom ID, VALIDTO) }
  tpDDFBrowseEdit = 4032;
  { (pointer) Vrac DDF, kter bude pouito k vytvoen BrowseEdit okna }
  tpDDFEditDetails = 4033;
  { (pointer) Vrac DDF, kter bude pouito k vytvoen EditDetails okna }
  tpDateRangeTitle = 4034;
  { Vrac nadpis pro browse okno s asov zvislmi zznamy
    (obsahuj ValidFrom a ValidTo fields }
  tpValidFromFieldNr = 4035;
  { Vrac slo pole VALIDFROM, nebo 0, nen-li takov pole v zznamu }
  tpValidToFieldNr = 4036;
  { Vrac slo pole VALIDTO, nebo 0, nen-li takov pole v zznamu }
  tpSubIDFieldNr = 4037;
  { Vrac slo pole, kter je soust indexu asov zvislch zznam,
    kter nen hlavnm ID zznamu ale je uniktn v rmci danho
    hlavnho ID a danho asovho intervalu; Vrac 0, nen-li takov
    pole definovno (viz tpSubIDFieldName) }
  tpFilter = 4038;
  { TblSetPropStr, TblGetPropStr - vrac/nastav filtr pro platn
    zznamy, kter se bere v vahu pi pkazech pro pohyb po zznamech.
    Value = '' zru filtr}
  tpRecordDeleted = 4039;
  { For DBF tables }
  tpAutoPost = 4040;
  { Lze pout ke zruen/obnoven automatickho uchovn zmn pol
    v zznamech pi zmn zznamu (ohls chybu pokud byl zznam zmnn
    a nebyl explicitn Posted or Canceled - trAutoPostDisabled).
    - TblSetPropInt(Tbl, tpAutoPost, 0) }
  tpTempSelFileName = 4041;
  { TblGetPropStr vrac jmno doasnho souboru pouvanho pro
    editaci zznamu pro zmny do vech vybranch zznam }
  tpFieldCanChangeInBatch = 4042; { .. 4170 }
  { TblGetPropInt (tpFieldCanChangeInBatch + FieldNr) vrac
    1, kdy lze pole mnit hromadn (tj. nap pi spolen editaci
    vybranch zznam) }
  {tp....               = 4180}
  tpTblTableIndex = 4181;
  { Index of the Tbl in collection of opened tables }
  tpNetBufferWriteThrough = 4182;
  { If On Causes flushing Isam buffers to disk upon every BTxxxx
    call exit (only if in ooSave mode and network is On }
  tpEditDetailsAfterAppend = 4183;
  { Should the dbbrow.EditDetails procedure be called after confirming
    new record to master table? (default yes, can be changed) }
  tpEditDetailsAfterEdit = 4184;
  { Should the dbbrow.EditDetails procedure be called after editing
    existing record in master table? (default no, can be changed);
    if set yes, also TblEditDetails is called during TblEdit }
  tpCreateDetailsAfterAppend = 4185;
  { Should the details record be automatically created during
    appending new master record in TblAppend? (i.e. in TempDetailsTbl
    initialized and some records appened?)
    default yes (only for tables having masters of course) }
  tpRecordSize = 4186;
  tpEditRecordAfterAppend = 4187;
  { Should the newly created record of master table be manually
    edited in DBBrowseWindow.NewRecord? (default true)
    Can be changed e.g. during cmBeforeExecute or cmBeforeBrowseOpen
    message }
  tpCalcFieldsAlways = 4188;
  { if true, then CalcFields is called (updates relations) upon every
    record load, even if record nr. did not changed }
  tpDate = 4189;
  { Access DataVar DB variable value named Alias + 'DATE', assigned
    to every opened table; initially set to NOW;
    TblSetPropInt(tbl, tpDate, DT:PDTO) sets this var to value in
    DT, TblGetPropInt(tbl, tpDate) returns table's Date:PDTO,
    variable synchronized with DataVar (don't change returned pointer
    using DTxxx methods!!) }
  tpTblState = 4190;
  { tsInactive, tsBrowse, tsInsert, tsEdit,... (see tsXXXX)}
  tpGetEvenLockedRecs = 4191;
  { False by default, i.e. every call to TblGetRec will read the record
    from the file if unlocked, otherwise reports error.
    If true, then the record is not beeing checked for locks (faster).
    Use TblGetPropInt/TblSetPropInt to get its value/change it }
  tpUseDBuf = 4192;
  { Use memory buffer for repetitively retrieved records? (for interactive
    browsing only or in non-network environment); false by default }
  tpBTIsamErrorClass = 4193;
  tpNotFoundSearchDirection = 4194;
   { Where to go if wanted record not found: sdNone = 0 - nowhere,
     sdPrev = -1 - back, sdNext = 1 - forward }
  tpIsamFileBlockPtr = 4195;
   { TblGetPropInt returns pointer IsamFileBlockPtr (if opened, otherwise
     nil }
  tpCurRec = 4196;
   { TblGetPropInt returns pointer to current record data }
  tpBBrowser = 4197;
  { handle to BTBrow  associated with this tbl (if any)
    Call to BBInit will assign this field of ATbl with created browser }
  tpDetailsTimeType = 4198;
  { returns time type of details tbl (if any). dsNormal returned
    if no detals opened (see tpTimeType) }
  tpRangeStartKey = 4199;
  { returns start key value for current applied range (if any) }
  tpRangeStopKey = 4200;
  { returns stop key value for current applied range (if any) }
  tpNextOpenTblIsMonth = 4201;
    { use TblSetPropInt(NoTbl, tpNextOpenTblIsMonth to force
      next TblInit call to have ooMonth openoption set, i.e.
      filename will be set according to MONTH db variable }
  {v1.10}
  tpRecoverAllDatFiles = 4202;
    { use TblSetPropInt(NoTbl, tpRecoverAllDatFiles, 1) to force
      all Tbls that will be opened after this moment (and were
      not reindexed yet since program start) to get reindexed
      (recovered) }
  {/v1.10}
  {v1.12}
  tpDetailPeriodStartDate = 4203;
    { Current Details table record validfrom date, use PDTO(TblGetPropInt(Tbl,..)) }
  tpDetailPeriodStopDate = 4204;
    { Current Details table record validto date, use PDTO(TblGetPropInt(Tbl,..))  }
  {/v1.12}
  {v1.15}
  tpDetailFileName = 4205;
    { Returns base file name of data file that should be opened as
      details file if DetailsInit is called }
  tpScanOptions = 4206;
    { GetPropInt Returns Pointer to current TblScanOptions (non nil
      just during TblScan call, i.e. usable from CallBack function) }
  {/v1.15}
  {v1.16}
  tpHelpCtx = 4207;
    { GetPropInt returns helpctx value for the tbl }
  {/v1.16}

 {properties not of one table:}
  tpOpenTblCount = 5000;
  tpDataDir = 5001;
  tpTempDir = 5002;
  tpTablesInitHandler = 5003;
  { Pouijte TblSetPropInt(tpTablesInitHandler, @SomeHandler:TTblEventHandler) k registraci
    procedury SomeHandler, kter bude zavolna na konci kadho voln
    funkce TblInit, kter je spn. Lze pout k nastaven
    specilnch handler pro otevenou databzi. }
{/MY}
{/tpXXXX} { check smodtype tpXXXX section for eventual equal names
  that could cause confusion }
{/Tbl properties}

const
{tdXXXX Tbl Do constants}
  tdReindex = 1;
    { Reindex the table }
  tdPack = 2;
    { Pack the table }
  tdTruncate = 3;
    { Truncate the table }
  tdDelete = 4;
    { Delete current record in the table }
  tdZap = 5;
    { Delete all records of the table }
  tdCheckRecord = 6;
    { Check if current records is valid, returns <> 0 if not }
  tdSetRelation = 7;
    { Using DDF = Info}
  tdRemoveSlave = 8;
    { From Slaves collection, Info is pointer to the slave }
  tdBrowseEdit = 9;
    { init TempTbl and copy active records to temptbl that is going
      to be browsed-edited}
  tdBrowsePost = 10; {copy records from temptbl back to this table}
  tdBrowseCancel = 11; {cancel changes in temptbl, dont copy them back to
                        this table, dispose temptbl}
  tdNextDateRange = 12; {change currangedate to next available in details}
  tdPrevDateRange = 13; {change currangedate to previous available in details}
  tdClearRecord = 14;
    { Calls SetStr(i, '') for all fields. Must be in tsEdit, tsInsert
      or tsSetKey state Fillchar(RecPtr^, 0) (= tpClearFields; was)}
  tdSelectRecords = 15; { AInfo = srXXXX see below }
  tdApplyRange = 16;
    { Sets range filter to Tbl, so that only records with
      index values >= RangeStartRecord and <= RangeStopRecord
      are accessible (see also tpKeyExclusive);
      cancels DataSetState=tsSetKey, sets tsEdit}
  tdCancelRange = 17;

  tdSetKey         = 18;
    { Sets KeyRecord as the active CurRecord and clears it
      (KeyRecord values used when TblDo(tdGotoKey) or
       tdFindKey, tdFindNearestKey is issued). TblPost
      must be called after changing the fields of KeyRecord
      using TblSetXXX methods }
  tdEditKey        = 19;
    { As above but does not change the current KeyRecord value }
  {tdGotoKey        = 20;
    { Positions currec to that that's current index key value equals
      to key value of KeyRecord }
  {tpFindKey       = 21;
    { SetKey(or EditKey) and GotoKey in one call to SetProp}
  tdFindNearestKey = 22;
    { Calls Tbl^.FindNearestKey, using Key value set previously
      by tdSetKey or tdEditKey }

  tdCloseAll = 25;
  tdSetDefaultTbl = 26;
    { TblDo(ATbl, tdSetDefaultTbl) cause ATbl to be Tables^.DefaultTbl;
      or TblDo(NoTbl, tdSetDefaultTbl, ATbl) can be used (useful
      if ATbl = NoTbl) }
  tdLocate = 27;
    { Use TblDo(ATbl, tdLocate, PString(dbfexpression)) to locate first
      record from the First that matches the expression }
  tdContinueLocate = 28;
    { Use TblDo(ATbl, tdContinueLocate, nil) to continue in searching
      of next record that matches the expression used in previous
      TblDo(ATbl, tdLocate) call }
  tdFindSameFileTbl = 29;
    { Use TblDo(ATbl, tdFindSameFileTbl, @t) to find other tbl, that
      has opened the same file as ATbl. Returns trOK if found otherwise
      trSameFileTblNotFound }
  tdFlush = 30;
    { Flush opened Tbl to disk }
  tdFlushDetails = 31;
    { Flush opened DetailTbl to disk }
  tdCheckDateInRange = 32;
    { Returns trOK only if Tbl is range tbl (has VALIDFROM, VALIDTO fields),
      and record is loaded and the record is valid for date submited
      as Info (i.e. Info = PDTO) }
  tdDetailsOpen = 33;
    { Returns trOK only if tbl has defined details table and the table
      was opened successfully }
  tdDetailsClose = 34;
    { Returns trOK only if tbl has defined details table and the table
       was opened and was closed successfuly by this call }
  tdCalcFields = 35;
    { Update relations and recalculated exp. fields }
  tdCheckCalcFields = 36;
    { Updates relations if necessary }
  tdReloadRecord = 37;
    { Cancels any changes made in CurRec buffer and reloads currec
      buffer from disk (call in the case some other process could
      have change the record content) }
  {v1.05}
  tdCheckAborted = 38;
    { call at program start, if lockfile found all indexes will
      be deleted }
  tdSetRelationInto = 39;
    { using @TRelationRec as info }
  {/v1.05}
  {v1.07}
  tdDoneSCol = 40;
    { dispose storage for strings created by NewStr }
  {/v1.07}
  {v1.14}
  tdFreeUnusedDLLs = 41;
    { Can be called to free all dat DLLs that are not in use
      by any Tbl. Called during program shutdown. }
  tdIsamInit = 42;
    { initialze BTFiler library, no need to call it directly,
      done automatically upon firts TblInit call. }
  tdIsamDone = 43;
    { deinitialize BTFiler library, should not be called normally!! }
  tdDBExpLogInit = 44;
    { init logging of DBExp progress - evaluation of DB expression,
      should be set on only for debugging }
  tdDBExpLogDone = 45;

  {/v1.14}
  {v1.15}
  tdCopyFieldToDetails = 46;
    { Use TblDo(t, tdCopyMasterFieldToDetails, @TCopyFieldInfo) to
      copy field value of current record of the master tbl T to its
      currently opened details table records with the same ID.
      Field name of the field, eventually from which date it should be
      copied must be specified in TCopyFieldInfo structure.}
  {/v1.15}
  {v1.18}
  tdIndexUpdateSuspend = 47;
    { suspend updating of index(es) (i.e. modify rec or add rec will not
      udpate the index) }
  tdIndexUpdateResume = 48;
    { if indexes updating was suspended it will be resumed again, if some
      index update was requested during suspend, Reindex will be called }
  {/v1.18}
{/tdXXX}
const
{Table State constants:}
{tsXXXX}
  tsInactive = 1; {when the dataset is closed}
  tsBrowse = 2;   {when the dataset is in Browse state (Active)}
  tsEdit = 3;     {when the dataset is in Edit state (connected visual controls)}
  tsInsert = 4;   {when the dataset is in Insert (append) state}
  tsSetKey = 5;   {when the dataset is in SetKey state}
  tsCalcFields = 6; {when the OnCalcFields event is called.}
{/tsXXXX}

{Table types:}
{ttXXXX}
  ttASCII = 0;
  ttDBase = 1;
  ttParadox = 2;
  ttBTFiler = 3;
{/ttXXXX}

{Update modes: (for SQL queries)}
  umWhereAll = 0; {default}
  umWhereKeyOnly = 1;
  umWhereChanged = 2;

{MY}

{BTFiler constants}
const
  BTMaxKeyLen = 40; { synchronize with filer.cfg MaxKeyLen }
  BTMaxNrOfKeys = 100; { -"- }
  MaxRecordSize = 255;

  BTMaxNrOfFields = 128;{my limit}
  BTDataExt = '.DAT';
  BTIndexExt = '.IX';
  BTDialogExt = '.DIA';
{/BTFiler constants}
  TblLckExt = '.LCT';{table lockfile extension}


{Tbl Handler Results}
  hrOK = 0;
  hrFailed = 1;

{Tbl Results}
{trXXXX}
  trOK = 0;

  tr0 = 1000;

  {trInvalidFieldNo = tr0 + 1;}
  trInvalidNumericFormat = tr0 + 2;
  trInvalidBTFieldType = tr0 + 3;
  trInvalidTblHandle = tr0 + 4;
  trInitFailed  = tr0 + 5;
  trCreateTblFileFailed = tr0 + 6;
  trOpenFileBlockFailed = tr0 + 7;
  trCloseDisabledByHandler = tr0 + 8;
  trFileNotOpen = tr0 + 9;
  { Tato chyba je ohlena, pokud byla volna njak funkce,
    kter vyaduje, aby byl oteven datov soubor, ale ten
    je uzaven. }
  trEOF = tr0 + 10;
  { Tento vsledek je nastaven, pokud posledn funkce zpsobila
    nastaven ukazatele zznamu za konec souboru. }
  trBOF = tr0 + 11;{... beggining of the table}
  trAlreadyOpened = tr0 + 12; {trying to open file that is already opened}
  trOpenDisabledByHandler = tr0 + 13;
  trNoIndexSelected = tr0 + 14; {if trying to Find and CurKeyNr = 0}
  trNoRecLoaded = tr0 + 15; {method was called that requires valid record
                           be loaded (i.e. CurRecNr = 0)}
  trInvalidFieldNr = tr0 + 16;    {invalid field number used in GetXXX or SetXXX}
  trInvalidDoID = tr0 + 17;
  trGetRecFailed = tr0 + 18; {should not happend, record was already locked ok before}
  trAlreadyDeleted = tr0 + 19; {trying to delete already deleted record}
  trDeletedRecChangedByOthers = tr0 + 20;{trying to delete record that changed
    inbetween}
  trKeyAlreadyDeleted = tr0 + 21;
  trOOM = tr0 + 22;{out of memory}
  trInvalidFieldName = tr0 + 23;

  trEmptyBaseAlias = tr0 + 25;
  trDLLNotFound = tr0 + 26;
  trTblDefTableFull = tr0 + 27;
  trDLLLoadFailed = tr0 + 28;
  trDLLAssignProcFailed = tr0 + 29;
  trTblCountZero = tr0 + 30;
  trOpenedTblOnExit = tr0 + 31;

  trInvalidGetPropInt = tr0 + 50;
  trInvalidGetPropStr = tr0 + 51;
  trInvalidGetProp = tr0 + 52;
  trInvalidSetProp = tr0 + 53;
  trInvalidSetPropStr = tr0 + 54;
  trInvalidSetPropInt = tr0 + 55;

  trInvalidKeyNr = tr0 + 56;
  trInvalidCurTbl = tr0 + 58;{during reindex or pack must CurTbl be set}

  trTblError = tr0 + 100;{unspecified in table errors}
  {errors regarding more tables:}
  trNoTablesOpen = tr0 + 101;
  trAliasNotFound = tr0 + 102;

  trInvalidVarHandle = tr0 + 103;
  trInvalidVarSetPropInt = tr0 + 104;
  trInvalidVarSpace = tr0 + 105;
  trInvalidVarName = tr0 + 106;{var not found}
  trCheckRecordFailed = tr0 + 107;
  trCantSetEmptyAlias = tr0 + 108;
  trInvalidGotoRecNr = tr0 + 109; {invalid param to TblGoTo}
  trInvalidIndexName = tr0 + 110;
  trInitSlavesFailed = tr0 + 111;
  trInitRelMasterFailed = tr0 + 112;
  trSlaveRecordNotFound = tr0 + 113;
  trSlaveTblNotFound = tr0 + 114;
  trRelationAlreadySet = tr0 + 115;
  trInvalidSizeOfFldType = tr0 + 116;{in TTbl.GetStr}
  trLastInAppendFailed = tr0 + 117;
  trInitRelMasterEmptyExp = tr0 + 118;
  trBaseAliasNotFound = tr0 + 119;
  { Chyba v programu vytvoenm pro reln reim, nenalezena
    definice dan databze }
  trRangeApplyNoKeySelected = tr0 + 120;
  { Byla volna metoda ApplyRange, ale nen zvolen dn index. }
  trNoRangeRecords = tr0 + 121;
  { Nebyly nalezeny dn zznamy, kter by splovaly zadan rozsah
    hodnot kl. }
  trEORange = tr0 + 122;
  { Voln Next zpsobilo, e kl pro zznam je za definovan
    rozsah povolench kl }
  {Viz tpSetRangeStart, tpSetRangeStop}
  trBORange = tr0 + 123;
  { Voln Next zpsobilo, e kl pro zznam je ped definovan
    rozsah povolench kl }
  {Viz tpSetRangeStart, tpSetRangeStop}
  trCanNotModifyRec = tr0 + 124;
  { Byla volna funkce modifikujc zznam, ale databze nen
    ve stavu tsInsert (je po TblAppend(Tbl) ), tsEdit
    (je po SetPropInt(Tbl, tpEdit, 1) ), tsSetKey
    (je po TblSetPropInt(Tbl, tpSetRangeStart| tpEditRangeStart |
     tpSetRangeStop | tpEditRangeStop, 1)) a nebo je
    ReadOnly }
  trCantCreateDir = tr0 + 125;
  { Nelze vytvoit adres, zadan pomoc TblSetPropStr s parametry
    tpDataDir nebo tpTempDir }
  trDeleteDisabledByHandler = tr0 + 126;
  { Vymazn zznamu bylo znemonno uivatelskou procedurou }
  trTempTblNotOpen = tr0 + 127;
  { Pokus o pouziti docasneho souboru, ktery ale neni otevren }
  trInitTempTblFailed = tr0 + 128;
  { Pokus o oteven docasneho souboru selhal }
  trDifKeyValues = tr0 + 129;
  { Pri pokusu o kopirovani z docasneho souboru nalezeny
    rozdilne klicove hodnoty }
  trDifKeyValueRecordCount = tr0 + 130;
  { Pi pokusu o koprovn zznam z doasnho souboru,
    byl  zjitn vt poet zznam v doasnm souboru,
    ne je aktuln vyfiltrovno v tomto souboru }
  trDetailsNotOpen = tr0 + 131;
  { Pi pokusu provst pkaz s Details databz, kter nen otevena }
  trNoNextDateRange = tr0 + 132;
  { Pi pokusu o DetailsSwitchRangeDate(true), kdy nen dal obdob }
  trNoPrevDateRange = tr0 + 132;
  { Pi pokusu o DetailsSwitchRangeDate(false), kdy nen pedchoz obdob }
  trInvalidLocateParam = tr0 + 133;
  { Pi pokusu o TblDo(Tbl, tdLocate, AStringPtr) a AStringPtr je = nil }
  trEmptyLocateExp = tr0 + 134;
  { Pi pokusu o TblDo(Tbl, tdLocate, AStringPtr) a AStringPtr^ je = '' }
  trNoLocateExp = tr0 + 134;
  { Pi pokusu o TblDo(Tbl, tdContinueLocate, nil) a tdLocate nebylo
    pedtm volno (tj. LocateExp = '') }
  trLocateFailed = tr0 + 135;
  { Vsledek voln TblDo tdLocate nebo tdContinueLocate, kdy ji
    dn zznam neodpovd. Rovnا je vymazno LocateExp, take
    dal voln tdContinueLocate zpsob chybu trNoLocateExp  }
  trDateRangeExists = tr0 + 136;
  { Vsledek voln DetailsEditNewDateRange(DT), pokud obdbob
    zanajc datem DT ji existuje }
  trReadBeyondEOF = tr0 + 137;
  { Tried to read beyond EOF file (in DBF files) }
  trInvalidPropBufSize = tr0 + 138;
  { Invalid Buffer size for set/get property }
  trAutoPostDisabled = tr0 + 139;
  { Record was modified but not Posted or Canceled explicitely,
    AutoPost disabeled, and method for changing record or
    closing file was called = error }
  trInvalidSelRecsArg = tr0 + 140;
  { Invalid AInfo parameter to TblDo(Tbl, tdSelectRecords, AInfo) }
  trAliasInUse = tr0 + 141;
  { Triyng to set Tbl under alias that is already used }
  trSameFileTblNotFound = tr0 + 142;
  { Result of TblDo(ATbl, tdFindSameFileTbl, @t) if no such tbl
    found }
  trInvalidParameter = tr0 + 143;
  { Usually nil parameter where non nil expected }
  trRelMasterAlreadySet = tr0 + 144;
  { When trying to set more masters to one slave }
  trDateIsNotInRange = tr0 + 145;
  { When checking TblDo(Tbl, tdCheckDateInRange, ADTO:PDTO) and ADTO
    is not in ValidFrom ValidTo range }
  trNotRangeTbl = tr0 + 146;
  { When trying to call method that is allowed only for range tbls
    (those having ValidTo,ValidFrom fields); e.g. tdCheckDateInRange }
  trInvalidRelationType = tr0 + 147;
  { When trying update relation, invalid relation type encoutered
    (see rtXXXX) }
  trOpenedReadOnly = tr0 + 148;
  { When trying to call Append or Edit on Tbl that was opened
    using ooReadOnly option }
  trOddIgnoreNextError = tr0 + 149;
  { Call to TblSetPropInt(tbl, tpIgnoreNextError, 0) was not preceeded
    by call TblSetPropInt(tbl, tpIgnoreNextError, 1) }
  trDetailsAppendFailed = tr0 + 150;
  {v1.05}
  trTooManyTblDLLs = tr0 + 151;
  trReadOnlyFileNotFound = tr0 + 152;
    { TblInit with ooReadOnly options failed because the file was
      not found }
  {/v1.05}
  {v1.15}
  trCopyFieldToDetailsFailed = tr0 + 153;
  {/v1.15}
  {v1.16}
  trGetSelRecsInitFailed = tr0 + 154;
    { RecsInit call in TblGetSelRecs failed }
  trGetSelRecsAddFailed = tr0 + 155;
    { RecsAdd call in TblGetSelRecs failed }
  {/v1.16}
  {v1.19}
  trBTFindFailed = tr0 + 156;
    { BTFindKey returned OK but the Key of returned record is not
      the one that was searched for (BTFiler bug?) }
  {/v1.19}

    { found more DLLs in DATADEF directory than is maximal allowed number,
      DB must be recompiled }
  trHandlerFailed = tr0 + 1000;
  trHandlerBeforeCancelFailed = trHandlerFailed + 1;
  trHandlerBeforePostFailed = trHandlerFailed + 2;
  trHandlerBeforeInsertFailed = trHandlerFailed + 3;

  trclass = tr0 + 2000;
  {User-defined error classes (from bt example)}
  trSevereError = trclass + 20;
  trKeyError = trclass + 15;
  trDeletedError = trclass + 12;
  trModifiedError = trclass + 10;

{/trXXXX}

{Tbl Event IDs}
{teXXXX}
  MaxTblEventIDCount = 24;

  teAfterCancel = 0;
  teAfterClose = 1;
  teAfterDelete = 2;
  teAfterEdit = 3;
  teAfterInsert = 4;
  teAfterOpen = 5;
  teAfterPost = 6;
  teBeforeCancel = 7;
  teBeforeClose = 8;
  teBeforeDelete = 9;
  teBeforeEdit = 10;
  teBeforeInsert = 11;
  teBeforeOpen = 12;
  teBeforePost = 13;
  teOnCalcFields = 14;
  teOnNewRecord = 15;

  teOnGetFldVal = 16;
  teOnSetFldVal = 17;
  teOnGetFldJ = 18;
  teOnSetIndexName = 19;
  teOnGetIndexVal = 20;

  teOnGetBrowseLine = 21;
  teOnInit = 22;
  teOnDone = 23;

{/teXXXX}
  {increase MaxTblEventIDCount if new teXXXX added}

  MaxTblCount = 300;{max number of tables with own DLL}

{special parameters for TblXXXX calls:}
  NoTbl = nil;
  DefaultTbl = pointer(1);
  NoDataSet = nil;
{/special }

  NoRecNr = 0;
  NewRecNr = -5;

  {from ghwork33\dbftypes:}
  No_Record = 0;{not initialized record}
  New_Record = -5;{initialized not yet save new record}

  Next_Record = -1;
  Prev_Record = -2;
  Top_Record  = -3;
  Bottom_Record = -4;

  {used in dbbrow:}
  PageUp_Record = -6;
  PageDown_Record = -7;

  {}

{DB Var section constants}
  NoVar = nil;
  {DB Var spaces }
{vsXXXX}
  vsAll = 0;
  vsGlobal = 1;
  vsLocal = 2;
{/vsXXXX}

  {DB Var options}
  voConst = 0;     {value assigned to var is constant}
  voExpression = 1;{.. is expression that should get evaluated upon
                       every call to VarGetXXX}
  {expression type}
  etNumber = 0;
  etString = 1;
  etBool = 2;
  etUndef = 255;

{vtXXXX var type}
const
  vtConst = 0;
  vtMacro = 1;
  vtLabel = 2;
  vtExp = 3;
  vtExpExp = 4;
  vtSum = 5;
  vtCount = 6;
  vtAvg = 7;
  vtSet = 8;
  vtMin = 9;
  vtMax = 10;
  vtSetVar = 11;{sets vars.name to '' upon getline(0) in given set}
  vtSetExp = 12;{sets expandvalue of given Exp to given value upon
                 Getline(0) of owning set}
{/vtXXXX}
{dvXXXX common db variable names, to be used with VarNameSetVal,
  VarNameGetVal methods }
  dvMonth = 'MONTH';
  dvDate1 = 'DATE1';
  dvDate2 = 'DATE2';
{/vnXXXX}
{/DB Var section constants}
const
  DBEmptyDateStr = '';

type
  TTblTimeType = integer;
{dsXXXX DB style TimeType constants:} {dependence on time; see pnTimeType}
const
  dsNormal = 0;{no specific functions with the dbffile}
  {dsID = 1;{first field is unique numeric ID value}
  dsDateRange = 1;{see rangedbf unit}
  dsMonthly = 2; {see monthdbf unit}
  {dsGHDateRange = 4;{as 2, but ghwork specific}
  dsMonthLog = 3;
  dsMenuMonthly = 4;{either monthly file or non-monthly if opened
    with NoDate, or the file not found and not in CreatingMonthFile mode}
{/dsXXXX DB style}

{rtXXXX Relation type (see classdef)}
const
  rtNormal = 0;
  rtExact = 1;
  rtRange = 2;
  rtScan = 3; { not supported yet}
{/rtXXXX Relation type}

  MaxDefRecs = 100;
{ Maximln poet peddefinovatelnch zznam databze
  v rmci DDF pomoc objekt cnRecVal, cnFieldVal }

type
  TTblAlias = string[8];
  TDBStyle = integer;
{v1.05}
type {for use with tdSetRelationInto }
  TRelationType = byte;
  TRelationRec = record
    Slave:TTblAlias;
    Exp:string;
    rt:TRelationType;
  end;
  PRelationRec = ^TRelationRec;
{/v1.05}

{DB Var section}
  TExpType = byte;{see above etXXX constants}
  TVarType = byte;{see above vtXXX constatns}
  TDBVarName = string[10];{for varobju}
  TVarExp = string;
  PVar = pointer;
  TVarSpace = integer; {see vsXXXX constants (global, local, local+1,..)}
  TVarProperty = integer;

{/DB Var section}
  {TDBDate = longint;
  TDBTime = longint;}

  TBTDate = longint;
  TBTTime = longint;

  TPasTypeName = string[20];
  TPasTypeDef = record
    N:TPasTypeName;
    {T:integer;{order number of pascal type from dbimpexp}
    L:word;{size}
    T:byte;{type id; index in PasTypesDef}
  end;

  PTblDef = ^TTblDef;

  TGetTblDef = function:PTblDef;

  TTblDefRec = record
    TblName:TTblAlias;
    GetTblDef:TGetTblDef;
    {$IFDEF PMODE}
    Handle:THandle;{to DLL file}
    {$ENDIF}
  end;
  PTblDefRec = ^TTblDefRec;

  PTblDefTable = ^TTblDefTable;
  TTblDefTable = array[0..MaxTblCount - 1] of TTblDefRec;

  TRealNum = real;
  TDataSetState = byte;

{BTFiler specific types}
  BTIsamKeyStr = string[BTMaxKeyLen];
  {for IndexDef}
  TBTRecord = record
    Del:longint;
    Data:array[0..MaxRecordSize - 5] of byte;
  end;
  PBTRecord = ^TBTRecord;

  TKeyDef = packed record
    KeyL : 1..BTMaxKeyLen;
    AllowDupK : Boolean;
  end;
  TIndexDef = TKeyDef;
  TIndexesDef = array[1..BTMaxNrOfKeys] of TKeyDef; {=IsamIndDescr}

  {MY}
  TBTField = record {name defined in corresp. DBFField}
    T:integer;{pas type, see dbimpexp.psl}
    A:word;{offset in BT record}
    L:word;{byte;{size of the field (pascal type), must be word if size is 256}
  end;

  PBTField = ^TBTField;
  TBTFields = array[1..BTMaxNrOfFields] of TBTField;
  PBTFields = ^TBTFields;

  TFieldDef = record {additional field properties}
    Caption:PChar;
    Hint:PChar;
    AllowedValues:PChar;{list of allowed vals}
    Style:integer;{style of dbinput line}
    DefValue:PChar;{default value of the field in ascii representation}
    Picture:PChar;{mask of allowed chars for input line}
    AutoInc:boolean;{autoincrementing value upon every newrec?}
    Required:boolean;{must some value be entered in the field?}
    ListSource:PChar;{alias of lookup file, where allowed value
      of this field can be found, in keyfield}
    KeyField:PChar;
    ListField:PChar;
    HelpCtx:word;
    Enabled:boolean;
    Visible:boolean;
    MinLen:byte;
    ListAlias:PChar;
    { if <> '' then contains alias that should be used for
      ListSource file }
  end;

  TFieldsDef = array [1..BTMaxNrOfFields] of TFieldDef;
  PFieldsDef = ^TFieldsDef;

  TDefRecs = array[1..MaxDefRecs] of pointer;
  { Pole ukazatel na peddefinovan zznamy databze,
    konstanta tohoto typu vytvena MAKEDDF z definic
    objekt cnRecVal, cnFieldVal }
  PDefRecs = ^TDefRecs;
  { Ukazatel na TDefRecs }

  {/MY}

  {PIndexesDef = ^TIndexDef;}

{  TIndexesDef = array[1..MaxNrOfIndexes] of PIndexDef;
  PIndexesDef = ^TIndexesDef;}

{/BTFiler specific types}

  {/BTFiler}

  TTblEventID = integer;
  TTblResult = integer;
  TTblHandlerResult = integer;
  TTblType = integer;{see ttXXX above}
  TFldStrVal = string;
  TFldNumVal = TRealNum;
  TFldIntVal = longint;
  TFldNum = byte;
  TFldName = string[10];
  PFldName = ^TFldName;
  TTblDo = integer;

  TFieldCount = integer;
  PFieldCount = ^TFieldCount;
  TRecordCount = longint;
  PRecordCount = ^TRecordCount;

  PTbl = pointer;
  PPTbl = ^PTbl;
  PDataSet = pointer;
  {PDataView = pointer;}
  TTblProperty = integer;

  {TTblErrorProc = procedure(msg:string);}

  TTblEventsHandler = procedure(ATblEventID:TTblEventID; ATbl:PTbl);
  PTblEventsHandler = ^TTblEventsHandler;

  TTblEventHandler = procedure(ATbl:PTbl);{usru}
  PTblEventHandler = ^TTblEventHandler;

  TTblEventHandlers = array[0..MaxTblEventIDCount - 1] of TTblEventsHandler;
  PTblEventHandlers = ^TTblEventHandlers;

  TTblCreateKeyFunc = function(var P; KeyNr:word):BTIsamKeyStr;
  TTblBrowseHeaderFunc = function:string;
  TTblBrowseLineFunc = function(var P):string;

  {TTblGetFldStr = function(var P; AFldNum:TFldNum):TFldStrVal;
   TTblGetFldNum = function(var P; AFldNum:TFldNum):TFldNumVal;}


  PIndexesDef = ^TIndexesDef;{pointer;{specific structure for diffent table types}

  PTblRec = ^TTblRec;{typecaster for PTbl, just for debugging - view only!!!}
  TTblRec = record
    vmt:word;
    BaseAlias, Alias:TTblAlias;
    CurKeyNr :integer;
    CurRecNr :longint;
    CurKey: string[40];{IsamKeyStr;}
    TblDef:PTblDef;
    Modified:boolean;
    FName: string[192];{IsamFileBlockName;}
    TblState:TDataSetState;
    FUsedRecs:longint;
    PF:pointer;
    MaxError : Integer;
    RecordLocked : Boolean;
    FileBlockLocked : Boolean;
    RetryCount : Integer;
    LastError,
    LastResult:TTblResult;
    IgnoreNextError:integer;
    TempRec,
    OrigRec,
    CurRec,
    KeyRec,
    RangeStartRec,
    RangeStopRec,
    RecPtr : PByteBuffer;
  end;

  TTblDef = record
    TblType:TTblType;
    RecordSize:integer;{for BT record}
    IndexesDef:PIndexesDef;
    DBFIndexesDef:PDBFIndexesDef;
    IndexCount:integer;
    CreateKeyFunc:TTblCreateKeyFunc;

    FieldCount:TFieldCount;
    DBFFields:PDBFFields;
    BTFields:PBTFields;
{TblEvent handlers:}
    EventHandler:TTblEventsHandler;
    Info:pointer;{any additional data needed by specific table,
      can be allocated during init, disposed during done}
    AutoIncFld:integer;{if > 0 then number of field that should be
     autoincremented upon new rec}
    FieldsDef:PFieldsDef;
    DefRecCount:integer;
    DefRecs:PDefRecs;

    TimeType:integer;{mgrnu}
    DetailAlias:PChar;
    MasterAlias:PChar;
    Caption:PChar;
    Hint:PChar;
    DataCopies:PChar;
    PopupFields:PChar;
    DetailRecCount:longint;
    ViewProcName:PChar;
    MenuMask:PChar;{default for browwnd}
    StatusLineMask:PChar;{default for browwnd}
    EditViewProc:PChar;{default name of viewproc proc for record editwnd
                        and neweditwnd}
    BrowseEditViewProc:PChar;{default name of viewproc for broweditwnd}
    HeadHeight:integer;{default height of field labels for browsers
                        (usually =1), if > 1, then caption text is divided
                        in exactly this number of sections (i.e. add spaces
                        if you want to have words adjusted somehow)}
    ColumnSpaces:integer;{default number of spaces between columns
                        in browsers}
    SubIDFieldName:PChar;{pokud <> '' pak udv jmno
      pole, kter je zahrnuto v indexovm vrazu pro platnost od-do}
    BrowseHeaderFunc:TTblBrowseHeaderFunc;
    BrowseLineFunc:TTblBrowseLineFunc;
    {v1.16}
    IndexSuffix:PChar;
    HelpCtx: word;
    {/v1.16}
    (*Delphi Events:
         {
          AfterCancel,
          AfterClose,
          AfterDelete,
          AfterEdit,
          AfterInsert,
          AfterOpen,
          AfterPost,
          BeforeCancel,
          BeforeClose,
          BeforeDelete,
          BeforeEdit,
          BeforeInsert,
          BeforeOpen,
          BeforePost,
          OnCalcFields,
          OnNewRecord,
         }
    AfterCancel,
    { called after edit, if it was canceled and if there
      were any changes, as the last call before return to caller,
      If the dataset is not in Edit state or there are no changes pending,
      then Cancel will not activate the AfterCancel event.

      By assigning a method to this property, you can take any special
      actions required by the event.
    }

    AfterClose,
    { The AfterClose event is activated after a dataset is closed,
      either by calling the Close method or by setting the Active
      property to False. This event is the last action before Close
      returns to the caller. Typically, the AfterClose event handler
      closes any private lookup tables opened by the BeforeOpen event.}

    AfterDelete,
    { The AfterDelete event is activated when the dataset finishes a call
      to the Delete method. This event is the last action before Delete
      returns to the caller. When AfterDelete is called, the deleted record
      has already been removed from the dataset, and the dataset cursor will
      be positioned on the following record. }

    AfterEdit,
    { The AfterEdit event is activated when a dataset finishes a call to
      the Edit method. This event is the last action before Edit returns
      to the caller. Note: The event occurs before any changes have been
      made to the current record. }

    AfterInsert,
    { The AfterInsert event is activated when a dataset finishes a call
      to the Insert or Append methods. This event is the last action before
      Insert or Append returns to the caller. Note: This event occurs before
      a new record has been added to the component. }

    AfterOpen,
    { The AfterOpen event is activated after a dataset is opened, either by
      calling the Open method or by setting the Active property to True. This
      event is the last action before Open returns to the caller. }

    AfterPost,
    { The AfterPost event is activated after a call to the Post method. This
      event is the last action before Post returns to the caller. If a TTable
      has a range filter (set with ApplyRange) in effect, and if the key
      value of the newly posted record falls outside the range, then in the
      AfterPost event, the cursor will not be positioned on the newly posted
      record.}

    BeforeCancel,
    { The BeforeCancel event is activated at the beginning of a call to the
      Cancel method. This event is the first action taken by Cancel. If the
      dataset is not in Edit state or there are no changes pending, then
      Cancel will not activate the BeforeCancel event.

      !!! By raising an exception in this event handler, you can prevent the
      Cancel operation from occurring. !!!

      MY: set HandlerResult property if Tbl to something else then hrOK
          if you want prevent to operation to occur.}

    BeforeClose,
    { The BeforeClose event is activated before the dataset is closed,
      either by calling the Close method or by setting the Active property
      to False. This event is the first action taken by Close. }

    BeforeDelete,
    { The BeforeDelete event is activated when the dataset begins a call
      to Delete. This event is the first action taken by the Delete method. }

    BeforeEdit,
    { The BeforeEdit event is activated when the dataset begins a call to
      the Edit method. This event is the first action taken by Edit.}

    BeforeInsert,
    {The BeforeInsert event is activated when the dataset begins a call
     to the Insert or Append methods. This event is the first action taken
     by Insert or Append. }

    BeforeOpen,
    { The BeforeOpen event is activated before the dataset is opened,
      either by calling the Open method or by setting the Active property
      to True. This event is the first action taken by the Open method.
      Typically, the BeforeOpen event handler opens any private lookup
      tables used by other event handlers in the dataset.}

    BeforePost,
    { The BeforePost event is activated at the beginning of a call to the
      Post method. This event is the first action taken by the Post method,
      after it calls the UpdateRecord method to reflect any changes made
      to the record by data controls. The BeforePost event can be used to
      validate a record before it is posted. By raising an exception, a
      BeforePost event handler can prevent the posting of an invalid record. }

    OnCalcFields,
    { The OnCalcFields event is used to set the values of calculated fields.
      OnCalcFields is called when a dataset reads a record from the database.
      In addition, if the dataset's AutoCalcFields property is True,
      OnCalcFields is called when a non-calculated field is modified while the
      dataset is in Edit or Insert state. Typically, the OnCalcFields event
      will be called often, so it should be kept short. OnCalcFields should
      not perform any actions that modify the dataset (or the linked dataset
      if it is part of a Master-detail relationship), because this can lead
      to recursion. While the OnCalcFields event is executed, a dataset will
      be put in CalcFields state. When a dataset is in CalcFields state, you
      cannot set the values of any fields other than calculated fields. After
      OnCalcFields is completed, the dataset will return to its previous state.
      The first call to the OnCalcFields event handler may occur before all
      components in your application have been initialized. If your handler
      requires access to another component, use the Edit|Creation Order
      command to ensure that the components are created in the correct order.}

    OnNewRecord,
    { The OnNewRecord event is activated whenever a new record is added
      to the dataset. The event occurs after the BeforeInsert event and
      before the AfterInsert event. OnNewRecord enables you to initialize
      any fields of the record without marking the record as Modified.
      Any changes to the record after this event will cause Modified to
      be set. }
    {/Delphi Events}

    {MY BTree events}
    OnGetFldVal,
    { Called as the first in any call DBGetXXX(ATbl, J) with properties
      tmpFldType and tmpFldJ set according to the XXX (Str,Num,Int) and J,
      the handler MUST set HandlerResult to hrOK and set tmpXXX to the
      corresponding value from CurRecord, that will be returned by DBGetXXX
      call; if HandlerResult remain <> hrOK (=hrFailed) error message will
      appear}

    OnSetFldVal,
    { Called as the first in any call DBSetXXX(ATbl, J, ..) with properties
      tmpFldType and tmpFldJ and tmpXXX set according to the
      XXX(Str,Num,Int) and J.
      The handler MUST set HandlerResult to hrOK and update CurRecord with
      the new value; if HandlerResult unchanged (=hrFailed), error message
      will appear}

    OnGetFldJ,
    { Called in call DBGetFldJ(ATbl, AFldName), property tmpFldName set
      to AFldName; MUST set tmpFldJ to field number > 0 .
      if not such field name exist, set tmpFldJ = 0 (HandlerResult not
      checked here) }
    OnSetIndexName,
    { Called as the first in call DBSetProp(ATbl, tpIndexName, @string),
      Handler MUST set (by DBSetProp) HandlerResult hrOK if given index
      name known and set correctly as active; otherwise leave HandlerResult
      unchanged on hrFailed}
    OnGetIndexVal
    { Called in call getindexstr that creates from CurRecord indexvalue,
      props tmpIndexJ set to active index number before calling OnGetIndexVal;
      Handler MUST set tmpIndexVal to correct result and set HandlerResult
      to hrOK, otherwise (if HandlerResult left on value hrFailed),
      error message will appear and index will not be updated}
    {/MY BTree events}
    : TTblEventHandler;
    *)
  end;

const
{from filer\dbimpexp.psl}
{--FType}
  DelMarkFType           = #0;
    {-Not a dBASE field type, but describes the 1st byte of a dBASE record}
  DateFType              = 'D';
  CharFType              = 'C';
  LogicFType             = 'L';
  NumerFType             = 'N';
  FloatFType             = 'F';
  MemoFType              = 'M';

{$IFNDEF UseSymFlex}
{--CType}
  ReservedCType   = 0;
  BooleanCType    = 1;
  CharCType       = 2;
  ByteCType       = 3;
  ShortIntCType   = 4;
  IntegerCType    = 5;
  WordCType       = 6;
  LongIntCType    = 7;
  CompCType       = 8;
  RealCType       = 9;
  SingleCType     = 10;
  DoubleCType     = 11;
  ExtendedCType   = 12;
  StringCType     = 13;
  ArrayCType      = 14;
{$ENDIF}                                                        {!!.42}
{$IFNDEF SymFlexGE20}                                           {!!.42}
  AZStringCType   = 15;
  DateCType       = 16;
  TimeCType       = 17;
{$ENDIF}
{/from filer\dbimpexp.psl}
type
  TDetailsEditMode = byte;
{emXXXX}
const
{Details EditMode s:}
  emBrowse = 0;
  { Databze s detaily se pouze prohl }
  {Viz tpDetailTbl, tpTempDetailTbl}
  emAppend = 1;
  { V doasn databzi s detaily jsou detailn zznamy pro nov vytven
    zznam v master databzi }
  {Viz tpDetailTbl, tpTempDetailTbl}
  emEdit = 2;
  { V doasn databzi s detaily je kopie zznam z detailn databze
    pro aktuln zznam master databze a prv vybran obdob }
  {Viz tpDetailTbl, tpTempDetailTbl}
  emEditNewDateRange = 3;
  { V doasn databzi s detaily jsou zznamy pro nov obdob pro aktuln
    zznam v master databzi  }
  {Viz tpDetailTbl, tpTempDetailTbl}
{/emXXXX}

type
  TAliasSuffix = TTblAlias;
{asXXXX alias suffixes, used to open the same file under different
 aliases for different purposes }
const
  asInputLine = 'I'; { File opened for interactive choosing value
                       for inputline that belongs to other database }
  asBrowse = 'B';    { File opened for interactive browsing }
  {was  BrowseAliasSuffix = 'B';{'B';}

  { A letter added at the end of Tbl alias during creation
    of default DataSet for browse window (see DBBROW.PAS) }

  asEdit = 'E';
    { File opened for interactive editing of record }
  asRead = 'R';
    { File opened for noninteractive retrieving of data }
  asEditSelected = 'S';
    { Temp. file opened for editing temporary record, that will be
      copied to all currently selected records }
  asEditDetails = '$';
    { Temp. file opened for editing copy of part of details database
      in EditDetals dbgrid }
  asBrowseEdit = '$';
    { Temp. file opened for browsing a copy of file in dialog window }
  asSave = 'W';
  asReport = 'P';
  {v1.15}
  asArchive = 'V';
    { Alias and also data file suffix for archive files - files
      containing records deleted from the main data file }
  asBrowseSel = 'L';
    { Table opened for browsing and selecting of records interactively
      by user }
  {/v1.15}
{/asXXXX}

type
  TAliasExtension = string[4];{see aeXXXX}
{aeXXXX TAliasExtension - used to create special names for some Tbl files;
 use dbutl GetTblFileName method to create filename - the first param
 to TblInit (adds eventually underscores to pad basealias to 4 chars)}
const
  aeCurMonth = '0000';
{/aeXXXX}

type
  TEditSuffix = TTblAlias;
{esXXXX edit alias suffixes - special suffixes used in
 GuiEditRecord procedure as a part of the AAliasName - info
 for EditForm Wizard to fill proper FileName and Alise }
const
  esEditSelected = '_SEL';
{/esXXXX}

type
  TFileSuffix = TTblAlias;
{fsXXXX data file name suffixes:}
const
  fsTemp = '$';    { for temporary files that hold copy of records
                     during browse }
  fsTempSel = '$S'; { for temporary record used for editing
                      changes for selected records }

{/fsXXXX}

type
  TDataSetOption = byte;
{doXXXX dataset options - used in DBBrow.CreateDataSetDDF function,
 that creates default dataset for browse or edit window }
const
  doBrowse = 0;
     { Data set is beeing created for regular browser window using
       exactly the info contained in data DLL, asBrowse alias suffix }
  doInputLine = 1;
     { Data set will not contain relations, asInputLine alias suffix }
  doEdit = 2;
     { As doBrowse but for edit window, asEdit alias suffix }
  doEditSelected = 3;
     { As doBrowse but for edit for selected records window, asSelectedEdit alias suffix }
  doEditDetails = 4;
     { Dataset is created for details edit window, i.e. using tmp file }
  doBrowseEdit = 5;
     { DataSet is created for BrowseEdit method (i.e. using tmp file
       for browsing in dialog window) }
{/doXXXX}

{fnXXXX specialized Field Names }
const
  fnSelected = 'SELECTED';
  { Jmno pole zznamu databze typu L pouvan pro oznaen zznamu
    jako vybranho. Nen-li ptomno, lze v databzi vybrat pouze max.
    16000 zznam. Viz tpSelectRecord.}
  fnDetailCnt = 'DETAILCNT';
  { Jmno pole v zznamu master databze, kter je-li ptomno a jeho
    hodnota <> 0 uruje, kolik zznam se m vytvoit doasn databzi
    detail pi TblAppend(MasterTbl) (tj. tyto zznamu budou pidny
    k databzi detail pi TblPost(MasterTbl)). Jinak tento poet
    zznam uruje hodnota pnDetailRecCount zadan v definici databze
    a pstupn pes tpDetailRecCount }
{/fnXXXX}

type
  TSelectRecords = integer;
{srXXXX select records options for TTbl.SelectRecords,
  or TblDo(tdSelectRecords, srxxxx) }
const
  sr0 = 4000;
  srToggleCurrent = sr0 + 1;
    { Select/Unselect current record }
  srAll = sr0 + 2;
    { Select all records }
  srInvert = sr0 + 3;
    { Invert selection }
  srCancel = sr0 + 4;
    { Cancel all selections }
  srStart = sr0 + 5;
    { Marks current record as start of selection range
      (using current index) }
  srStop = sr0 + 6;
     { Causes marking all records between Selection Start Record
       and current record as selected (using current index) }

{/srXXXX}
type
  TOpenOptions = longint;

{ooXXXX OpenOptions for TblInit }
const
  ooNone = 0;
    { Just [DB].DefOpenOptions will be used }
  ooDefault = longint(1);
    { [DB].DefOpenOptions will be used to open the table
      and be ored with eventual other option flags submitted
      as TblInit param.}
  ooReadOnly = longint(2);
  ooAllReadOnly = longint(4);
    { This can be used only if all tbls are opened with this oo }
  ooSave = longint(8);
    { Open in save mode? (slow, dialog file maintained) }
  ooNetwork = longint($10);
    { Set automatically during TblInit On if NetUsed <> 0 }
  ooInteractive = longint($20);
    { Is the Tbl beeing browsed by user interactively? }
  ooOpenDetails = longint($40);
    { Should the details table be opened automatically? }
  ooUseDBuf = longint($80);
    { Should data buffer for loaded records be used? (supresses
      updating changes made by network processes, but speeds
      up substantially) }
  ooMonth = longint($100);
    { Should be opened month file - YYYYMM\xxxxYYMM ? (month specified
      in MONTH db global variable - use VarNameSetVal(dvMonth, monthstr)
      before call to TblInit(..., + ooMonth) ) }
  ooDateRange = longint($200);
    { tbl can go through more month files, starting with file YYYYMM\xxxxYYMM,
      (month specified in VARS.DATE1 var) and continue through more
      month files up to date VARS.DATE2. If TblNext returns end of file
      next month file is tried to open }
{/ooXXXX}

{fvXXXX field visible flags for ddftype pnVisible }
const
  fvNotVisible = 0;
  fvVisibleInNewEdit = 1;
  fvVisibleInEdit = 2;
  fvVisibleInBrowse = 4;
{/fvXXXX}
(* in dbutl :
const
  PasTypesDef:array[0..17] of TPasTypeDef =
  ({ReservedCType   = 0;}(N:'longint';L:4;T:0),
   {BooleanCType    = 1;}(N:'boolean';L:sizeof(boolean);T:1),
   {CharCType       = 2;}(N:'char';L:sizeof(char);T:2),
   {ByteCType       = 3;}(N:'byte';L:sizeof(byte);T:3),
   {ShortIntCType   = 4;}(N:'shortint';L:sizeof(shortint);T:4),
   {IntegerCType    = 5;}(N:'integer';L:sizeof(integer);T:5),{=2}
   {WordCType       = 6;}(N:'word';L:sizeof(word);T:6),{=2}
   {LongIntCType    = 7;}(N:'longint';L:sizeof(longint);T:7),{=4}
   {CompCType       = 8;}(N:'comp';L:sizeof(comp);T:8),{=8}
   {RealCType       = 9;}(N:'real';L:sizeof(real);T:9),{=6}
   {SingleCType     = 10;}(N:'single';L:sizeof(single);T:10),{=4}
   {DoubleCType     = 11;}(N:'double';L:sizeof(double);T:11),{=8}
   {ExtendedCType   = 12;}(N:'extended';L:sizeof(extended);T:12),{=10}
   {StringCType     = 13;}(N:'string';L:255;T:13),
   {ArrayCType      = 14;}(N:'array of char';L:255;T:14),
   {AZStringCType   = 15;}(N:'pchar';L:255;T:15),
   {DateCType       = 16;}(N:'longint';L:4;T:16),
   {TimeCType       = 17;}(N:'longint';L:4;T:17));
*)

type
  TSearchDirection = byte;
{sdXXXX}
const
  sdNone = 0;
  sdPrev = -1;
  sdNext = 1;
{/sdXXXX}

{btbrow.pas}

Const
  BRCurrentlyLocked = -1;
  BRNoFilterResult  = -2;
  BRFilterError     = -3;                                              {!!.42}
  BRUserStatStart   = -10;
  MaxCols           = 128;
  BRLMaxRows        = 255;
  MaxEltsPerRow     = 8;
  BRUnbreakedOpers  = 63;
  BRBreakDelay      = 50;
  NoError           = 0;
  DialogError       = 1;
  LockError         = 2;
  GenMaxKeyLen      = BTMaxKeyLen;
  GenMaxPosRef      = $7FFFFFFF;

Type
  TBBResult = integer; {see brXXXX}
  TBBProperty = integer;{see bpXXXX}
  TBBAction = integer;

  BRLRowEltString  = String [MaxCols];
  PBRLRowEltString = ^BRLRowEltString;
  RowString        = BRLRowEltString;
  BRLRowEltStrArr  = Array [1..MaxEltsPerRow] Of BRLRowEltString;
  GenKeyStr        = String [GenMaxKeyLen];

  PGenKeyStr = ^GenKeyStr;

  RowRecPtr = ^RowRec;
  RowRec = Record
  {-Read only part}
    IKS         : GenKeyStr;
    Ref         : LongInt;
    Status      : Integer;
  {-Internal use only}
    RowModified : Boolean;
    RowBuilt    : Boolean;
  {-To manipulate part}
    Case Boolean Of
      True  : (
        Row : RowString;
      );
      False : (
        RowElt : BRLRowEltStrArr;
      );
  End;

  {RowRecPtr = ^TRowRec; = PRowRec}

  BRBrowScreen = Array [1..BRLMaxRows] Of RowRecPtr;

  PBBrowser = pointer;

  PBBrowserRec = ^TBBrowserRec;
  TBBrowserRec = record
    NumberOfEltsPerRow  : Word;
    NumberOfRows        : Word;
    LKey,
    HKey                : GenKeyStr;
    SaveStat            : Boolean;
    {DatS:pointer;}
    IsVarRec            : Boolean
  end;

const
  NoBBrowser = nil;
{bpXXXX browser properties}
const
  bp0 = 5000;
  bpKeyNr = bp0 + 1; {TKeyNr}
  bpNrOfRows = bp0 + 2; {TNrOfRows}
  bpLastRow = bp0 + 3;{TNrOfRows}
  bpCurRow = bp0 + 4; {TNrOfRows}
  bpOtherAction = bp0 + 5;{boolean}
  bpBrowScreenState = bp0 + 6;{BrowScreenState}
  bpLowKey = bp0 + 7;{GenKeyStr}
  bpHighKey = bp0 + 8;{GenKeyStr}
  bpCurKey = bp0 + 9;{GenKeyStr}
  bpCurRecNr = bp0 + 10;{longint}
  bpStatus = bp0 + 11;{boolean}
{/bpXXXX}
{baXXXX browser actions (params to BBDo method)}
const
  ba0 = 6000;
  baPreCompletePage = ba0 + 1;
  baPostCompletePage = ba0 + 2;
  baShowErrorOccured = ba0 + 3;{AInfo = @EClass}
{/baXXXX}

type
  TDataSetProperty = integer ;
{dpXXXX DataSet properties}
const
  dp0 = 9000;
  dpRestoreRecordNr = dp0 + 1;
    { Restore original record number upon dataset done? (default true)
      DateSetSetProp(ds, dpRestoreRecordNr, @falseValue) will
      cause it won't; (only of did not open the tbl) }
  dpRestoreIndexNr = dp0 + 2;
    { Restore original active index upon dataset done? (default true)
      DateSetSetProp(ds, dpRestoreIndexNr, @falseValue) will
      cause it won't; (only of did not open the tbl)}
{/dpXXXX}
{brXXXX browser results}
const
  brOK = 0;
  br0 = 7000;
  brInitFailed = br0 + 1;
{/brXXXX}
type
  TKeyNr = word;
  PKeyNr = ^TKeyNr;

  TNrOfRows = word;
  PNrOfRows = ^TNrOfRows;

{from medbrows.pas:}
Type
  PBrowScreenState = ^BrowScreenState;
  BrowScreenState = Record
    STCurRow : Word;
    STNrOfRows : Word;
    STLastRow : Word;
  End;
{/from medbrows.pas:}

{/btbrow.pas}

{v1.16}
type
  TTblMatchFn = function(ATbl: PTbl): boolean;
  PTblMatchFn = ^TTblMatchFn;
    { used as filter function callback, should return true
      if current record of ATbl matches the condition }
{/v1.16}
{v1.15}
type
  TWhichRecords = integer;
    { used for TblScan to decide what records to scan }
{wrXXXX}
const
  wrAll = 0;
  wrSelected = 1;
  wrFocused = 2;
{/wrXXXX}
type
  TCopyFieldInfo = record
    FldName: TFldName;
    FromDate: TDateString;
  end;
  PCopyFieldInfo = ^TCopyFieldInfo;

type
  TTblScanOptions = record
  { for use with TblScan method; zero/nil/false (= 0) values are defaults }
    Size: word;
      { if non zero, specifies sizeof(TTblScanOptions), use
        if different versions of DB used }
    IndexName: TDBFFieldNameStr; {dbftype}
      { set if other than default index should be used,
        if set ' ' (or more spaces) - no index will be set. }
    BaseAlias: TTblAlias;
      { set if filename does not contain the basealias }
    DataDir: string;
      { set if tables in different than default DB datadir should be
        scanned }
    ProgressCaption: string[80];
      { set if other than default text (file name) should be shown
        in the progress box }
    ShowProgress: boolean;
      { should the progress box be shown during the scanning? }
    FastScan: boolean;
      { if:
        - no relations set
        - no ranges applied
        - reading only
        - no filter applied
        then this option can be used, then just the file is read
        record by record using specified index from start to end,
        with no unnecessary checking upon every record load }
    ScannedCount: longint;
      { set by the TblScan function to the number of records really
        scanned }
    MatchCount: longint;
      { set by the TblScan function to the number of records that
        matched the WhichRecords condition }
    Info: pointer;
      { Any info supplied by the user of TblScan method. Not used by
        TblScan itself in any way, can be used in the CallBack function. }
    WhichRecords: TWhichRecords;
      { set true if in callback method the current record can be
        deleted }
    DeletedCount: longint;
    Pack: boolean;
      { should pack the table if some deletions were made? }
    {v1.16}
    MatchFn: PTblMatchFn;
      { if non nil, then only the records also matching the MatchFn
        will be considered to be a match }
    StartKeyValue,
    StopKeyValue: BTIsamKeyStr;
      { if <> '' then define at what key value of current
        (or specified in IndexName)
        index should the scanning start or stop }
    {/v1.16}
  end;
  PTblScanOptions = ^TTblScanOptions;

{/v1.15}
{v1.16}
type
  TSelRecsOptions = longint;
{soXXXX options for dbu2.TblGetSelRecs }
const
  soOnlyFocused = 1;
    { if this option set, then recinfou . Recs will contain only
      record with RecID of the current Tbl record
      (does not have to be selected) }
  soSortedByID = 2;
    { if this option set, then records in Recs are sorted by RecID
      and RecsFindSrtID method can be used on the obtained Recs }
  soWholeRecords = 4;
    { if this option set, then copy of the whole tbl records is made
      to the memory block allocated and assinged to Rec^.Info field,
      size of Tbl records is stored in Recs.InfoSize field,
      Recs.InfoType is set to itBuffer and when called RecsDone, it
      gets deallocated automatically }
  soWithNames  = 8;
    { if this option set, then in RecInfo records in Recs is the
      Info field PString to then name of the tbl record
      (it is expected, that name of the tbl record is in its
      second field); Recs^.InfoType will be set to itPString
      and the memory allocated by the strings will be disposed
      during the RecsDone call.

      This option is ignored if soWholeRecords is specified. }
  soAllActiveRecords = $10;
    { not only selected records but all records matching current
      range or filter will be returned in Recs }
{/v1.16}
{/soXXXX options for dbu2.TblGetSelRecs }

const
  DefMenuMaskList = 'help print append delete edit';
  { Pedvolen hodnota pnMenuMask pro BrowWnd }
  DefStatusLineMaskList = 'edit append';
  { Pedvolen hodnota pnStatusLineMask pro BrowWnd }

  DBVersion = '1.20';

  { 1.04
    27.2.99
    - InitRelMaster - removed adding alias to exp. instead
      added UpdateDefaultTbl to DoCalcFields

    23.2.99
    - dbexp  GetDBExp pro '(' CutS misto inc(CurPos)
    15.2.99.
    - added SelectRecords method (tdSelectRecord)
    - added EditSelectedRecords in dbbrow
    9.2.99
    - TTbl.AutoPost field introduced, can be set false to
      trap errors - unwanted posting of changes during
      editing
    - enabled multiple calls to TTbl.Post, TTbl.Cancel, TTbl.Edit
      so that they can be called from Window's dbinput views
      as the response to cmTblxxx broadcasts
    - added missing SetTblState(tsBrowse) in TTbl.Cancel,
      also for other TblStates

    6.2.99
    - new config vars:
      TempDir, DataDir, DataDefDir
    - DLLLoad from DataDefDir
  }
  { 1.03    19.1.99
    - SetStr pro typ L umi 'T','Y','A'/'F','N' }
  { 1.02    17.1.99
    - DBExp odstranena strstrm.pas }
  { 1.01:
    - Tables^.DeleteTbl moved from TblDone to Tbl.Done
      (for the case of Tbl.Init fail) }

implementation
end.