unit Country;
{$I DEFINE.PAS}
interface
uses
  SysUtils, WinProcs,
  MyType, TVType, LogType, MyLib, Stru,
  {Editypes,} Globals,{logproc}
  txgh, LangType;

const
  Languages = 2;
    laUSA = 0;
    laCS = 1;

  Language:byte = laCS;

  CSNorms = 4;

    csKam = 0;
    csLat = 1;
    csUSA = 2;
    cs1250 = 3;

  CSNorm :Byte = cs1250;

type
  PUcase = ^TUCase;
  TUCase = array [128..255] of char;
  TCollate = array[0..255] of char;


const
  dfAuto = 255;
  dfUSA = 0;  {constanty pro DateFormat}
  dfEurope = 1;
  dfJapan = 2;
  dfRAW = 254;

  KamToOther:array[1..2] of TUCase=(
    ('','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'',''),
    ('C','','e','d','','D','T','c','e','E','L','I','l','l','','A','E','z',
'Z','','','O','u','U','y','','','S','L','Y','R','t','a','i','o','u',
'n','N','U','','s','r','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','','','',
'',''));

function TimeStringToTimeString(ATime:string; dfFrom, dfTo:word):string;
 {$IFDEF PMODE}export;{$ENDIF}

function gettxt(tx:word):string;

function LGTx(AInstance:TInstance; tx:TTx):string;


function upcase(ch:char):char;

function UppCase(s:string):string;

procedure UCase(var Buf; size:word);

procedure StripLetters(var Buf; size:word);

function locase(ch:char):char;

procedure proper(var buf; count:word);

procedure WinToDos(var buf; count:word);
procedure DosToWin(var buf; count:word);

{$IFDEF GHLINK}
function DataToDisp(s:string):string;{conversion
  from DataRecord chars to display, does nothing right now,
  conversions done during transfer}
{converts chars from sf to win fonts}
function DispToData(s:string):string;
{$ENDIF}

function GetDateName(AYear,AMonth,ADay:integer):string;
const
  Numbers : setofchar = ['0'..'9'];
  HexNumbers : setofchar = ['0'..'9','A'..'F','a'..'f'];
  Delimitors : setofchar = [' ',',',';',':','/','.'];
  Letters : setofchar = ['A'..'Z','a'..'z',
    '','','','','','','','','','','','','',
    '','','','','','','','','','','','','',
    '','','','','','','',''];

function CollateOrder(ch:char):byte;

procedure Init;{inits country dependent date/time related
strings - days, months names}

procedure Done;


function GetDateFormat:word;{returns dfUSA, dfEurope, etc see above}
function DateStringToDateString(ADate:TDateString; dfFrom, dfTo:word):TDateString;

{ $ TXGHCS.RES}
implementation
{$I ucaswin.inc}
{$I locaswin.inc}


const
  LCaseTbl : PUcase = nil;{PUCase(@locaswin);}
  UCaseTbl : PUcase = nil;{PUCase(@ucaswin);}
{$IFDEF CZ}
function gettxt(tx:word):string;
var st:string; {i:byte;}
begin
  st := 'Text nedefinovan';
  csnorm := csUSA;
  case tx of
    txNoHelp: st := '';
    txHelp: st := 'Npovda';
    txContents: st := 'Obsah';
    txIndex: st := 'Index';
    txBack: st := 'Zpt';
    txForward: st := 'Vped';
    txInformation: st := 'Informace';
    txNotEnoughMemory: st := 'Nedostatek pamti';
    txInsertDisketteNo: st := 'Vlote disketu .';
    txArchivingFiles: st := 'Probh archivace soubor';
    txCannotCreateDir: st := 'Nelze vytvoit adres';
    txFileNotFound: st := 'Nelze nalzt soubor';
    txRestoringFiles: st := 'Probh dekomprimace soubor';
    txJanuary: st := 'Leden';
    txJanuary + 1: st := 'nor';
    txJanuary + 2: st := 'Bezen';
    txJanuary + 3: st := 'Duben';
    txJanuary + 4: st := 'Kvten';
    txJanuary + 5: st := 'erven';
    txJanuary + 6: st := 'ervenec';
    txJanuary + 7: st := 'Srpen';
    txJanuary + 8: st := 'Z';
    txJanuary + 9: st := 'jen';
    txJanuary + 10: st := 'Listopad';
    txJanuary + 11: st := 'Prosinec';
  end;{langtype}

{  if (csnorm<>csKam) then begin
    for i:=1 to length(st) do if ord(st[i])>127 then st[i]:=kamtoother[csnorm,ord(st[i])];
  end;}
  gettxt:=st;
end;

{$ELSE}

function gettxt(tx:word):string;
var s:string;
begin
  s := LoadStr(tx);
  if s <> '' then
    gettxt := s
  else
    gettxt := 'Text ' + IntToStr(tx) + ' nedefinovn';
end;

function LGTx(AInstance:TInstance; tx:TTx):string;
begin
  LGTx := gettxt(tx);
end;
{$ENDIF}

{$IFDEF GHLINK}

{$IFDEF WINDOWS}
  { $I sfxtowce.inc}
  { $I wcetosfx.inc}
  { $I witoc895.inc}
{$ENDIF}

{ $I sfxtowce.inc}
{ $I wcetosfx.inc}
function DataToDisp(s:string):string;
var i:byte;
begin
{
  for i := 1 to length(s) do begin
    s[i] := sfxtowce[SFConvTable, ord(s[i])];
  end;
}
  DataToDisp := s;
end;

function DispToData(s:string):string;
var i:byte;
begin  {
  for i := 1 to length(s) do begin
    s[i] := wcetosfx[SFConvTable, ord(s[i])];
  end;}
  DispToData := s;
end;
{$ENDIF}


function upcase(ch:char):char;
begin
  if ch in ['a'..'z'] then
    dec(ch,32)
  else if ch>#127 then
    ch:= UCaseTbl^[ord(ch)];
{
  if ((language=laCS)and(csnorm<>csKam)) then begin
     if ord(ch)>127 then ch:=kamtoother[csnorm,ord(ch)];
  end;
}
  upcase:=ch;
end;

function UppCase(s:string):string;
begin
  UppCase := UpperCase(S);
end;

procedure UCase(var Buf; size:word);
var
  p:array[0..pred(MaxWord)] of char absolute Buf;
  i:word;
begin
   if Size = 0 then
     exit;
   for i := 0 to pred(size) do
     p[i] := upcase(p[i]);
end;

procedure StripLetters(var Buf; size:word);
var
  p:array[0..pred(MaxWord)] of char absolute Buf;
  i:word;
  b:char;
begin
  if size = 0 then
    exit;
  for i := 0 to size - 1 do begin
    b := p[i];
    case p[i] of
      '' : b := 'a';
      '': b := 'A';
      '': b := 'c';
      '': b := 'C';
      '': b := 'd';
      '': b := 'D';
      '': b := 'e';
      '': b := 'E';
      '': b := 'e';
      '': b := 'E';
      '': b := 'i';
      '': b := 'I';
      '': b := 'n';
      '': b := 'N';
      '': b := 'o';
      '': b := 'O';
      '': b := 'r';
      '': b := 'R';
      '': b := 's';
      '': b := 'S';
      '': b := 't';
      '': b := 'T';
      '': b := 'u';
      '': b := 'U';
      '': b := 'u';
      '': b := 'U';
      '': b := 'y';
      '': b := 'Y';
      '': b := 'z';
      '': b := 'Z';
    end;
    p[i] := b;
  end;
end;

function locase(ch:char):char;
{var i:byte;}
begin
  if ch in ['A'..'Z'] then
    inc(ch,32)
  else if ch > #127 then
    ch := LCaseTbl^[ord(ch)];
  locase:=ch;
end;

procedure proper(var buf; count:word);
var
  i:word;
  inword:boolean;
  p:pchar;
begin
  inword:=false;
  i:=0;
  p:= @buf;
  while i<count do begin
    if p^ in letters then begin
      if inword then
        p^:=locase(p^)
      else
        p^:=upcase(p^);
      inword:=true;
    end else
      inword:=false;
    inc(i);
    inc(p);
  end;
end;

{$I 852towce.inc}
{$I wceto852.inc}

procedure WinToDos(var buf; count:word);
var
  b:TCharBuffer absolute buf;
  i:word;
begin
  if count = 0 then
    exit;
  for i := 0 to count - 1 do begin
    b[i] := wceto852[ord(b[i])];
  end;
end;

procedure DosToWin(var buf; count:word);
var
  b:TCharBuffer absolute buf;
  i:word;
begin
  if count = 0 then
    exit;
  for i := 0 to count - 1 do begin
    b[i] := cp852towce[ord(b[i])];
  end;
end;

procedure UpperCaseBuf(var buf; count: word);
{ Convert a text buffer to all upper case letters, depending on Systemcountry.CodePage}
var bu: TEditBuffer absolute buf;i:word;
begin
  if count = 0 then
    exit;
  for i:=0 to pred(count) do begin
     bu[i] := upcase(bu[i]);
{
    if bu[i]>#127 then
     bu[i]:= Ucase^[ord(bu[i])]
    else if (bu[i] in ['a'..'z']) then dec(bu[i],32);
}
  end;
end;

procedure LowerCaseBuf(var buf; count: word);
{ Convert a string to all upper case letters }
var i:word; bu: TEditBuffer absolute buf;
begin
  for i:= 0 to pred(count) do begin
    bu[i] := locase(bu[i]);
{
    if bu[i] in ['A'..'Z'] then inc(bu[i],32);
}
  end;
end;


function GetDateName(AYear,AMonth,ADay:integer):string;
begin
  GetDateName := IntToStr(ADay) + '.' + IntToStr(AMonth) + '.'+ IntToStr(AYear);
end;

{$I coll1250.inc}

function CollateOrder(ch:char):byte;
begin
  CollateOrder := ord(coll1250[ord(ch)]);
end;

procedure Init;
var i:integer;
begin
  for i := 1 to 12 do begin
    LongMonthNames[i] := gettxt(txJanuary + pred(i));
    ShortMonthNames[i] := copy(LongMonthNames[i], 1, 3);
  end;
  for i := 1 to 7 do begin
    LongDayNames[i] := gettxt(txSunday + pred(i));
    ShortDayNames[i] := copy(LongDayNames[i],1,2);
  end;
end;

procedure Done;
begin
end;

function GetDateFormat:word;
begin
  GetDateFormat := GetProfileInt('[intl]', 'iDate', dfUSA);
end;

(* win.ini [intl] section:
[intl]
sLanguage=csy
sCountry=United States
iCountry=1
iDate=0 (mm/dd/yy)
iTime=1
iTLZero=0
iCurrency=0
iCurrDigits=2
iNegCurr=0
iLzero=1
iDigits=2
iMeasure=0
s1159=
s2359=
sCurrency=$  (currency sign)
sThousand=, (thousands separator)
sDecimal=. (decimal separator)
sDate=/   (date separator)
sTime=:  (time separator)
sList=, (list separator)
sShortDate=M/d/yy
sLongDate=dddd, MMMM dd, yyyy
*)
{$IFDEF WIN32}
{$HINTS OFF}
{$ENDIF}
function DateStringToDateString(ADate:TDateString; dfFrom, dfTo:word):TDateString;
var
  year, month, day:word;
  code:integer;
  p:byte;
  s:string;
const
  USASep = '/';
  EuropeSep = '.';
  JapanSep = '.';
begin
  DateStringToDateString := '';
  if dfFrom = dfAuto then
    dfFrom := GetDateFormat;
  if dfTo = dfAuto then
    dfTo := GetDateFormat;
  case dfFrom of
    dfUSA: begin {mm/dd/yyyy}
      p := pos(USASep, ADate);
      if p = 0 then
        exit;
      val(trim(copy(ADate,1,pred(p))),month,code);
      if code <> 0 then
        exit;
      s := copy(ADate, succ(p), 255);
      p := pos(USASep, s);
      if p = 0 then
        exit;
      val(trim(copy(s, 1, pred(p))), day, code);
      if code <> 0 then
        exit;
      s := copy(s, succ(p), 255);
      val(trim(s), year, code);
      if code <> 0 then
        exit;
    end;

    dfEurope: begin
      p := pos(EuropeSep, ADate);
      if p = 0 then
        exit;
      val(trim(copy(ADate, 1, pred(p))), day, code);
      if code <> 0 then
        exit;
      s := copy(ADate, succ(p), 255);
      p := pos(EuropeSep, s);
      if p = 0 then
        exit;
      val(trim(copy(s, 1, pred(p))), month, code);
      if code <> 0 then
        exit;
      s := copy(s, succ(p), 255);
      val(trim(s), year, code);
      if code <> 0 then
        exit;
    end;

    dfRAW: begin
      val(copy(ADate,1,4),year,code);
      if code <> 0 then
        exit;
      val(copy(ADate, 5, 2), month, code);
      if code <> 0 then
        exit;
      val(copy(ADate, 7, 2), day, code);
      if code <> 0 then
        exit;
    end;

    dfJapan:begin
      p := pos(JapanSep, ADate);
      if p = 0 then
        exit;
      val(trim(copy(ADate,1, pred(p))), year, code);
      if code <> 0 then
        exit;
      s := copy(ADate, succ(p), 255);
      p := pos(JapanSep, s);
      if p = 0 then
        exit;
      val(trim(copy(s, 1, pred(p))), month, code);
      if code <> 0 then
        exit;
      val(trim(copy(s, succ(p), 255)), day, code);
      if code <> 0 then
        exit;
    end;
  end;


  if year < 100 then begin
    if year > 79 then
      year := year + 1900
    else
      year := year + 2000;
  end;

  case dfTo of
    dfUSA : s := lzero(IntToStr(month),2) + USASep + lzero(IntToStr(day), 2) +
      USASep + IntToStr(Year);
    dfEurope : s := lzero(IntToStr(day),2) + EuropeSep + lzero(IntToStr(month),2) +
      EuropeSep + IntToStr(Year);
    dfJapan : s := IntToStr(Year) + JapanSep + lzero(IntToStr(Month),2) +
      JapanSep + lzero(IntToStr(Day),2);
    dfRAW : s := IntToStr(Year) + lzero(IntToStr(month),2) + lzero(IntToStr(day),2);
  end;

  DateStringToDateString := s;
end;

function TimeStringToTimeString(ATime:string; dfFrom, dfTo:word):string;
var h,m,s:word;{code:integer;}p:byte;
const TimeDelim = ':';
begin
{  h := 0;}
{  m := 0;}
{  s := 0;}
  if dfFrom = dfAuto then
    dfFrom := GetDateFormat;
  if dfTo = dfAuto then
    dfTo := GetDateFormat;
  case dfFrom of
    dfUSA, dfEurope, dfJapan: begin
      ignorechars([' '], ATime, 1, true);
      p := pos(TimeDelim, ATime);
      if p = 0 then
        p := length(ATime) + 1;
      h := strtoint(copy(ATime, 1, p - 1));
      ATime := copy(ATime, p + 1, 255);
      p := pos(TimeDelim, ATime);
      if p = 0 then
        p := length(ATime) + 1;
      m := strtoint(copy(ATime, 1, p - 1));
      ATime := copy(ATime, p + 1, 255);
      s := strtoint(ATime);
      ATime := lzero(inttostr(h),2) + lzero(inttostr(m), 2) + lzero(inttostr(s),2);
    end;
    dfRAW : begin
      if ATime <> '' then begin
        insert(TimeDelim, ATime, 3);
        insert(TimeDelim, ATime, 6);
        if strtoint(copy(ATime, 7, 2)) = 0 then
          delete(ATime, 6, 3);
      end;
    end;
  end;
  TimeStringToTimeString := ATime;
end;
{$IFDEF WIN32}
{$HINTS ON}
{$ENDIF}
begin
  LCaseTbl := PUCase(@locaswin);
  UCaseTbl := PUCase(@ucaswin);
end.
