unit Led;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TFarbe = (Red,Yellow,Green,Blue); // Neuer Typ fr Objectinspektor
  TOnOff = Boolean;          // Neuer Typ fr Objectinspektor
  TLed = class(TGraphicControl)
  private
    { Private-Deklarationen }
  FarbWert : Byte;
  Zustand : Byte;
  protected
    { Protected-Deklarationen }
   function GetFarbe: TFarbe;
   procedure SetFarbe (Farbe: TFarbe);
   procedure Paint; override;
   function GetOnOff: TOnOff;
   procedure SetOnOff (OnOff: TOnOff);
  public
    { Public-Deklarationen }
  constructor Create(AOwner: TComponent); override;

  published
  { Published-Deklarationen }
  property Width default 20;
  property Height default 10;
  property Farbe: TFarbe read GetFarbe write SetFarbe default Green;
  property OnOff: Boolean read GetOnOff write SetOnOff default False;
  end;

//procedure Register;
//------------------------------------------------------------------------------
implementation

constructor TLed.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 22; // Wiete 22 Pixel
  Height := 12;   // Hhe 12 Pixel
  Farbe := green;  // Anfangswert Grn zuweisen
  OnOff := False;  // Anfangswert Aus zuweisen
  end;

function TLed.GetFarbe: TFarbe; // Farbe In Objectinspektor anzeigen
begin
Result := TFarbe(Farbwert);
end;

procedure TLed.SetFarbe (Farbe: TFarbe); // Farbwert Setzen
begin
Case Farbe of
Red: Farbwert := 0;
Yellow: Farbwert := 1;
Green: Farbwert := 2;
Blue: Farbwert := 3;
end;
Invalidate;    // Komponente Neu zeicnen ( Paint Methode aufrufen )
end;

function TLed.GetOnOff: TOnOff; // Zustand im Objectinspektor anzeigen
begin
Result := TOnOff(zustand);
end;
                                          // zustand setzen
Procedure TLed.SetOnOff(OnOff: TOnOff);

begin
Case OnOff of
False : zustand := 0;
True  : zustand := 1;
end;
Invalidate;    // Komponente Neu zeicnen ( Paint Methode aufrufen )
end;
Procedure TLed.Paint;
{var
{Farbe: TFarbe;
OnOff: TOnOff;}
begin
Canvas.Pen.Width := 1;                        // Den Rahmen Fr die led Zeichnen
Canvas.Pen.Color := clWhite;                  //             |
Canvas.Brush.Color := clWhite;                //             |
Canvas.Rectangle(0,0,Width,Height);           //             |
Canvas.Pen.Color := clGray;                   //             |
Canvas.Brush.Color := clGray;                 //             |
Canvas.Rectangle(1,1,Width,Height);           //             |
Canvas.Pen.Color := clSilver;                 //             |
Canvas.Brush.Color:= clSilver;                //             |
Canvas.Rectangle(1,1,Width - 1,Height - 1);   //             |
Canvas.Pen.Color := clWhite;                  //             |
Canvas.Brush.color := clWhite;                //             |
Canvas.Rectangle(2,2,Width - 2,Height - 2);   //             |
Canvas.Pen.Color := clGray;                   //             |
Canvas.Brush.Color := clGray;                 //           \ | /
Canvas.Rectangle(2,2,Width - 3,Height - 3);   //            \|/ Bis Hier

case FarbWert of                          // Farb wert zu stimmen
  0:   begin
       if zustand = 1  then
       begin
       Canvas.Pen.Color := clRed;
       Canvas.Brush.Color := clRed;
       end
       else
       begin
       Canvas.Pen.Color := clMaroon;
       Canvas.Brush.Color := clMaroon;
       end
       end;

  1: begin
        if zustand = 1  then
        begin
        Canvas.Pen.Color := clYellow;
        Canvas.Brush.Color := clYellow;
        end
        else
        begin
        Canvas.Pen.Color := clOlive;
        Canvas.Brush.Color := clolive;
        end
        end;

  2: begin
         if zustand = 1  then
         begin
         Canvas.Pen.Color := clLime;
         Canvas.Brush.Color := clLime;
         end
         else
         begin
         Canvas.Pen.Color := clGreen;
         Canvas.Brush.Color := clGreen;
         end
         end;

  3: begin
         if Zustand = 1  then
         begin
         Canvas.Pen.Color := clBlue;
         Canvas.Brush.Color := clBlue;
         end
         else
         begin
         Canvas.Pen.Color := clNavy;
         Canvas.Brush.Color := clNavy;
         end
         end;
  end; // end Case
Canvas.Rectangle(3,3,Width - 3,Height - 3);
end;

//procedure Register;
//begin
//  RegisterComponents('Elektro', [TLed]);
//end;

end.
