unit PrintDr2;
{
	This unit is the progress bar form that can be shown during printing. When the
  ShowProgressBar value is set to true, this form is displayed during the initial
  printing instructions that get stored, and then during the actual printing sequence
  to the printer. There are two ways that the progress bar can be changed:

  	1. UpdateBar: This allows you to set the value of the progress bar directly.
    2. IncBar: This allows you to increment the value of the progress bar by the
    						value passed.

  The TMWPrintObject component provides three ways to increment the progress bar. The
  first two as outlined above, and a third that sends the automatic increment value
  to the IncBar procedure.
}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Gauges, StdCtrls, ExtCtrls, ComCtrls, Buttons;

const
  SC_DragMove = $F012;  { a magic number }

type
  TPrintBarForm = class(TForm)
    PrintPanel: TPanel;
    PrintCaption: TLabel;
    Panel2: TPanel;
    PrintBar: TProgressBar;
    CancelBtn: TBitBtn;
    procedure CancelBtnClick(Sender: TObject);

  private
    { Private declarations }

  public
    { Public declarations }
    {	The difference between UpdateBar and IncBar is that UpdateBar will
    	set the progress bar to a specific value and IncBar will add the value
      to the current progress value. Either can be used by the program.
    }
    procedure UpdateBar(x: integer);
    procedure IncBar(x: integer);
    procedure SetDisplayText(s: string);
  end;

var
  PrintBarForm: TPrintBarForm;
  BarPrn: TObject;

implementation

{$R *.DFM}
uses PrintDrv;

procedure TPrintBarForm.CancelBtnClick(Sender: TObject);
begin
  TMWPrintObject(BarPrn).OnCancelPrint;
end;

procedure TPrintBarForm.IncBar(x: integer);
begin
	with PrintBar do
		if (Position + x) > Max then
  		Position := Max
  	else
  		Position := Position + x;
  Update;
  Application.ProcessMessages;
end;

procedure TPrintBarForm.SetDisplayText(s: string);
begin
	PrintCaption.Caption := s;
  Update;
  Application.ProcessMessages;
end;

procedure TPrintBarForm.UpdateBar(x: integer);
begin
	PrintBar.Position := x;
  Update;
  Application.ProcessMessages;
end;


end.
