unit CalibrationFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, UlanType;

type
  TCalibrationForm = class(TForm)
    CalibrationTypeRadioGroup: TRadioGroup;
    OKButton: TButton;
    FileNameEdit: TEdit;
    Label1: TLabel;
    procedure OKButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  CalibrationForm: TCalibrationForm = nil;

function ComposeCalibrationFormExecute(var AFileName: string; var CalibrationType: TComposeCalibrationType): boolean;

implementation

{$R *.DFM}

function ComposeCalibrationFormExecute(var AFileName: string; var CalibrationType: TComposeCalibrationType): boolean;
begin
  if CalibrationForm = nil then
    CalibrationForm := TCalibrationForm.Create(Application);
  CalibrationForm.CalibrationTypeRadioGroup.ItemIndex := ord(CalibrationType);
  CalibrationForm.FileNameEdit.Text := AFileName;
  if CalibrationForm.ShowModal = mrOK then begin
    CalibrationType := TComposeCalibrationType(CalibrationForm.CalibrationTypeRadioGroup.ItemIndex);
    AFileName := CalibrationForm.FileNameEdit.Text;
    Result := true;
  end else begin
    Result := false;
  end;
end;

procedure TCalibrationForm.OKButtonClick(Sender: TObject);
begin
  if FileNameEdit.Text = '' then begin
    ShowMessage('Enter name for the composed calibration file');
    ModalResult := 0;
    exit;
  end;
end;

end.
