unit Langu;{to delete}x
interface
uses
  Classes, Forms, ULRecTyp, ULObju, ULObjUsru,
  TypInfo,
  LNGType, LNGObju,
  LNGTType, LNGTObju;

type
{  TLangText = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetLNGT: TLNGTObj;
  public
    property LNGT: TLNGTObj read GetLNGT;
  end;
}
  TLang = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetLNG: TLNGObj;{aaprgu}
    procedure DoAfterCreate;override;
  public
    procedure Scan;
      { Scan application and its forms for all text properties and store them
        (if does not contain them yet }
    procedure UpdateForm(AForm: TForm);
      { update form's texts }
    property LNG: TLNGObj read GetLNG;
  end;

procedure LangInit;

implementation


{procedure TLang.UpdateDefDirs;
begin
  Obj.FindField('MethodFileName').FldDesc.DefDir := Obj.ObjDesc.DefDir;
end;}

{TLang}
function TLang.GetRecID: TULRecID;
begin
  Result := LNGID;
end;

procedure TLang.DoAfterCreate;
begin
  ControlChilds := false;
end;

function TLang.GetLNG: TLNGObj;
begin
  Result := TLNGObj(Obj);
end;

procedure TLang.UpdateForm(AForm: TForm);
begin
end;

procedure TLang.Scan;
var
  fi, ci: integer;
  f: TForm;
  c: TComponent;

  n: string;
  v: AnsiString;

  fn, cn: string;

  lngt: TLNGTObj;


  procedure ScanComponent(const APathName: string; c: TComponent);
  ti: PTypeInfo;
  td: PTypeData;
  pl: TPropList;
  pi: PPropInfo;
  j: integer;
  var ci: integer;
  begin
    {see proputl}
    ti := PTypeInfo(c.ClassInfo);
    td := PTypeData(GetTypeData(ti));
    GetPropInfos(ti, @pl);
    for j := 0 to td^.PropCount - 1 do begin
      pi := pl[j];
      case pi^.PropType^^.Kind of
        tkString, tkLString, tkWString: begin
          n := fn + '.' + cn + '.' + pi^.Name;
          v := GetStrProp(c, pi);

          lngt := TLNGTObj(Obj.Add(LNGTID));
          lngt.TextName := n;
          lngt.TextValue := v;

        end;
      end;
    end;

    for ci := 0 to c.ComponentCount - 1 do begin
      c := f.Components[ci];
      cn := c.Name;
      if cn = '' then
        cn := c.ClassName;


    end

begin
  for fi := 0 to Application.ComponentCount - 1 do begin
    f := TForm(Application.Components[fi]);
    if not (f is TForm) then
      continue;
    fn := f.Name;
    if fn = '' then
      fn := f.ClassName;
    n := fn;
    ScanComponent(n, f);
  end;
end;

{/TLang}

{TLangText}
{
function TLangText.GetRecID: TULRecID;
begin
  Result := LNGTID;
end;

function TLangText.GetLNGT: TLNGTObj;
begin
  Result := TLNGTObj(Obj);
end;}
{/TLangText}

const
  FLang: TLang = nil;

procedure LangInit;
begin
  if FLang = nil then begin
    FLang := TLang.Load('');
    FLang.Scan;
  end;
end;

initialization
  RegisterClasses([TLang]);
end.
