unit ulmaglob;{Chromulan initialization/deinitialization global procedures}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  Classes, Forms,{v0.31} SysUtils,{/v0.31}
  WinUtl,
  LogType, Logu, {v0.19} PortLog,{/v0.19}
  {v0.48}UtlType{/v0.48 ConfType}, Confu,
  ULDrvTyp, ULDriver, DrvLogu,
  ul_lcabs, ModuType, Modulu{v0.14}, Channelsu, ExtDevIntu{/v0.14}
  {v0.23}, UlanGlob{/v0.23}{v0.24},AAAu{/v0.24}{v0.25},ExeLogu{/v0.25}
  {v0.59},Processoru{/v0.59};

const
{ini.lst}
  UVDetAddr:longint = 3;
    { ulan device address of UV detector }
  UVDetSII:PScanInputInfo = nil;
    { handle for receiving data from UV detector }
{/ini.lst}
  IsInTimer:boolean = false;
    { recursion preventer for ulMDoTimer event }


function ulMInit(InitRcv:boolean):boolean;
  { ulMaster initialization, called from ulMaster main window create,
    opens ini file, opens log files }

function ulMDoTimer:boolean;
  { timer triggered method }

function ulMDone:boolean;
  { ulMaster deinitialization, called from ulMaster main window destroy,
    closes log files, ini file }

implementation

{const
  GlobalVars: PVarRecordArray = nil;}

function ulMInit(InitRcv:boolean):boolean;
begin
{  GetMem(GlobalVars, sizeof(TVarRecordArray) * MaxVarsCount);
  ConfigSetGlobals(GlobalVars, MaxVarsCount); ulanglob}
  LogRegister;
  ConfigInit(Application.ExeName);
  {v0.23}
  UlanConfigReadWrite(rwRead);
  {/v0.23}
  {v0.24}{/v0.24 SysLogInit;}
  DrvLogInit;
  {v0.14}
  ExtDevs := TExtDevs.Create;
  Modules := TModules.Create;
  Channels := TChannels.Create;
  {/v0.14}
  if InitRcv then
    RcvInit(UVDetSII, {v0.31}IntToStr(UVDetAddr){/v0.31 UVDetAddr});
  {v0.19}
  PortLogInit;
  {/v0.19}
  ulMInit := true;
end;


function ulMDoTimer:boolean;
begin
  ulMDoTimer := false;
  if IsInTimer then begin
    {v0.25}
    ExeLog.Log('ulmaglob.ulMDoTimer tried to call recursively');
    {/v0.25}
    exit;
  end;
  try
    IsInTimer := true;
    if Modules <> nil then begin
      Modules.DoTimer;
    end;
    RcvRun(UVDetSII);
    ulMDoTimer := true;
  finally
    IsInTimer := false;
  end;
end;

function ulMDone:boolean;
begin
  {v0.24}
  AAAFree;
  {/v0.24}
  {v0.23}
  UlanConfigReadWrite(rwWrite);
  {/v0.23}
  ConfigDone;
  RcvDone(UVDetSII);
  {v0.59}
  ProcessorsFree;
  {/v0.59}
  {v0.14}
  ClassFree(Channels);
  {/v0.14}
  ClassFree(Modules);
  {v0.14}
  ClassFree(ExtDevs);
  {/v0.14}
  {v0.19}
  PortLogDone;
  {/v0.19}
  DrvLogDone;
  {v0.24}{/v0.24 SysLogDone;}
  ulMDone := true;
end;

end.
