program makecosr;
{$APPTYPE CONSOLE}
{make pascal constant declaration from file}
uses
  SysUtils;

procedure MakeConstantSource(const AFileName: string);
var
  src: file of byte;
  dest: text;
  b: byte;
  i:integer;
  fs:integer;
begin
  assignfile(src, AFileName);
  reset(src);
  if ioresult <> 0 then begin
    writeln(AFileName, ' not found.');
    exit;
  end;
  fs := FileSize(src);

  assignfile(dest, ChangeFileExt(AFileName, '.INC'));
  rewrite(dest);
  if ioresult <> 0 then begin
    writeln('Can not open ' + ChangeFileExt(AFileName, '.INC'));
  end;

  writeln(dest, 'const');
  writeln(dest, '  ' + ChangeFileExt(ExtractFileName(AFileName), '') + ': array[0..'+
    IntToStr(fs-1) + '] of byte = (');
  write(dest, '  ');
  for i := 0 to fs - 1 do begin
    read(src, b);
    write(dest, b:3);
    if i < fs - 1 then
      write(dest, ',');
    if (i + 1) mod 16 = 0 then begin
      writeln(dest);
      write(dest, '  ');
    end;
  end;
  writeln(dest, ');');
  closefile(src);
  closefile(dest);
end;

begin
  if paramcount = 0 then begin
    writeln('Usage: makecosr filename');
    writeln;
    writeln('Will create pascal source file named FileName.INC with declaration:');
    writeln('const FileName: array[0..SizeOfFile-1] of byte = (');
    writeln('  x1, x2, ... );');
    writeln;
    writeln('Can be used to include binary file into pascal unit (component), and');
    writeln('create the file at runtime.');
  end else begin
    MakeConstantSource(paramstr(1));
  end;
end.
