program wl;
{$i define.pas}
uses SysUtils, Windows, wlu, dllutl;
type {hinstance}
  tstat = record
    h: integer;
    p: pointer;
    proc: TDLLMethod;
    res:integer;
    s: shortstring;
  end;

var
  stat:array[1..2] of tstat;

procedure Start(i:integer);
begin
  with stat[i] do begin
    res := -1;
    h := LoadLibrary('wld');
    if h = 0 then
      exit;
    p := GetProcAddress(h, 'w');
    if p = nil then
      exit;
     proc := p;
    s := 'b ulanlib wl test';{getmodulehandle dllutl}
    res := proc(@s);
    if res <> 0 then begin
      writeln('WLD.DLL result = ' + IntToStr(longint(res)));
    end else begin
      writeln('b OK');
    end;
  end;
end;

procedure Stop(i:integer);
begin
  with stat[i] do begin
    s := 'e ulanlib wl text';
    if res = 0 then begin
      res := proc(@s);
      if res <> 0 then begin
        writeln('WLD.DLL result = ' + IntToStr(longint(res)));
      end else begin
        writeln('e OK');
      end;
    end else begin
      writeln('e not called');
    end;
    if h <> 0 then begin
      FreeLibrary(h);
      h := 0;
    end;
  end;
end;

procedure testdll;
var i: integer;
begin
  for i := 1 to 2 do begin
    Start(i);
  end;
  for i := 2 downto 1 do begin
    Stop(i);
  end;
  readln;
end;

var
  s: shortstring;
  res: pointer;
begin
  if paramcount = 0 then begin
    writeln;
    writeln('Usage: wl {b,e,c,s,r}[RRRRMMDDHHMMSS] [comment] [X=test_dll]');
    writeln;
    writeln('Work time Log program version ' + WLVersion + ':');
    writeln;
    writeln('wl b ... begin - call at the work start');
    writeln('wl e ... end   - call at the work end');
    writeln('wl s ... suspend');
    writeln('wl r ... resume');
    writeln('wl c ... calculate time spent on the work');
    writeln('         wl c[[to]day|week|month|year|fRRRR[MMDDHHMMSS]tRRRR[MMDDHHMMSS]]');
    writeln('         supported (f - from, t - to)');
    writeln;
    writeln('If called in the wrong order, warning is given.');
    writeln('Creates ' + LogName + ' ASCII - human readable file.');
    writeln;
  end else begin
    s := paramstr(1) + ' ' + paramstr(2);
    if paramstr(3) <> 'X' then
      w(s)
    else begin
      testdll;
    end;
  end;
end.
