{ ========================================================================
  Unit: ClrGrid;
  VCL: TColorStringGrid
  Version 1.1
  Copyright (C) 1995, Keith Hawes

  I have seen many requests for a TStringGrid that supports color!
  TColorStringGrid adds an OnGetCellColor event to TStringGrid allowing you
  to set the attributes of the Brush and Font for each cell just before the
  text is drawn.
  ========================================================================
  Files:
    ClrGrid.pas    Source for TColorStringGrid
    ClrGrid.DCR    Resource containing Component bitmap

  To Install:
  1)  Copy/Move ClrGrid.Pas & ClrGrid.DCR to a directory
      (i.e. C:\DELPHI\SOURCE\MY_VCL)
  2)  Run Delphi and select the Tools|Install Components menu option.
  3)  In the 'Search Path' add the directory where you copied the files.
  4)  Click on Browse and locate the ClrGrid.Pas file. Hit OK.
  5)  Click on OK to rebuild your Component library (COMPLIB.DCL).

  Just set the properties of ABrush and/or AFont based on ARow and ACol
  For Example:

  procedure Tform1.gridGetCellColor(Sender: TObject; ARow, ACol: Longint;
                                    ABrush: TBrush; AFont: TFont);
  Var
    Value: integer;
  begin
    if (sender is TStringGrid) then
    begin
      try
        Value := StrToInt((Sender as TStringGrid).Cells[ACol, ARow]);
      except
        Value := 0;
      if Value < 0 then
        ABrush.Color := clRed;
    end;
  end;

  ========================================================================
  You may use TColorStringGrid any way you like but don't blame me.
  The code is copyrighted but released into the public domain although I
  will not complain if you wish to send me any compensation for my efforts.

  Keith Hawes
  khawes@ccmail.com

  ========================================================================
  History:
    Version 1.0
       Sept 12, 1995  First release, Response to post in
                      comp.lang.pascal.delphi.misc.
    Version 1.1
       Sept 13, 1995  Fixed Bug in DrawCell -- Pass Canvas.Font not Font.
                      Added AState to OnGetCellColor.
                      Added an Icon for the Component Palette

  ========================================================================}

unit Clrgrid;

interface
uses winTypes, classes, Graphics, grids;

type
  TColorEvent = procedure (Sender: TObject; ARow, ACol: Longint;
                           AState: TGridDrawState;
                           ABrush: TBrush; AFont: TFont ) of object;

  TColorStringGrid = class(TStringGrid)
  private
    FonGetCellColor: TColorEvent;
  protected
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect;
              AState: TGridDrawState); override;
  Published
    property OnGetCellColor: TColorEvent read  FOnGetCellColor
                                         write FOnGetCellColor;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples',[TColorStringGrid]);
end;

procedure TColorStringGrid.DrawCell(ACol, ARow: Longint; ARect: TRect;
          AState: TGridDrawState);
begin
  if Assigned(FOnGetCellColor) then
    FOnGetCellColor(Self, ARow, ACol, AState, Canvas.Brush, Canvas.Font);
  inherited DrawCell(ACol, ARow, ARect, AState);
end;

end.
